/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.tool;

import au.org.ala.spatial.composer.tool.ToolComposer;
import au.org.ala.spatial.dto.FieldDTO;
import au.org.ala.spatial.util.CommonData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Combobox;
import org.zkoss.zul.Comboitem;

public class TabulationComposer
extends ToolComposer {
    private static final Logger LOGGER = Logger.getLogger(TabulationComposer.class);
    private Combobox cbTabLayers1;
    private Combobox cbTabLayers2;
    private Combobox cbTabType;
    private Map<FieldDTO, List<FieldDTO>> tabLayers;
    private Map<String, List<String>> tabLayerDisplayNames;

    public void afterCompose() {
        super.afterCompose();
        this.selectedMethod = "Tabulation";
        this.totalSteps = 1;
        this.updateWindowTitle();
        this.cbTabLayers1.setFocus(true);
        this.tabLayers = new HashMap();
        this.tabLayerDisplayNames = new HashMap();
        try {
            HttpClient client = new HttpClient();
            GetMethod get = new GetMethod(CommonData.getLayersServer() + "/tabulations.json");
            get.addRequestHeader("Accept", "application/json");
            client.executeMethod((HttpMethod)get);
            String tlayers = get.getResponseBodyAsString();
            JSONParser jp = new JSONParser();
            JSONObject joTop = (JSONObject)jp.parse(tlayers);
            JSONArray joarr = (JSONArray)joTop.get((Object)"tabulations");
            for (int i = 0; i < joarr.size(); ++i) {
                JSONObject jo = (JSONObject)joarr.get(i);
                FieldDTO f1 = new FieldDTO(jo.get((Object)"fid1").toString(), jo.get((Object)"name1").toString(), "");
                FieldDTO f2 = new FieldDTO(jo.get((Object)"fid2").toString(), jo.get((Object)"name2").toString(), "");
                this.load(f1, f2);
                this.load(f2, f1);
            }
            Set keySet = this.tabLayerDisplayNames.keySet();
            ArrayList keyList = new ArrayList(keySet);
            Collections.sort(keyList);
            LOGGER.debug((Object)("keyList1=" + keyList));
            for (int j = 0; j < keyList.size(); ++j) {
                String temp = (String)keyList.get(j);
                LOGGER.debug((Object)("temp=" + temp));
                Comboitem ci = new Comboitem(temp);
                ci.setValue((Object)temp);
                ci.setParent((Component)this.cbTabLayers1);
            }
            this.cbTabLayers1.addEventListener("onChange", (EventListener)new /* Unavailable Anonymous Inner Class!! */);
            this.cbTabLayers1.setSelectedIndex(0);
            this.onChange$cbTabLayer1(null);
            this.cbTabLayers2.setSelectedIndex(0);
            this.cbTabType.setSelectedIndex(0);
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Unable to call tabulation service for a list of layers", (Throwable)e);
        }
    }

    private void load(FieldDTO f1, FieldDTO f2) {
        ArrayList<FieldDTO> f2s = this.getField2(f1);
        ArrayList<String> f2DisplayNames = this.getFieldDisplayName2(f1.getDisplayName());
        if (f2s == null) {
            f2s = new ArrayList<FieldDTO>();
            f2s.add(f2);
            this.tabLayers.put(f1, f2s);
            f2DisplayNames = new ArrayList<String>();
            f2DisplayNames.add(f2.getDisplayName());
            this.tabLayerDisplayNames.put(f1.getDisplayName(), f2DisplayNames);
        } else {
            f2s.add(f2);
            f2DisplayNames.add(f2.getDisplayName());
        }
    }

    private List<FieldDTO> getField2(FieldDTO f1) {
        List f2s = null;
        for (FieldDTO fi : this.tabLayers.keySet()) {
            if (!f1.getName().equals(fi.getName())) continue;
            f2s = (List)this.tabLayers.get(fi);
            break;
        }
        return f2s;
    }

    private List<String> getFieldDisplayName2(String f1DisplayName) {
        List f2DisplayNames = null;
        for (String fiDisplayName : this.tabLayerDisplayNames.keySet()) {
            if (!f1DisplayName.equalsIgnoreCase(fiDisplayName)) continue;
            f2DisplayNames = (List)this.tabLayerDisplayNames.get(fiDisplayName);
            Collections.sort(f2DisplayNames);
            break;
        }
        return f2DisplayNames;
    }

    public void onChange$cbTabLayer1(Event event) {
        String f1DisplayNames = (String)this.cbTabLayers1.getSelectedItem().getValue();
        List f2DisplayNamess = this.getFieldDisplayName2(f1DisplayNames);
        if (!this.cbTabLayers2.getChildren().isEmpty()) {
            this.cbTabLayers2.getChildren().clear();
        }
        if (f2DisplayNamess != null) {
            for (int i = 0; i < f2DisplayNamess.size(); ++i) {
                String f2 = (String)f2DisplayNamess.get(i);
                Comboitem ci = new Comboitem(f2);
                ci.setValue((Object)f2);
                ci.setParent((Component)this.cbTabLayers2);
            }
            this.cbTabLayers2.setSelectedIndex(0);
        } else {
            LOGGER.debug((Object)"f2DisplayNames == null");
        }
    }

    public boolean onFinish() {
        String f1DisplayName = (String)this.cbTabLayers1.getSelectedItem().getValue();
        String f2DisplayName = (String)this.cbTabLayers2.getSelectedItem().getValue();
        String f1Name = "";
        String f2Name = "";
        for (FieldDTO fi : this.tabLayers.keySet()) {
            if (f1DisplayName.equals(fi.getDisplayName())) {
                f1Name = fi.getName();
                continue;
            }
            if (!f2DisplayName.equals(fi.getDisplayName())) continue;
            f2Name = fi.getName();
        }
        Event e = new Event("tabulation", (Component)this, (Object)(CommonData.getLayersServer() + "/tabulation/" + this.cbTabType.getSelectedItem().getValue() + "/" + f1Name + "/" + f2Name + "/tabulation.html" + "\n" + "Tabulation" + "\n" + CommonData.getLayersServer() + "/tabulation/" + this.cbTabType.getSelectedItem().getValue() + "/" + f1Name + "/" + f2Name + "/tabulation.csv"));
        this.getMapComposer().openUrl(e);
        this.remoteLogger.logMapAnalysis("Tabulation", "Tool - Tabulation", "", "", f1Name + ":" + f2Name, "", (String)this.cbTabType.getSelectedItem().getValue(), "STARTED");
        this.detach();
        return true;
    }
}

