/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.tool;

import au.org.ala.spatial.composer.results.SpeciesListResults;
import au.org.ala.spatial.composer.tool.ToolComposer;
import au.org.emii.portal.menu.SelectedArea;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;

public class SpeciesListComposer
extends ToolComposer {
    private static final Logger LOGGER = Logger.getLogger(SpeciesListComposer.class);
    private String extraParams;

    public void afterCompose() {
        super.afterCompose();
        this.selectedMethod = "Species list";
        this.totalSteps = 1;
        this.loadAreaLayers();
        this.updateWindowTitle();
        this.extraParams = (String)Executions.getCurrent().getArg().get("extraParams");
    }

    public boolean onFinish() {
        try {
            this.onClick$btnDownload();
            return true;
        }
        catch (Exception e) {
            LOGGER.error((Object)"error attemping to download species list", (Throwable)e);
            this.getMapComposer().showMessage("Unknown error.", (Component)this);
            return false;
        }
    }

    public void onClick$btnDownload() {
        SelectedArea sa = this.getSelectedArea();
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("selectedarea", sa);
        hm.put("geospatialKosher", this.getGeospatialKosher());
        hm.put("chooseEndemic", this.chkEndemicSpecies.isChecked());
        if (this.extraParams != null) {
            hm.put("extraParams", this.extraParams);
        }
        SpeciesListResults window = (SpeciesListResults)Executions.createComponents((String)"WEB-INF/zul/results/AnalysisSpeciesListResults.zul", (Component)this.getMapComposer(), hm);
        try {
            window.setParent((Component)this.getMapComposer());
            window.doModal();
        }
        catch (Exception e) {
            LOGGER.error((Object)"error opening analysisspecieslistresults.zul", (Throwable)e);
        }
        this.detach();
    }

    void fixFocus() {
        this.rgArea.setFocus(true);
    }
}

