/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.tool;

import au.org.ala.spatial.composer.progress.ProgressController;
import au.org.ala.spatial.composer.tool.ToolComposer;
import au.org.ala.spatial.util.BiocacheQuery;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.Query;
import au.org.ala.spatial.util.QueryUtil;
import au.org.ala.spatial.util.UserDataQuery;
import au.org.ala.spatial.util.Util;
import au.org.emii.portal.menu.MapLayer;
import au.org.emii.portal.menu.MapLayerMetadata;
import au.org.emii.portal.menu.SelectedArea;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.log4j.Logger;
import org.zkoss.zhtml.Filedownload;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zul.Checkbox;
import org.zkoss.zul.Combobox;
import org.zkoss.zul.Window;

public class SitesBySpeciesComposer
extends ToolComposer {
    private static final Logger LOGGER = Logger.getLogger(SitesBySpeciesComposer.class);
    private Checkbox chkOccurrenceDensity;
    private Checkbox chkSpeciesDensity;
    private Checkbox chkSitesBySpecies;
    private Combobox cbMovingAverageSize;
    private Query query = null;
    private SelectedArea sa = null;

    public void afterCompose() {
        super.afterCompose();
        this.selectedMethod = "Points To Grid";
        this.totalSteps = 3;
        if (this.dResolution.getValue() == 0.0) {
            this.dResolution.setValue(0.05);
        }
        this.loadAreaLayers();
        this.loadSpeciesLayers(false);
        this.updateWindowTitle();
    }

    public void onLastPanel() {
        LOGGER.debug((Object)"**** On last step ****");
        super.onLastPanel();
    }

    public boolean onFinish() {
        if (!this.hasEstimated && !this.isUserLoggedIn()) {
            this.checkEstimate();
            return false;
        }
        Query q = this.getSelectedSpecies();
        if (q == null) {
            this.getMapComposer().showMessage("There is a problem selecting the species.  Try to select the species again", (Component)this);
            return false;
        }
        if (this.searchSpeciesACComp.hasValidItemSelected()) {
            this.getMapComposer().mapSpeciesFromAutocompleteComponent(this.searchSpeciesACComp, this.getSelectedArea(), this.getGeospatialKosher(), false);
        } else if (this.rgSpecies.getSelectedItem() != null && "multiple".equals(this.rgSpecies.getSelectedItem().getValue())) {
            this.getMapComposer().mapSpecies(q, "Species assemblage", "species", 0, 21, null, -1, 3, 0.6f, Util.nextColour(), false);
        }
        return this.runsitesbyspecies();
    }

    private void setupData() throws Exception {
        if (this.query == null) {
            this.sa = this.getSelectedArea();
            this.query = QueryUtil.queryFromSelectedArea((Query)this.getSelectedSpecies(), (SelectedArea)this.sa, (boolean)false, (boolean[])this.getGeospatialKosher());
        }
    }

    String run(boolean isEstimate) throws Exception {
        int movingAverageSize;
        this.setupData();
        String ma = "9";
        if (this.cbMovingAverageSize.getSelectedItem() == null) {
            String txt = this.cbMovingAverageSize.getValue();
            for (int i = 0; i < this.cbMovingAverageSize.getItemCount(); ++i) {
                if (txt == null || !txt.equalsIgnoreCase(this.cbMovingAverageSize.getItemAtIndex(i).getLabel())) continue;
                ma = (String)this.cbMovingAverageSize.getItemAtIndex(i).getValue();
                break;
            }
        } else {
            ma = (String)this.cbMovingAverageSize.getSelectedItem().getValue();
        }
        if ((movingAverageSize = Integer.parseInt(ma)) % 2 == 0 || movingAverageSize <= 0 || movingAverageSize >= 16) {
            this.getMapComposer().showMessage("Moving average size " + movingAverageSize + " is not valid.  Must be odd and between 1 and 15.", (Component)this);
            return null;
        }
        if (!(this.chkOccurrenceDensity.isChecked() || this.chkSitesBySpecies.isChecked() || this.chkSpeciesDensity.isChecked())) {
            this.getMapComposer().showMessage("Must select at least one output; Sites by species, Occurrence density or Species richness.", (Component)this);
            return null;
        }
        Double gridResolution = this.dResolution.getValue();
        if (gridResolution == 0.0) {
            this.dResolution.setValue(0.05);
            gridResolution = 0.05;
        }
        List bbox = Util.getBoundingBox((String)this.sa.getWkt());
        int occurrenceCount = this.query.getOccurrenceCount();
        int boundingboxcellcount = (int)(((Double)bbox.get(2) - (Double)bbox.get(0)) * ((Double)bbox.get(3) - (Double)bbox.get(1)) / (gridResolution * gridResolution));
        LOGGER.debug((Object)("SitesBySpecies for " + occurrenceCount + " occurrences in up to " + boundingboxcellcount + " grid cells."));
        if (boundingboxcellcount > Integer.parseInt(CommonData.getSettings().getProperty("sitesbyspecies_maxbbcells"))) {
            this.getMapComposer().showMessage("Too many output grid cells: Decrease area or increase grid size.", (Component)this);
            return null;
        }
        if (occurrenceCount > Integer.parseInt(CommonData.getSettings().getProperty("sitesbyspecies_maxoccurrences"))) {
            this.getMapComposer().showMessage("Too many occurrences for the selected species in this area.  " + occurrenceCount + " occurrences found, must be less than " + CommonData.getSettings().getProperty("sitesbyspecies_maxoccurrences"), (Component)this);
            return null;
        }
        StringBuilder sbProcessUrl = new StringBuilder();
        sbProcessUrl.append(CommonData.getSatServer()).append("/ws/sitesbyspecies").append(isEstimate ? "/estimate" : "").append("?");
        sbProcessUrl.append("speciesq=").append(URLEncoder.encode(QueryUtil.queryFromSelectedArea((Query)this.query, (SelectedArea)this.sa, (boolean)false, (boolean[])this.getGeospatialKosher()).getQ(), "UTF-8"));
        sbProcessUrl.append("&bs=").append(URLEncoder.encode(this.query.getBS(), "UTF-8"));
        sbProcessUrl.append("&gridsize=").append(URLEncoder.encode(String.valueOf(gridResolution), "UTF-8"));
        if (this.chkOccurrenceDensity.isChecked()) {
            sbProcessUrl.append("&occurrencedensity=1");
        }
        if (this.chkSpeciesDensity.isChecked()) {
            sbProcessUrl.append("&speciesdensity=1");
        }
        if (this.chkSitesBySpecies.isChecked()) {
            sbProcessUrl.append("&sitesbyspecies=1");
        }
        sbProcessUrl.append("&movingaveragesize=").append(ma);
        String areaSqKm = this.sa.getMapLayer() != null && this.sa.getMapLayer().getAreaSqKm() != null ? this.sa.getMapLayer().getAreaSqKm() : String.format("%,.2f", Util.calculateArea((String)this.sa.getWkt()) / 1000000.0);
        sbProcessUrl.append("&areasqkm=").append(areaSqKm);
        HttpClient client = new HttpClient();
        PostMethod get = new PostMethod(sbProcessUrl.toString());
        String area = this.sa.getMapLayer() != null && this.sa.getMapLayer().getEnvelope() != null ? "ENVELOPE(" + this.sa.getMapLayer().getEnvelope() + ")" : this.sa.getWkt();
        if (this.getSelectedArea() != null) {
            get.addParameter("area", area);
        }
        get.addParameter("qname", this.query.getName());
        get.addRequestHeader("Accept", "text/plain");
        client.executeMethod((HttpMethod)get);
        if (!isEstimate) {
            try {
                String extras = "";
                extras = extras + "gridsize=" + gridResolution;
                extras = extras + "|occurrencedensity=1";
                extras = extras + "|speciesdensity=1";
                extras = extras + "|sitesbyspecies=1";
                extras = extras + "|movingaveragesize=" + ma;
                if (this.query instanceof BiocacheQuery) {
                    BiocacheQuery bq = (BiocacheQuery)this.query;
                    extras = bq.getWS() + "|" + bq.getBS() + "|" + bq.getFullQ(false) + "|" + extras;
                    this.remoteLogger.logMapAnalysis("species to grid", "Tool - Species to Grid", area, bq.getLsids(), "", this.pid, extras, "STARTED");
                } else if (this.query instanceof UserDataQuery) {
                    this.remoteLogger.logMapAnalysis("species to grid", "Tool - Species to Grid", area, this.query.getQ(), "", this.pid, extras, "STARTED");
                } else {
                    this.remoteLogger.logMapAnalysis("species to grid", "Tool - Species to Grid", area, "", "", this.pid, extras, "STARTED");
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"error logging", (Throwable)e);
            }
        }
        return get.getResponseBodyAsString();
    }

    public long getEstimate() {
        try {
            String estimate = this.run(true);
            if (estimate == null) {
                return -1L;
            }
            return Long.valueOf(estimate);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unable to get estimates", (Throwable)e);
            return -1L;
        }
    }

    public boolean runsitesbyspecies() {
        try {
            this.pid = this.run(false);
            if (this.pid == null) {
                return false;
            }
            this.openProgressBar();
            this.setVisible(false);
            return true;
        }
        catch (Exception e) {
            LOGGER.error((Object)"SitesBySpecies error: ", (Throwable)e);
            this.getMapComposer().showMessage("Unknown error.", (Component)this);
            return false;
        }
    }

    void loadLayer(String type, String name, int typeId) {
        String mapurl = CommonData.getGeoServer() + "/wms?service=WMS&version=1.1.0&request=GetMap&layers=ALA:" + type + "_" + this.pid + "&styles=" + type + "_" + this.pid + "&FORMAT=image%2Fpng";
        String legendurl = CommonData.getGeoServer() + "/wms?REQUEST=GetLegendGraphic&VERSION=1.0.0&FORMAT=image/png&WIDTH=10&HEIGHT=1" + "&LAYER=ALA:" + type + "_" + this.pid + "&STYLE=" + type + "_" + this.pid;
        LOGGER.debug((Object)legendurl);
        String layername = this.getMapComposer().getNextAreaLayerName(name);
        this.getMapComposer().addWMSLayer(this.pid + "_" + type, layername, mapurl, 0.5f, null, legendurl, typeId, null, null);
        MapLayer ml = this.getMapComposer().getMapLayer(this.pid + "_" + type);
        ml.setPid(this.pid + "_" + type);
        String infoUrl = CommonData.getSatServer() + "/output/sitesbyspecies/" + this.pid + "/" + type + "_metadata.html";
        MapLayerMetadata md = ml.getMapLayerMetadata();
        md.setMoreInfo(infoUrl + "\n" + name + "\npid:" + this.pid);
        md.setId(Long.valueOf(this.pid).longValue());
    }

    public void loadMap(Event event) {
        try {
            if (this.chkOccurrenceDensity.isChecked()) {
                this.loadLayer("odensity", "Occurrence Density", 24);
            }
            if (this.chkSpeciesDensity.isChecked()) {
                this.loadLayer("srichness", "Species Richness", 25);
            }
            String fileUrl = CommonData.getSatServer() + "/ws/download/" + this.pid;
            Filedownload.save((InputStream)new URL(fileUrl).openStream(), (String)"application/zip", (String)"sites_by_species.zip");
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Error generating download for prediction model:", (Throwable)ex);
        }
        this.detach();
    }

    void openProgressBar() {
        ProgressController window = (ProgressController)Executions.createComponents((String)"WEB-INF/zul/progress/AnalysisProgress.zul", (Component)this.getMapComposer(), null);
        window.setParentWindow((Window)this);
        window.start(this.pid, "Points to Grid");
        try {
            window.setParent((Component)this.getMapComposer());
            window.doModal();
        }
        catch (Exception e) {
            LOGGER.error((Object)("error opening AnalysisProgress.zul for points to grid: " + this.pid), (Throwable)e);
        }
    }

    void fixFocus() {
        switch (this.currentStep) {
            case 1: {
                this.rgArea.setFocus(true);
                break;
            }
            case 2: {
                if (this.rSpeciesSearch.isChecked()) {
                    this.searchSpeciesACComp.getAutoComplete().setFocus(true);
                    break;
                }
                this.rgSpecies.setFocus(true);
                break;
            }
            case 3: {
                this.dResolution.setFocus(true);
                break;
            }
            default: {
                LOGGER.error((Object)("invalid step for SitesBySpeciesComposer: " + this.currentStep));
            }
        }
    }
}

