/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.tool;

import au.org.ala.spatial.composer.tool.ToolComposer;
import au.org.ala.spatial.util.BiocacheQuery;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.Query;
import au.org.ala.spatial.util.QueryUtil;
import au.org.ala.spatial.util.UserDataQuery;
import au.org.emii.portal.menu.MapLayer;
import au.org.emii.portal.menu.SelectedArea;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.log4j.Logger;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.Checkbox;
import org.zkoss.zul.Filedownload;

public class ScatterplotListComposer
extends ToolComposer {
    private static final Logger LOGGER = Logger.getLogger(ScatterplotListComposer.class);
    private Checkbox chkShowEnvIntersection;

    public void afterCompose() {
        super.afterCompose();
        this.selectedMethod = "Scatterplot List";
        this.totalSteps = 5;
        this.setIncludeAnalysisLayersForAnyQuery(true);
        this.loadAreaLayers("World");
        this.loadSpeciesLayers();
        this.loadAreaLayersHighlight();
        this.loadGridLayers(true, false, true);
        this.loadSpeciesLayersBk();
        this.updateWindowTitle();
        this.updateName(this.getMapComposer().getNextAreaLayerName("My Scatterplot"));
    }

    public void onLastPanel() {
        super.onLastPanel();
        this.updateName(this.getMapComposer().getNextAreaLayerName("My Scatterplot"));
    }

    public boolean onFinish() {
        block31: {
            String sbenvsel;
            String[] layers;
            LOGGER.debug((Object)("Area: " + this.getSelectedArea()));
            LOGGER.debug((Object)("Species: " + this.getSelectedSpecies()));
            Query query = this.getSelectedSpecies();
            if (query == null) {
                this.getMapComposer().showMessage("There was a problem selecting the species.  Try to select the species again", (Component)this);
                return false;
            }
            Query lsid = this.getSelectedSpecies();
            SelectedArea filterSa = this.getSelectedArea();
            SelectedArea highlightSa = this.getSelectedAreaHighlight();
            Query lsidQuery = QueryUtil.queryFromSelectedArea((Query)lsid, (SelectedArea)filterSa, (boolean)false, (boolean[])this.getGeospatialKosher());
            if (lsidQuery == null || lsidQuery.getOccurrenceCount() == 0) {
                this.getMapComposer().showMessage("No occurrences found for the selected species in the selected area.");
                return false;
            }
            String pid = "";
            Query backgroundLsid = this.getSelectedSpeciesBk();
            if (this.bgSearchSpeciesACComp.hasValidAnnotatedItemSelected()) {
                backgroundLsid = this.bgSearchSpeciesACComp.getQuery((Map)this.getMapComposer().getSession().getAttribute("userpoints"), false, this.getGeospatialKosher());
            }
            boolean envGrid = this.chkShowEnvIntersection.isChecked();
            Query backgroundLsidQuery = null;
            if (backgroundLsid != null) {
                backgroundLsidQuery = QueryUtil.queryFromSelectedArea((Query)backgroundLsid, (SelectedArea)filterSa, (boolean)false, (boolean[])this.getGeospatialKosherBk());
            }
            if ((layers = (sbenvsel = this.getSelectedLayers()).split(":")).length > 20) {
                this.getMapComposer().showMessage(sbenvsel.split(":").length + " layers selected.  Please select fewer than 20 environmental layers in step 1.");
                return false;
            }
            StringBuilder layernames = new StringBuilder();
            String layerunits = "";
            for (int i = 0; i < layers.length; ++i) {
                String layerDisplayName;
                if (layernames.length() > 0) {
                    layernames.append(",");
                    layerunits = layerunits + ",";
                }
                if ((layerDisplayName = CommonData.getLayerDisplayName((String)layers[i])) == null) {
                    for (MapLayer ml : this.getMapComposer().getAnalysisLayers()) {
                        try {
                            if (!layers[i].equals(ml.getPid())) continue;
                            layerDisplayName = ml.getDisplayName();
                        }
                        catch (Exception e) {}
                    }
                }
                if (layerDisplayName == null) {
                    LOGGER.error((Object)("failed to get layer display name for: " + layers[i]));
                    layerDisplayName = layers[i];
                }
                layernames.append("\"").append(layerDisplayName.replace("\"", "\"\"").replace("\\", "\\\\")).append("\"");
                String units = "";
                try {
                    units = String.valueOf(CommonData.getLayer((String)layers[i]).get((Object)"environmentalvalueunits"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                layerunits = layerunits + units;
            }
            try {
                HttpClient client = new HttpClient();
                PostMethod post = new PostMethod(CommonData.getSatServer() + "/ws/scatterplotlist");
                post.addParameter("layers", this.getSelectedLayers());
                post.addParameter("layernames", layernames.toString());
                post.addParameter("layerunits", layerunits);
                post.addParameter("foregroundOccurrencesQs", lsidQuery.getQ());
                post.addParameter("foregroundOccurrencesBs", lsidQuery.getBS());
                post.addParameter("foregroundName", lsidQuery.getName());
                if (backgroundLsidQuery != null) {
                    post.addParameter("backgroundOccurrencesQs", backgroundLsidQuery.getQ());
                    post.addParameter("backgroundOccurrencesBs", backgroundLsidQuery.getBS());
                    post.addParameter("backgroundName", backgroundLsidQuery.getName());
                }
                if (envGrid) {
                    post.addParameter("gridDivisions", "20");
                }
                if (filterSa != null) {
                    post.addParameter("filterWkt", filterSa.getWkt());
                }
                if (highlightSa != null) {
                    post.addParameter("highlightWkt", highlightSa.getWkt());
                }
                post.addRequestHeader("Accept", "application/json");
                client.executeMethod((HttpMethod)post);
                String hasId = post.getResponseBodyAsString();
                JSONParser jp = new JSONParser();
                JSONObject jo = (JSONObject)jp.parse(hasId);
                String htmlUrl = null;
                String downloadUrl = null;
                if (jo.containsKey((Object)"id")) {
                    pid = jo.get((Object)"id").toString();
                }
                if (jo.containsKey((Object)"htmlUrl")) {
                    htmlUrl = jo.get((Object)"htmlUrl").toString();
                }
                if (jo.containsKey((Object)"downloadUrl")) {
                    downloadUrl = jo.get((Object)"downloadUrl").toString();
                }
                if (htmlUrl != null && downloadUrl != null) {
                    Events.echoEvent((String)"openUrl", (Component)this.getMapComposer(), (String)htmlUrl);
                    try {
                        Filedownload.save((InputStream)new URL(downloadUrl).openStream(), (String)"application/zip", (String)(this.tToolName.getValue().replaceAll(" ", "_") + ".zip"));
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)"error preparing download for scatterplot data", (Throwable)e);
                    }
                    try {
                        String extras = "";
                        if (highlightSa != null) {
                            extras = extras + "highlight=" + highlightSa.getWkt();
                        }
                        extras = backgroundLsid instanceof BiocacheQuery ? extras + "background=" + ((BiocacheQuery)backgroundLsid).getLsids() : (backgroundLsid instanceof UserDataQuery ? extras + "background=" + backgroundLsid.getQ() : extras + "background=none");
                        if (lsidQuery instanceof BiocacheQuery) {
                            BiocacheQuery bq = (BiocacheQuery)lsidQuery;
                            extras = bq.getWS() + "|" + bq.getBS() + "|" + bq.getFullQ(false) + "|" + extras;
                            this.remoteLogger.logMapAnalysis(this.tToolName.getValue(), "Tool - Scatterplot List", filterSa.getWkt(), bq.getLsids(), sbenvsel, pid, extras, "SUCCESSFUL");
                            break block31;
                        }
                        if (lsidQuery instanceof UserDataQuery) {
                            this.remoteLogger.logMapAnalysis(this.tToolName.getValue(), "Tool - Scatterplot List", filterSa.getWkt(), lsidQuery.getQ(), sbenvsel, pid, extras, "SUCCESSFUL");
                            break block31;
                        }
                        this.remoteLogger.logMapAnalysis(this.tToolName.getValue(), "Tool - Scatterplot List", filterSa.getWkt(), "", sbenvsel, pid, extras, "SUCCESSFUL");
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)"failed to produce a scatterplot list.", (Throwable)e);
                    }
                    break block31;
                }
                LOGGER.error((Object)("failed to produce a scatterplot list.  response: " + jo));
            }
            catch (Exception e) {
                LOGGER.error((Object)"error getting a new scatterplot id", (Throwable)e);
            }
        }
        this.detach();
        return true;
    }

    void fixFocus() {
        switch (this.currentStep) {
            case 1: {
                this.rgArea.setFocus(true);
                break;
            }
            case 2: {
                if (this.rSpeciesSearch.isChecked()) {
                    this.searchSpeciesACComp.getAutoComplete().setFocus(true);
                    break;
                }
                this.rgSpecies.setFocus(true);
                break;
            }
            case 3: {
                this.rgAreaHighlight.setFocus(true);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                if (this.rSpeciesSearchBk.isChecked()) {
                    this.bgSearchSpeciesACComp.getAutoComplete().setFocus(true);
                    break;
                }
                this.rgSpeciesBk.setFocus(true);
                break;
            }
            case 6: {
                this.tToolName.setFocus(true);
                break;
            }
            default: {
                LOGGER.error((Object)("invalid step for ScatterplotListComposer: " + this.currentStep));
            }
        }
    }
}

