/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.tool;

import au.org.ala.spatial.composer.tool.ToolComposer;
import au.org.ala.spatial.dto.ScatterplotDataDTO;
import au.org.ala.spatial.util.BiocacheQuery;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.Query;
import au.org.ala.spatial.util.QueryUtil;
import au.org.ala.spatial.util.UserDataQuery;
import au.org.emii.portal.menu.SelectedArea;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.log4j.Logger;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.zkoss.zk.ui.Component;
import org.zkoss.zul.Checkbox;

public class ScatterplotComposer
extends ToolComposer {
    private static final Logger LOGGER = Logger.getLogger(ScatterplotComposer.class);
    private ScatterplotDataDTO data;
    private Checkbox chkShowEnvIntersection;

    public void afterCompose() {
        super.afterCompose();
        this.selectedMethod = "Scatterplot";
        this.totalSteps = 6;
        this.setIncludeAnalysisLayersForAnyQuery(true);
        this.loadAreaLayers("World");
        this.loadSpeciesLayers();
        this.loadAreaLayersHighlight();
        this.loadSpeciesLayersBk();
        this.updateWindowTitle();
        this.updateName(this.getMapComposer().getNextAreaLayerName("My Scatterplot"));
    }

    public void onLastPanel() {
        super.onLastPanel();
        this.updateName(this.getMapComposer().getNextAreaLayerName("My Scatterplot"));
    }

    public boolean onFinish() {
        SelectedArea filterSa;
        LOGGER.debug((Object)("Area: " + this.getSelectedArea()));
        LOGGER.debug((Object)("Species: " + this.getSelectedSpecies()));
        Query query = this.getSelectedSpecies();
        if (query == null) {
            this.getMapComposer().showMessage("There was a problem selecting the species.  Try to select the species again", (Component)this);
            return false;
        }
        Query lsid = this.getSelectedSpecies();
        String name = this.getSelectedSpeciesName();
        JSONObject jo = (JSONObject)this.cbLayer1.getSelectedItem().getValue();
        String lyr1name = this.cbLayer1.getText();
        String lyr1value = jo.get((Object)"name").toString();
        jo = (JSONObject)this.cbLayer2.getSelectedItem().getValue();
        String lyr2name = this.cbLayer2.getText();
        String lyr2value = jo.get((Object)"name").toString();
        String pid = "";
        Query backgroundLsid = this.getSelectedSpeciesBk();
        if (this.bgSearchSpeciesACComp.hasValidAnnotatedItemSelected()) {
            backgroundLsid = this.bgSearchSpeciesACComp.getQuery((Map)this.getMapComposer().getSession().getAttribute("userpoints"), false, this.getGeospatialKosher());
        }
        if ((filterSa = this.getSelectedArea()) == null) {
            LOGGER.error((Object)"scatterplot area is null");
            return false;
        }
        SelectedArea highlightSa = this.getSelectedAreaHighlight();
        boolean envGrid = this.chkShowEnvIntersection.isChecked();
        Query lsidQuery = QueryUtil.queryFromSelectedArea((Query)lsid, (SelectedArea)filterSa, (boolean)false, (boolean[])this.getGeospatialKosher());
        Query backgroundLsidQuery = null;
        if (backgroundLsid != null) {
            backgroundLsidQuery = QueryUtil.queryFromSelectedArea((Query)backgroundLsid, (SelectedArea)filterSa, (boolean)false, (boolean[])this.getGeospatialKosherBk());
        }
        ScatterplotDataDTO d = new ScatterplotDataDTO(lsidQuery, name, lyr1value, lyr1name, lyr2value, lyr2name, pid, null, true, highlightSa);
        try {
            HttpClient client = new HttpClient();
            PostMethod post = new PostMethod(CommonData.getSatServer() + "/ws/scatterplot/new");
            String layerunits = "";
            try {
                layerunits = String.valueOf(CommonData.getLayer((String)lyr1value).get((Object)"environmentalvalueunits")) + "," + String.valueOf(CommonData.getLayer((String)lyr2value).get((Object)"environmentalvalueunits"));
            }
            catch (Exception e) {
                // empty catch block
            }
            post.addParameter("layers", lyr1value + ":" + lyr2value);
            post.addParameter("layernames", "\"" + lyr1name.replace("\"", "\"\"").replace("\\", "\\\\") + "\",\"" + lyr2name.replace("\"", "\"\"").replace("\\", "\\\\") + "\"");
            post.addParameter("layerunits", layerunits);
            post.addParameter("foregroundOccurrencesQs", lsidQuery.getQ());
            post.addParameter("foregroundOccurrencesBs", lsidQuery.getBS());
            post.addParameter("foregroundName", lsidQuery.getName());
            if (backgroundLsidQuery != null) {
                post.addParameter("backgroundOccurrencesQs", backgroundLsidQuery.getQ());
                post.addParameter("backgroundOccurrencesBs", backgroundLsidQuery.getBS());
                post.addParameter("backgroundName", backgroundLsidQuery.getName());
            }
            if (envGrid) {
                post.addParameter("gridDivisions", "20");
            }
            post.addParameter("filterWkt", filterSa.getWkt());
            if (highlightSa != null) {
                post.addParameter("highlightWkt", highlightSa.getWkt());
            }
            post.addRequestHeader("Accept", "application/json");
            client.executeMethod((HttpMethod)post);
            String str = post.getResponseBodyAsString();
            JSONParser jp = new JSONParser();
            JSONObject jsonObject = (JSONObject)jp.parse(str);
            if (jsonObject != null && jsonObject.containsKey((Object)"id")) {
                d.setId(jsonObject.get((Object)"id").toString());
                d.setMissingCount(Integer.parseInt(jsonObject.get((Object)"missingCount").toString()));
            } else {
                LOGGER.error((Object)("error parsing scatterplot id from: " + str));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"error getting a new scatterplot id", (Throwable)e);
        }
        this.getMapComposer().loadScatterplot(d, this.tToolName.getValue());
        this.detach();
        try {
            String extras = "";
            if (lsidQuery instanceof BiocacheQuery) {
                BiocacheQuery bq = (BiocacheQuery)lsidQuery;
                extras = bq.getWS() + "|" + bq.getBS() + "|" + bq.getFullQ(false) + "|" + extras;
                this.remoteLogger.logMapAnalysis(this.tToolName.getValue(), "Tool - Scatterplot", filterSa.getWkt(), bq.getLsids(), lyr1value + ":" + lyr2value, pid, extras, "SUCCESSFUL");
            } else if (lsidQuery instanceof UserDataQuery) {
                this.remoteLogger.logMapAnalysis(this.tToolName.getValue(), "Tool - Scatterplot", filterSa.getWkt(), lsidQuery.getQ(), "", pid, extras, "SUCCESSFUL");
            } else {
                this.remoteLogger.logMapAnalysis(this.tToolName.getValue(), "Tool - Scatterplot", filterSa.getWkt(), "", "", pid, extras, "SUCCESSFUL");
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"logging error", (Throwable)e);
        }
        return true;
    }

    void fixFocus() {
        switch (this.currentStep) {
            case 1: {
                this.rgArea.setFocus(true);
                break;
            }
            case 2: {
                if (this.rSpeciesSearch.isChecked()) {
                    this.searchSpeciesACComp.getAutoComplete().setFocus(true);
                    break;
                }
                this.rgSpecies.setFocus(true);
                break;
            }
            case 3: {
                this.rgAreaHighlight.setFocus(true);
                break;
            }
            case 4: {
                this.cbLayer2.setFocus(true);
                break;
            }
            case 5: {
                if (this.rSpeciesSearchBk.isChecked()) {
                    this.bgSearchSpeciesACComp.getAutoComplete().setFocus(true);
                    break;
                }
                this.rgSpeciesBk.setFocus(true);
                break;
            }
            case 6: {
                this.tToolName.setFocus(true);
                break;
            }
            default: {
                LOGGER.error((Object)("invalid step for ScatterplotComposer: " + this.currentStep));
            }
        }
    }
}

