/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.tool;

import au.org.ala.spatial.composer.output.SamplingAnalysisDownloadController;
import au.org.ala.spatial.composer.tool.ToolComposer;
import au.org.ala.spatial.util.BiocacheQuery;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.Query;
import au.org.ala.spatial.util.QueryUtil;
import au.org.emii.portal.menu.SelectedArea;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Set;
import org.apache.log4j.Logger;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.Filedownload;

public class SamplingComposer
extends ToolComposer {
    private static final Logger LOGGER = Logger.getLogger(SamplingComposer.class);
    private int generationCount = 1;

    public void afterCompose() {
        super.afterCompose();
        this.selectedMethod = "Sampling";
        this.totalSteps = 3;
        this.setIncludeAnalysisLayersForUploadQuery(false);
        this.setIncludeAnalysisLayersForAnyQuery(false);
        this.loadAreaLayers();
        this.loadSpeciesLayers();
        this.loadGridLayers(false, true, false);
        this.updateWindowTitle();
    }

    public void onLastPanel() {
        super.onLastPanel();
        this.updateName(this.getMapComposer().getNextAreaLayerName("My Sampling"));
    }

    public boolean onFinish() {
        Query query = this.getSelectedSpecies();
        if (query == null) {
            this.getMapComposer().showMessage("There is a problem selecting the species.  Try to select the species again", (Component)this);
            return false;
        }
        return this.download(null);
    }

    public boolean download(Event event) {
        try {
            SelectedArea sa = this.getSelectedArea();
            Query query = QueryUtil.queryFromSelectedArea((Query)this.getSelectedSpecies(), (SelectedArea)sa, (boolean)false, (boolean[])this.getGeospatialKosher());
            if (query.getOccurrenceCount() <= 0) {
                this.getMapComposer().showMessage("No occurrences selected. Please try again", (Component)this);
                return false;
            }
            String[] layers = null;
            String envlayers = this.getSelectedLayers();
            if (envlayers.length() > 0) {
                layers = envlayers.split(":");
                for (int i = 0; i < layers.length; ++i) {
                    String l = layers[i];
                    String newName = CommonData.getLayerFacetName((String)layers[i]);
                    if (layers[i] == null || newName == null || layers[i].equals(newName)) {
                        LOGGER.debug((Object)("failed to getLayerFacetName for " + l));
                        continue;
                    }
                    layers[i] = newName;
                }
            }
            if (query instanceof BiocacheQuery) {
                String[] inBiocache = null;
                Set biocacheLayers = CommonData.getBiocacheLayerList();
                ArrayList<String> aInBiocache = new ArrayList<String>();
                ArrayList<String> aOutBiocache = new ArrayList<String>();
                if (layers != null) {
                    for (String s : layers) {
                        if (biocacheLayers.contains(s)) {
                            aInBiocache.add(s);
                            continue;
                        }
                        aOutBiocache.add(s);
                    }
                }
                if (!aInBiocache.isEmpty()) {
                    inBiocache = new String[aInBiocache.size()];
                    aInBiocache.toArray(inBiocache);
                }
                if (!aOutBiocache.isEmpty()) {
                    String[] outBiocache = new String[aOutBiocache.size()];
                    aOutBiocache.toArray(outBiocache);
                    this.getMapComposer().setDownloadSecondQuery(query);
                    this.getMapComposer().setDownloadSecondLayers(outBiocache);
                    SamplingAnalysisDownloadController c = (SamplingAnalysisDownloadController)Executions.createComponents((String)"/WEB-INF/zul/output/SamplingAnalysisDownload.zul", (Component)this.getMapComposer(), null);
                    c.setParent((Component)this.getMapComposer());
                    c.doModal();
                } else {
                    this.getMapComposer().setDownloadSecondQuery(null);
                    this.getMapComposer().setDownloadSecondLayers(null);
                }
                String url = query.getDownloadUrl(inBiocache);
                LOGGER.debug((Object)("Sending file to user: " + url));
                Events.echoEvent((String)"openHTML", (Component)this.getMapComposer(), (String)("Download\n" + url));
                try {
                    this.remoteLogger.logMapAnalysis("species sampling", "Export - Species Sampling", sa.getWkt(), query.getName(), envlayers, this.pid, "", "download");
                }
                catch (Exception e) {
                    LOGGER.error((Object)"remote logger error", (Throwable)e);
                }
                this.detach();
            } else {
                String fileUrl = query.getDownloadUrl(layers);
                Filedownload.save((InputStream)new URL(fileUrl).openStream(), (String)"application/zip", (String)(query.getName().replaceAll(" ", "_") + "_sample_" + ".zip"));
                try {
                    this.remoteLogger.logMapAnalysis("species sampling", "Export - Species Sampling", sa.getWkt(), query.getName(), envlayers, this.pid, "", "");
                }
                catch (Exception e) {
                    LOGGER.error((Object)"remote logger error", (Throwable)e);
                }
                this.detach();
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Exception calling sampling.download:", (Throwable)e);
            this.getMapComposer().showMessage("Unknown error.", (Component)this);
            return false;
        }
    }

    void fixFocus() {
        switch (this.currentStep) {
            case 1: {
                this.rgArea.setFocus(true);
                break;
            }
            case 2: {
                if (this.rSpeciesSearch.isChecked()) {
                    this.searchSpeciesACComp.getAutoComplete().setFocus(true);
                    break;
                }
                this.rgSpecies.setFocus(true);
                break;
            }
            case 3: {
                Query q;
                String[] defaultFields;
                this.lbListLayers.setFocus(true);
                if (this.getSelectedSpecies() != null && (defaultFields = (q = this.getSelectedSpecies()).getDefaultDownloadFields()).length > 0) {
                    this.lbListLayers.selectLayersAndDisable(defaultFields);
                }
                this.updateLayerSelectionCount();
                break;
            }
            default: {
                LOGGER.error((Object)("invalid step for SamplingComposer: " + this.currentStep));
            }
        }
    }
}

