/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.tool;

import au.org.ala.legend.Facet;
import au.org.ala.spatial.composer.input.UploadSpeciesController;
import au.org.ala.spatial.composer.tool.ToolComposer;
import au.org.ala.spatial.dto.UserDataDTO;
import au.org.ala.spatial.sampling.Sampling;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.ShapefileUtils;
import au.org.ala.spatial.util.Util;
import au.org.emii.portal.composer.MapComposer;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.geotools.data.FileDataStoreFinder;
import org.opengis.feature.simple.SimpleFeature;
import org.zkoss.zul.Doublebox;

public class PointGenerationComposer
extends ToolComposer {
    private static final Logger LOGGER = Logger.getLogger(PointGenerationComposer.class);
    private Doublebox resolution;

    public void afterCompose() {
        super.afterCompose();
        this.selectedMethod = "Point Generation";
        this.totalSteps = 2;
        this.loadAreaLayers();
        this.updateWindowTitle();
        this.updateName(this.getMapComposer().getNextAreaLayerName("Points on a grid"));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public boolean onFinish() {
        block25: {
            sa = this.getSelectedArea();
            bbox /* !! */  = null;
            if (sa.getMapLayer() != null && sa.getMapLayer().getMapLayerMetadata() != null) {
                bb = sa.getMapLayer().getMapLayerMetadata().getBbox();
                bbox /* !! */  = new double[2][2];
                bbox /* !! */ [0][0] = (Double)bb.get(0);
                bbox /* !! */ [0][1] = (Double)bb.get(1);
                bbox /* !! */ [1][0] = (Double)bb.get(2);
                bbox /* !! */ [1][1] = (Double)bb.get(3);
            } else {
                bb = Util.getBoundingBox((String)sa.getWkt());
                bbox /* !! */  = new double[][]{{(Double)bb.get(0), (Double)bb.get(1)}, {(Double)bb.get(2), (Double)bb.get(3)}};
            }
            try {
                wkt = sa.getMapLayer() != null ? sa.getMapLayer().getWKT() : sa.getWkt();
                sb = new StringBuilder();
                sb.append("longitude,latitude");
                count = 0;
                width = (int)Math.ceil((bbox /* !! */ [1][0] - bbox /* !! */ [0][0]) / this.resolution.getValue());
                height = (int)Math.ceil((bbox /* !! */ [1][1] - bbox /* !! */ [0][1]) / this.resolution.getValue());
                startx = Math.floor(bbox /* !! */ [0][0] / this.resolution.getValue()) * this.resolution.getValue();
                starty = Math.floor(bbox /* !! */ [0][1] / this.resolution.getValue()) * this.resolution.getValue();
                if (wkt != null) ** GOTO lbl58
                if (sa.getFacets() != null) {
                    points = new double[(width + 1) * (height + 1)][2];
                    pos = 0;
                    for (i = 0; i <= width; ++i) {
                        for (j = 0; j <= height; ++j) {
                            lng = startx + (double)i * this.resolution.getValue();
                            lat = starty + (double)j * this.resolution.getValue();
                            points[pos][0] = lng;
                            points[pos][1] = lat;
                            ++pos;
                        }
                    }
                    fields = new ArrayList<String>();
                    for (Facet f : sa.getFacets()) {
                        fields.add(f.getFields()[0]);
                    }
                    result = Sampling.sampling(fields, (double[][])points);
                    for (i = 0; i < result.size(); ++i) {
                        f = (Facet)sa.getFacets().get(i);
                        intersection = (String[])result.get(i);
                        for (j = 0; j < intersection.length; ++j) {
                            if (!f.isValid("\"" + intersection[j] + "\"")) continue;
                            sb.append("\n");
                            sb.append(points[j][0]).append(",").append(points[j][1]);
                            ++count;
                        }
                    }
                } else {
                    PointGenerationComposer.LOGGER.error((Object)"invalid area selected for point generation");
                    this.getMapComposer().showMessage("Unsupported area selected for point generation. Choose a different area.");
                    return false;
lbl58:
                    // 1 sources

                    tmp = File.createTempFile("tmp", ".shp");
                    ShapefileUtils.saveShapefile((File)tmp, (String)wkt, (String)"tmp");
                    store = FileDataStoreFinder.getDataStore((File)tmp);
                    featureSource = store.getFeatureSource(store.getTypeNames()[0]);
                    featureCollection = featureSource.getFeatures();
                    gf = new GeometryFactory();
                    geometry = new ArrayList<Geometry>();
                    it = featureCollection.features();
                    while (it.hasNext()) {
                        feature = (SimpleFeature)it.next();
                        geometry.add((Geometry)feature.getDefaultGeometry());
                    }
                    try {
                        it.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    for (i = 0; i <= width; ++i) {
                        for (j = 0; j <= height; ++j) {
                            lng = startx + (double)i * this.resolution.getValue();
                            lat = starty + (double)j * this.resolution.getValue();
                            c = new Coordinate(lng, lat);
                            point = gf.createPoint(c);
                            for (Geometry geom : geometry) {
                                if (!geom.contains((Geometry)point)) continue;
                                sb.append("\n");
                                sb.append(lng).append(",").append(lat);
                                ++count;
                            }
                        }
                    }
                    try {
                        store.dispose();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        FileUtils.deleteQuietly((File)tmp);
                        FileUtils.deleteQuietly((File)new File(tmp.getPath().replace(".shp", ".shx")));
                        FileUtils.deleteQuietly((File)new File(tmp.getPath().replace(".shp", ".fix")));
                        FileUtils.deleteQuietly((File)new File(tmp.getPath().replace(".shp", ".dbf")));
                        FileUtils.deleteQuietly((File)new File(tmp.getPath().replace(".shp", ".prj")));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (count <= 0) {
                    this.getMapComposer().showMessage("No points generated. Try again with a smaller resolution or larger area.");
                    break block25;
                }
                if (count > Integer.parseInt(CommonData.getSettings().getProperty("max_record_count_upload"))) {
                    this.getMapComposer().showMessage(count + " points generated. Maximum is " + CommonData.getSettings().getProperty("generated_points_max") + ".\n" + "Try again with a larger resolution or smaller area.");
                    break block25;
                }
                name = this.tToolName.getValue();
                try {
                    UploadSpeciesController.loadUserPoints((UserDataDTO)new UserDataDTO(name), (Reader)new StringReader(sb.toString()), (boolean)true, (String)name, (String)("points in " + this.getSelectedAreaDisplayName() + " on " + this.resolution.getValue() + " degree resolution grid."), (MapComposer)this.getMapComposer(), null);
                    this.detach();
                    return true;
                }
                catch (Exception e) {
                    PointGenerationComposer.LOGGER.error((Object)"failed to upload points");
                }
            }
            catch (Exception var3_4) {
                // empty catch block
            }
        }
        return false;
    }
}

