/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.tool;

import au.com.bytecode.opencsv.CSVReader;
import au.org.ala.spatial.composer.add.area.AreaToolComposer;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.LayersUtil;
import au.org.ala.spatial.util.Util;
import au.org.emii.portal.composer.MapComposer;
import au.org.emii.portal.menu.MapLayer;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.lf5.util.StreamUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zul.Button;
import org.zkoss.zul.Filedownload;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.ListitemRenderer;
import org.zkoss.zul.SimpleListModel;
import org.zkoss.zul.Textbox;

public class PointComparison
extends AreaToolComposer {
    private static final Logger LOGGER = Logger.getLogger(PointComparison.class);
    private Button btnAdd;
    private Button btnCompare;
    private Button btnDownload;
    private Button btnCancel;
    private Listbox lbPoints;
    private Listbox lbResults;
    private List<String[]> points = new ArrayList();
    private List<MapLayer> layers = new ArrayList();
    private List<Listitem> items = new ArrayList();
    private int currentPoint = -1;
    private String comparisonCsv = "";
    private String layernames = null;
    private Map<String, String> layerDisplayNames = new HashMap();

    public void afterCompose() {
        super.afterCompose();
        this.lbPoints.setModel((ListModel)new SimpleListModel(this.points));
        this.lbPoints.setItemRenderer((ListitemRenderer)new /* Unavailable Anonymous Inner Class!! */);
        this.lbResults.setItemRenderer((ListitemRenderer)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void onClick$btnAdd(Event event) {
        this.points.add(new String[2]);
        this.layers.add(null);
        this.items.add(null);
        this.currentPoint = this.points.size() - 1;
        this.lbPoints.setModel((ListModel)new SimpleListModel(this.points));
        this.enablePointClick();
    }

    public void onClick$btnCancel(Event event) {
        for (MapLayer ml : this.layers) {
            this.getMapComposer().deactiveLayer(ml, true, false);
        }
        this.detach();
    }

    public void onMapClick(Event event) {
        String pointGeom = (String)event.getData();
        try {
            if (!pointGeom.contains("NaN NaN")) {
                ((String[])this.points.get((int)this.currentPoint))[0] = pointGeom.replace("POINT(", "").split(" ")[0];
                ((String[])this.points.get((int)this.currentPoint))[1] = pointGeom.split(" ")[1].replace(")", "");
                this.lbPoints.setModel((ListModel)new SimpleListModel(this.points));
                MapComposer mc = this.getMapComposer();
                this.layerName = mc.getNextAreaLayerName("Point");
                MapLayer mapLayer = mc.addWKTLayer(pointGeom, this.layerName, "Point");
                mapLayer.getMapLayerMetadata().setMoreInfo(LayersUtil.getMetadataForWKT((String)CommonData.lang((String)"metadata_user_bounding_box"), (String)pointGeom));
                this.layers.set(this.currentPoint, mapLayer);
                this.disableEdit();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error adding user point", (Throwable)e);
        }
    }

    public void onClick$btnDownload(Event event) {
        Filedownload.save((String)this.comparisonCsv, (String)"text/plain", (String)"point_comparison.csv");
    }

    private String layerList() {
        if (this.layernames == null) {
            String url = CommonData.getSettings().getProperty("layers_batch_intersect_url") + "/fields";
            try {
                JSONParser jp = new JSONParser();
                JSONArray fields = (JSONArray)jp.parse(IOUtils.toString((InputStream)new URL(url).openStream()));
                for (int i = 0; i < fields.size(); ++i) {
                    JSONObject field = (JSONObject)fields.get(i);
                    this.layernames = this.layernames == null ? "" : this.layernames + ",";
                    this.layernames = this.layernames + field.get((Object)"id").toString();
                    this.layerDisplayNames.put(field.get((Object)"id").toString(), field.get((Object)"name").toString());
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"error getting layer names", (Throwable)e);
            }
        }
        return this.layernames;
    }

    public void onClick$btnCompare(Event event) {
        try {
            String url = CommonData.getSettings().getProperty("layers_batch_intersect_url") + "/intersect/batch";
            NameValuePair[] params = new NameValuePair[2];
            params[0] = new NameValuePair("fids", this.layerList());
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.points.size(); ++i) {
                try {
                    String part = "" + Double.parseDouble(((String[])this.points.get(i))[1]) + "," + Double.parseDouble(((String[])this.points.get(i))[0]);
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(part);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            params[1] = new NameValuePair("points", sb.toString());
            String batchId = Util.readUrlPost((String)url, (NameValuePair[])params);
            JSONParser jp = new JSONParser();
            batchId = ((JSONObject)jp.parse(batchId)).get((Object)"batchId").toString();
            LOGGER.debug((Object)("batch intersect id: " + batchId));
            Thread.sleep(2000L);
            long maxtime = 30000L;
            long starttime = System.currentTimeMillis();
            String csv = "";
            while (starttime + maxtime > System.currentTimeMillis()) {
                Thread.sleep(2000L);
                String response = Util.readUrl((String)(url + "/" + batchId));
                try {
                    String status = ((JSONObject)jp.parse(response)).get((Object)"status").toString();
                    if (!"finished".equals(status)) continue;
                    URL get = new URL(((JSONObject)jp.parse(response)).get((Object)"downloadUrl").toString());
                    InputStream is = get.openStream();
                    ZipInputStream zip = new ZipInputStream(is);
                    ZipEntry ze = zip.getNextEntry();
                    if (ze != null) {
                        csv = new String(StreamUtils.getBytes((InputStream)zip), "UTF-8");
                    }
                    zip.close();
                    is.close();
                    break;
                }
                catch (Exception e) {
                }
            }
            List data = new CSVReader((Reader)new StringReader(csv)).readAll();
            ArrayList<Integer> rowNumbers = new ArrayList<Integer>();
            block8: for (int j = 2; j < ((String[])data.get(0)).length; ++j) {
                for (int i = 1; i < data.size(); ++i) {
                    if (((String[])data.get(i))[j] == null || ((String[])data.get(i))[j].isEmpty() || "n/a".equals(((String[])data.get(i))[j])) continue;
                    rowNumbers.add(j);
                    continue block8;
                }
            }
            String[][] tdata = new String[rowNumbers.size() + 1][data.size()];
            StringBuilder tcsv = new StringBuilder();
            int row = 0;
            for (int i = 0; i < data.size(); ++i) {
                if (i > 0) {
                    tcsv.append(",");
                }
                tdata[row][i] = ((String[])data.get(i))[0] + " " + ((String[])data.get(i))[1];
                tcsv.append(tdata[0][i]);
            }
            ++row;
            for (int j = 2; j < ((String[])data.get(0)).length; ++j) {
                if (rowNumbers.size() <= 0 || (Integer)rowNumbers.get(0) != j) continue;
                rowNumbers.remove(0);
                tcsv.append("\n");
                for (int i = 0; i < data.size(); ++i) {
                    if (i > 0) {
                        tcsv.append(",");
                    }
                    if (i == 0) {
                        tcsv.append("\"").append((String)this.layerDisplayNames.get(((String[])data.get(i))[j])).append("\"");
                        tdata[row][i] = (String)this.layerDisplayNames.get(((String[])data.get(i))[j]);
                        continue;
                    }
                    tcsv.append(((String[])data.get(i))[j]);
                    tdata[row][i] = ((String[])data.get(i))[j];
                }
                ++row;
            }
            this.comparisonCsv = tcsv.toString();
            this.btnDownload.setDisabled(false);
            this.lbResults.setModel((ListModel)new SimpleListModel((Object[])tdata));
        }
        catch (Exception e) {
            LOGGER.error((Object)"error comparing points", (Throwable)e);
        }
    }

    private void disableEdit() {
        for (Listitem c1 : this.items) {
            for (Component c3 : c1.getChildren()) {
                if (c3.getChildren() == null) continue;
                for (Component c2 : c3.getChildren()) {
                    if (c2 instanceof Button && ((Button)c2).getLabel().equals("save")) {
                        ((Button)c2).setDisabled(true);
                    }
                    if (!(c2 instanceof Textbox)) continue;
                    ((Textbox)c2).setDisabled(true);
                }
            }
        }
    }

    private void enablePointClick() {
        String script = "window.mapFrame.addPointDrawingTool()";
        this.getMapComposer().getOpenLayersJavascript().execute(this.getMapComposer().getOpenLayersJavascript().getIFrameReferences() + script);
    }

    static /* synthetic */ List access$000(PointComparison x0) {
        return x0.items;
    }

    static /* synthetic */ int access$100(PointComparison x0) {
        return x0.currentPoint;
    }

    static /* synthetic */ void access$200(PointComparison x0) {
        x0.enablePointClick();
    }

    static /* synthetic */ void access$300(PointComparison x0) {
        x0.disableEdit();
    }

    static /* synthetic */ int access$102(PointComparison x0, int x1) {
        x0.currentPoint = x1;
        return x0.currentPoint;
    }

    static /* synthetic */ int access$110(PointComparison x0) {
        return x0.currentPoint--;
    }

    static /* synthetic */ List access$400(PointComparison x0) {
        return x0.points;
    }

    static /* synthetic */ String access$502(PointComparison x0, String x1) {
        x0.layerName = x1;
        return x0.layerName;
    }

    static /* synthetic */ List access$600(PointComparison x0) {
        return x0.layers;
    }

    static /* synthetic */ String access$700(PointComparison x0) {
        return x0.layerName;
    }

    static /* synthetic */ Listbox access$800(PointComparison x0) {
        return x0.lbPoints;
    }
}

