/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.tool;

import au.org.ala.legend.Facet;
import au.org.ala.spatial.composer.layer.ContextualLayersAutoComplete;
import au.org.ala.spatial.composer.results.PhylogeneticDiversityListResults;
import au.org.ala.spatial.composer.tool.ToolComposer;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.Util;
import au.org.emii.portal.menu.MapLayer;
import au.org.emii.portal.menu.SelectedArea;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.Checkbox;
import org.zkoss.zul.Div;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ListModelArray;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.ListitemRenderer;
import org.zkoss.zul.Messagebox;
import org.zkoss.zul.Radio;
import org.zkoss.zul.Vbox;

public class PhylogeneticDiversityComposer
extends ToolComposer {
    private static final Logger LOGGER = Logger.getLogger(PhylogeneticDiversityComposer.class);
    private Object[] trees;
    private Listbox treesList;
    private List<String> header;
    private Checkbox cAreasFromLayer;
    private Div divContextualLayer;
    private ContextualLayersAutoComplete autoCompleteLayers;
    private String autoCompleteLayerSelection;
    private List<SelectedArea> autoCompleteLayerAreas;

    public void afterCompose() {
        super.afterCompose();
        this.selectedMethod = "Phylogenetic Diversity";
        this.totalSteps = 3;
        this.loadAreaLayers(true);
        this.loadSpeciesLayers();
        this.updateWindowTitle();
        this.rgSpecies.setSelectedItem((Radio)this.getFellow("rSpeciesAll"));
        this.fillPDTreeList();
        Map m = Executions.getCurrent().getArg();
        if (m != null) {
            for (Map.Entry o : m.entrySet()) {
                MapLayer ml;
                if (o.getKey() instanceof String && "selectedTrees".equals(o.getKey())) {
                    String selectedTrees = (String)o.getValue();
                    for (String tree : selectedTrees.split(",")) {
                        for (int i = 0; i < this.trees.length; ++i) {
                            if (!((Map)this.trees[i]).containsValue(tree)) continue;
                            this.treesList.getItemAtIndex(i).setSelected(true);
                        }
                    }
                }
                if (o.getKey() instanceof String && "selectedAreas".equals(o.getKey())) {
                    String selectedAreas = (String)o.getValue();
                    for (String area : selectedAreas.split(",")) {
                        List checkboxes = this.getFellow("vboxArea").getChildren();
                        for (int i = 0; i < checkboxes.size(); ++i) {
                            if (!(checkboxes.get(i) instanceof Checkbox) || !((Checkbox)checkboxes.get(i)).getLabel().equals(area)) continue;
                            ((Checkbox)checkboxes.get(i)).setChecked(true);
                        }
                    }
                }
                if (!(o.getKey() instanceof String) || !"query".equals(o.getKey())) continue;
                String layerName = (String)o.getValue();
                Iterator i$ = this.getMapComposer().getSpeciesLayers().iterator();
                while (i$.hasNext() && ((ml = (MapLayer)i$.next()).getSpeciesQuery() == null || !ml.getName().equals(layerName))) {
                }
            }
        }
    }

    private void fillPDTreeList() {
        JSONArray ja = null;
        String url = CommonData.getSettings().getProperty("phylolist_url") + "/phylo/getExpertTrees";
        JSONParser jp = new JSONParser();
        try {
            ja = (JSONArray)jp.parse(Util.readUrl((String)url));
        }
        catch (ParseException e) {
            LOGGER.error((Object)"failed to parse getExpertTrees");
        }
        if (ja == null || ja.size() == 0) {
            Events.echoEvent((String)"onClose", (Component)this, null);
            this.getMapComposer().showMessage("Phylogenetic diversity tool is currently unavailable.");
            return;
        }
        this.trees = new Object[ja.size()];
        this.header = new ArrayList();
        for (Component c : this.getFellow("treesHeader").getChildren()) {
            this.header.add(c.getId().substring(3));
        }
        int row = 0;
        for (int i = 0; i < ja.size(); ++i) {
            JSONObject j = (JSONObject)ja.get(i);
            HashMap<String, String> pdrow = new HashMap<String, String>();
            for (Object o : j.keySet()) {
                String key = (String)o;
                if (j.containsKey((Object)key) && j.get((Object)key) != null) {
                    pdrow.put(key, j.get((Object)key).toString());
                    continue;
                }
                pdrow.put(key, null);
            }
            this.trees[row] = pdrow;
            ++row;
        }
        this.treesList.setModel((ListModel)new ListModelArray(this.trees, false));
        this.treesList.setItemRenderer((ListitemRenderer)new /* Unavailable Anonymous Inner Class!! */);
        this.treesList.setMultiple(true);
    }

    public boolean onFinish() {
        List sa = this.getSelectedAreas();
        if (this.autoCompleteLayerSelection != null && this.cAreasFromLayer.isChecked()) {
            String fieldId = CommonData.getLayerFacetNameDefault((String)this.autoCompleteLayerSelection);
            String layer = CommonData.getFacetLayerName((String)fieldId);
            JSONObject jo = CommonData.getLayer((String)layer);
            String name = jo.get((Object)"name").toString();
            String uid = jo.get((Object)"id").toString();
            String type = jo.get((Object)"type").toString();
            String treeName = StringUtils.capitalize((String)jo.get((Object)"displayname").toString());
            String treePath = jo.get((Object)"displaypath").toString();
            String legendurl = CommonData.getGeoServer() + "/wms?REQUEST=GetLegendGraphic&VERSION=1.0.0&FORMAT=image/png&WIDTH=20&HEIGHT=9&LAYER=" + name;
            String metadata = CommonData.getLayersServer() + "/layers/view/more/" + uid;
            boolean found = false;
            for (MapLayer ml : this.getMapComposer().getContextualLayers()) {
                if (!ml.getDisplayName().equalsIgnoreCase(treeName)) continue;
                found = true;
                break;
            }
            if (!found) {
                this.getMapComposer().addWMSLayer(name, treeName, treePath, 0.75f, metadata, legendurl, "environmental".equalsIgnoreCase(type) ? 20 : 19, null, null, null);
                this.remoteLogger.logMapArea(treeName, "Layer - " + type, treePath, name, metadata);
            }
        }
        HashMap hm = new HashMap();
        hm.put("selectedareas", sa);
        ArrayList<Object> st = new ArrayList<Object>();
        StringBuilder sb = new StringBuilder();
        for (Object o : this.treesList.getSelectedItems()) {
            st.add(this.trees[((Listitem)o).getIndex()]);
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append((String)((Map)this.trees[((Listitem)o).getIndex()]).get("studyId"));
        }
        hm.put("selectedtrees", st);
        hm.put("query", this.getSelectedSpecies());
        PhylogeneticDiversityListResults window = (PhylogeneticDiversityListResults)Executions.createComponents((String)"WEB-INF/zul/results/PhylogeneticDiversityResults.zul", (Component)this.getMapComposer(), hm);
        try {
            window.setParent((Component)this.getMapComposer());
            window.doModal();
        }
        catch (Exception e) {
            LOGGER.error((Object)"error opening PhylogeneticDiversityResults.zul", (Throwable)e);
        }
        this.remoteLogger.logMapAnalysis("PhylogeneticDiversity", "PhylogeneticDiversity", sa.size() + " areas", this.getSelectedSpeciesName(), sb.toString(), "", "", "");
        this.detach();
        return true;
    }

    public List<SelectedArea> getSelectedAreas() {
        ArrayList<SelectedArea> selectedAreas = new ArrayList<SelectedArea>();
        Vbox vboxArea = (Vbox)this.getFellowIfAny("vboxArea");
        for (Component c : vboxArea.getChildren()) {
            SelectedArea sa;
            block12: {
                if (!(c instanceof Checkbox) || !((Checkbox)c).isChecked()) continue;
                sa = null;
                String area = (String)((Checkbox)c).getValue();
                try {
                    if ("current".equals(area)) {
                        sa = new SelectedArea(null, this.getMapComposer().getViewArea());
                        break block12;
                    }
                    if ("australia".equals(area)) {
                        sa = new SelectedArea(null, CommonData.getSettings().getProperty("default.wkt"));
                        break block12;
                    }
                    if ("world".equals(area)) {
                        sa = new SelectedArea(null, "POLYGON((-179.999 -89.999,-179.999 89.999,179.999 84.999,179.999 -89.999,-179.999 -89.999))");
                        break block12;
                    }
                    List layers = this.getMapComposer().getPolygonLayers();
                    for (MapLayer ml : layers) {
                        if (!area.equals(ml.getName())) continue;
                        sa = new SelectedArea(ml, null);
                        break;
                    }
                }
                catch (Exception e) {
                    LOGGER.warn((Object)"Unable to retrieve selected area", (Throwable)e);
                }
            }
            if (sa == null) continue;
            selectedAreas.add(sa);
        }
        if (this.autoCompleteLayerSelection != null && this.cAreasFromLayer.isChecked()) {
            if (this.autoCompleteLayerAreas == null) {
                String fieldId = CommonData.getLayerFacetNameDefault((String)this.autoCompleteLayerSelection);
                JSONParser jp = new JSONParser();
                JSONObject objJson = null;
                try {
                    objJson = (JSONObject)jp.parse(Util.readUrl((String)(CommonData.getLayersServer() + "/field/" + fieldId)));
                }
                catch (ParseException e) {
                    LOGGER.error((Object)("failed to parse for: " + fieldId));
                }
                JSONArray objects = (JSONArray)objJson.get((Object)"objects");
                this.autoCompleteLayerAreas = new ArrayList();
                for (int i = 0; i < objects.size(); ++i) {
                    MapLayer ml = this.createMapLayerForObject((JSONObject)objects.get(i));
                    SelectedArea sa = new SelectedArea(ml, null);
                    this.autoCompleteLayerAreas.add(sa);
                }
            }
            selectedAreas.addAll(this.autoCompleteLayerAreas);
        }
        return selectedAreas;
    }

    public void onClick$btnOk(Event event) {
        if (this.currentStep == 1 && this.getSelectedAreas().isEmpty() && !((Radio)this.getFellow("rAreaCustom")).isSelected()) {
            Messagebox.show((String)"Select one or more areas.");
        } else if (this.currentStep == 3 && this.treesList.getSelectedItems().isEmpty()) {
            Messagebox.show((String)"Select one or more Phylogenetic Diversity.");
        } else {
            super.onClick$btnOk(event);
        }
    }

    public void onCheck$cAreasFromLayer(Event event) {
        this.divContextualLayer.setVisible(this.cAreasFromLayer.isChecked());
    }

    public void onChange$autoCompleteLayers(Event event) {
        this.autoCompleteLayerSelection = null;
        this.autoCompleteLayerAreas = null;
        if (this.autoCompleteLayers.getItemCount() > 0 && this.autoCompleteLayers.getSelectedItem() != null) {
            JSONObject jo = (JSONObject)this.autoCompleteLayers.getSelectedItem().getValue();
            this.autoCompleteLayerSelection = (String)jo.get((Object)"name");
        }
    }

    private MapLayer createMapLayerForObject(JSONObject objJson) {
        MapLayer mapLayer = new MapLayer();
        mapLayer.setPolygonLayer(true);
        ArrayList<Facet> facets = new ArrayList<Facet>();
        facets.add(new Facet((String)objJson.get((Object)"fid"), "\"" + objJson.get((Object)"name") + "\"", true));
        mapLayer.setFacets(facets);
        DecimalFormat df = new DecimalFormat("###,###.##");
        try {
            mapLayer.setAreaSqKm(String.valueOf(df.format(objJson.get((Object)"area_km"))));
        }
        catch (Exception e) {
            LOGGER.error((Object)("bad area for object: " + ((Facet)facets.get(0)).toString()));
        }
        mapLayer.setDisplayName((String)objJson.get((Object)"name"));
        return mapLayer;
    }

    static /* synthetic */ List access$000(PhylogeneticDiversityComposer x0) {
        return x0.header;
    }
}

