/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.tool;

import au.org.ala.spatial.composer.progress.ProgressController;
import au.org.ala.spatial.composer.tool.ToolComposer;
import au.org.ala.spatial.util.BiocacheQuery;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.Query;
import au.org.ala.spatial.util.QueryUtil;
import au.org.ala.spatial.util.Util;
import au.org.emii.portal.menu.MapLayer;
import au.org.emii.portal.menu.MapLayerMetadata;
import au.org.emii.portal.menu.SelectedArea;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.log4j.Logger;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zul.Checkbox;
import org.zkoss.zul.Filedownload;
import org.zkoss.zul.Textbox;
import org.zkoss.zul.Window;

public class MaxentComposer
extends ToolComposer {
    private static final Logger LOGGER = Logger.getLogger(MaxentComposer.class);
    private SelectedArea sa = null;
    private Query query = null;
    private String sbenvsel = "";
    private Checkbox chkJackknife;
    private Checkbox chkRCurves;
    private Textbox txtTestPercentage;

    public void afterCompose() {
        super.afterCompose();
        this.selectedMethod = "Prediction";
        this.totalSteps = 5;
        this.setIncludeAnalysisLayersForAnyQuery(true);
        this.loadAreaLayers();
        this.loadSpeciesLayers();
        this.loadGridLayers(true, true, true);
        this.updateWindowTitle();
    }

    public void onClick$btnClearSelectionCtx(Event event) {
        if (this.lbListLayers.getSelectedCount() == 0) {
            this.btnOk.setDisabled(true);
        }
    }

    public void onLastPanel() {
        super.onLastPanel();
        this.updateName(this.getMapComposer().getNextAreaLayerName("My Prediction"));
    }

    public boolean onFinish() {
        Query q = this.getSelectedSpecies();
        if (q == null) {
            this.getMapComposer().showMessage("There is a problem selecting the species.  Try to select the species again", (Component)this);
            return false;
        }
        if (this.searchSpeciesACComp.getAutoComplete().getSelectedItem() != null) {
            this.getMapComposer().mapSpeciesFromAutocompleteComponent(this.searchSpeciesACComp, this.getSelectedArea(), this.getGeospatialKosher(), false);
        } else if (this.rgSpecies.getSelectedItem() != null && "multiple".equals(this.rgSpecies.getSelectedItem().getValue())) {
            this.getMapComposer().mapSpecies(q, "Species assemblage", "species", 0, 21, null, -1, 3, 0.6f, Util.nextColour(), false);
        }
        LOGGER.debug((Object)"Maxent Selected layers:");
        LOGGER.debug((Object)this.getSelectedLayers());
        return this.runmaxent();
    }

    private void setupData() throws Exception {
        if (this.query == null) {
            this.sa = this.getSelectedArea();
            this.query = QueryUtil.queryFromSelectedArea((Query)this.getSelectedSpecies(), (SelectedArea)this.sa, (boolean)false, (boolean[])this.getGeospatialKosher());
            this.sbenvsel = this.getSelectedLayers();
        }
    }

    public long getEstimate() {
        try {
            this.setupData();
            StringBuilder sbProcessUrl = new StringBuilder();
            sbProcessUrl.append(CommonData.getSatServer()).append("/ws/maxent/estimate?");
            sbProcessUrl.append("taxonid=").append(URLEncoder.encode(this.query.getName(), "UTF-8"));
            sbProcessUrl.append("&taxonlsid=").append(URLEncoder.encode(this.query.getQ(), "UTF-8"));
            sbProcessUrl.append("&envlist=").append(URLEncoder.encode(this.sbenvsel, "UTF-8"));
            sbProcessUrl.append("&speciesq=").append(URLEncoder.encode(QueryUtil.queryFromSelectedArea((Query)this.query, (SelectedArea)this.sa, (boolean)false, (boolean[])this.getGeospatialKosher()).getQ(), "UTF-8"));
            sbProcessUrl.append("&bs=").append(URLEncoder.encode(this.query.getBS(), "UTF-8"));
            if (this.chkJackknife.isChecked()) {
                sbProcessUrl.append("&chkJackknife=on");
            }
            if (this.chkRCurves.isChecked()) {
                sbProcessUrl.append("&chkResponseCurves=on");
            }
            sbProcessUrl.append("&txtTestPercentage=").append(this.txtTestPercentage.getValue());
            HttpClient client = new HttpClient();
            PostMethod get = new PostMethod(sbProcessUrl.toString());
            String area = this.sa.getMapLayer() != null && this.sa.getMapLayer().getEnvelope() != null ? "ENVELOPE(" + this.sa.getMapLayer().getEnvelope() + ")" : this.sa.getWkt();
            if (this.getSelectedArea() != null) {
                get.addParameter("area", area);
            }
            get.addRequestHeader("Accept", "text/plain");
            client.executeMethod((HttpMethod)get);
            String estimate = get.getResponseBodyAsString();
            return Long.valueOf(estimate);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unable to get estimates", (Throwable)e);
            return -1L;
        }
    }

    public boolean runmaxent() {
        try {
            this.setupData();
            LOGGER.debug((Object)("Selected species: " + this.query.getName()));
            LOGGER.debug((Object)("Selected species query: " + this.query.getQ()));
            LOGGER.debug((Object)"Selected env vars");
            LOGGER.debug((Object)this.sbenvsel);
            LOGGER.debug((Object)"Selected options: ");
            LOGGER.debug((Object)("Jackknife: " + this.chkJackknife.isChecked()));
            LOGGER.debug((Object)("Response curves: " + this.chkRCurves.isChecked()));
            LOGGER.debug((Object)("Test per: " + this.txtTestPercentage.getValue()));
            StringBuilder sbProcessUrl = new StringBuilder();
            sbProcessUrl.append(CommonData.getSatServer()).append("/ws/maxent?");
            sbProcessUrl.append("taxonid=").append(URLEncoder.encode(this.query.getName(), "UTF-8"));
            sbProcessUrl.append("&taxonlsid=").append(URLEncoder.encode(this.query.getQ(), "UTF-8"));
            sbProcessUrl.append("&envlist=").append(URLEncoder.encode(this.sbenvsel, "UTF-8"));
            sbProcessUrl.append("&speciesq=").append(URLEncoder.encode(QueryUtil.queryFromSelectedArea((Query)this.query, (SelectedArea)this.sa, (boolean)false, (boolean[])this.getGeospatialKosher()).getQ(), "UTF-8"));
            sbProcessUrl.append("&bs=").append(URLEncoder.encode(this.query.getBS(), "UTF-8"));
            if (this.chkJackknife.isChecked()) {
                sbProcessUrl.append("&chkJackknife=on");
            }
            if (this.chkRCurves.isChecked()) {
                sbProcessUrl.append("&chkResponseCurves=on");
            }
            sbProcessUrl.append("&txtTestPercentage=").append(this.txtTestPercentage.getValue());
            HttpClient client = new HttpClient();
            PostMethod get = new PostMethod(sbProcessUrl.toString());
            String area = this.sa.getMapLayer() != null && this.sa.getMapLayer().getEnvelope() != null ? "ENVELOPE(" + this.sa.getMapLayer().getEnvelope() + ")" : this.sa.getWkt();
            if (this.getSelectedArea() != null) {
                get.addParameter("area", area);
            }
            LOGGER.debug((Object)"Getting species data");
            get.addRequestHeader("Accept", "text/plain");
            client.executeMethod((HttpMethod)get);
            this.pid = get.getResponseBodyAsString();
            this.openProgressBar();
            try {
                String options = "";
                options = options + "Jackknife: " + this.chkJackknife.isChecked();
                options = options + ";Response curves: " + this.chkRCurves.isChecked();
                options = options + ";Test per: " + this.txtTestPercentage.getValue();
                if (this.query instanceof BiocacheQuery) {
                    BiocacheQuery bq = (BiocacheQuery)this.query;
                    options = bq.getWS() + "|" + bq.getBS() + "|" + bq.getFullQ(false) + "|" + options;
                    this.remoteLogger.logMapAnalysis(this.tToolName.getValue(), "Tool - Prediction", area, bq.getLsids(), this.sbenvsel, this.pid, options, "STARTED");
                } else {
                    this.remoteLogger.logMapAnalysis(this.tToolName.getValue(), "Tool - Prediction", area, this.query.getName() + "__" + this.query.getQ(), this.sbenvsel, this.pid, options, "STARTED");
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"error requesting maxent", (Throwable)e);
            }
            this.setVisible(false);
            return true;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Maxent error: ", (Throwable)e);
            this.getMapComposer().showMessage("Unknown error.", (Component)this);
            return false;
        }
    }

    void openProgressBar() {
        ProgressController window = (ProgressController)Executions.createComponents((String)"WEB-INF/zul/progress/AnalysisProgress.zul", (Component)this.getMapComposer(), null);
        window.setParentWindow((Window)this);
        window.start(this.pid, "Prediction", this.isBackgroundProcess);
        try {
            window.setParent((Component)this.getMapComposer());
            window.doModal();
        }
        catch (Exception e) {
            LOGGER.error((Object)"error opening AnaysisProgress.zul for Prediction", (Throwable)e);
        }
    }

    public void loadMap(Event event) {
        String mapurl = CommonData.getGeoServer() + "/wms?service=WMS&version=1.1.0&request=GetMap&layers=ALA:species_" + this.pid + "&styles=alastyles&FORMAT=image%2Fpng";
        String legendurl = CommonData.getGeoServer() + "/wms?REQUEST=GetLegendGraphic&VERSION=1.0.0&FORMAT=image/png&WIDTH=10&HEIGHT=1" + "&LAYER=ALA:species_" + this.pid + "&STYLE=alastyles";
        LOGGER.debug((Object)legendurl);
        String layername = this.tToolName.getValue();
        this.getMapComposer().addWMSLayer("species_" + this.pid, layername, mapurl, 0.5f, null, legendurl, 15, null, null);
        MapLayer ml = this.getMapComposer().getMapLayer("species_" + this.pid);
        ml.setPid(this.pid);
        String infoUrl = CommonData.getSatServer() + "/output/maxent/" + this.pid + "/species.html";
        MapLayerMetadata md = ml.getMapLayerMetadata();
        md.setMoreInfo(infoUrl + "\nMaxent Output\npid:" + this.pid);
        md.setId(Long.valueOf(this.pid).longValue());
        try {
            String fileUrl = CommonData.getSatServer() + "/ws/download/" + this.pid;
            Filedownload.save((InputStream)new URL(fileUrl).openStream(), (String)"application/zip", (String)(this.tToolName.getValue().replaceAll(" ", "_") + ".zip"));
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error generating download for prediction model:", (Throwable)e);
        }
        this.detach();
    }

    void fixFocus() {
        switch (this.currentStep) {
            case 1: {
                this.rgArea.setFocus(true);
                break;
            }
            case 2: {
                if (this.rSpeciesSearch.isChecked()) {
                    this.searchSpeciesACComp.getAutoComplete().setFocus(true);
                    break;
                }
                this.rgSpecies.setFocus(true);
                break;
            }
            case 3: {
                this.lbListLayers.setFocus(true);
                break;
            }
            case 4: {
                this.chkJackknife.setFocus(true);
                break;
            }
            case 5: {
                this.tToolName.setFocus(true);
                break;
            }
            default: {
                LOGGER.error((Object)("invalid step for MaxentComposer: " + this.currentStep));
            }
        }
    }
}

