/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.tool;

import au.org.ala.legend.Facet;
import au.org.ala.spatial.composer.layer.ContextualLayersAutoComplete;
import au.org.ala.spatial.composer.tool.ToolComposer;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.Query;
import au.org.ala.spatial.util.Util;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zul.Filedownload;

public class InOutComposer
extends ToolComposer {
    private static final Logger LOGGER = Logger.getLogger(InOutComposer.class);
    private int generationCount = 1;
    private ContextualLayersAutoComplete autoCompleteLayers;
    private String layerName;
    private String layerDisplayName;

    public void afterCompose() {
        super.afterCompose();
        this.selectedMethod = "In/Out Comparison";
        this.totalSteps = 2;
        this.updateWindowTitle();
    }

    public void onLastPanel() {
        super.onLastPanel();
    }

    public boolean onFinish() {
        Query query = this.getSelectedSpecies();
        if (query == null) {
            return false;
        }
        try {
            Query out;
            String outName;
            StringBuilder results = new StringBuilder();
            String field = CommonData.getLayerFacetNameDefault((String)this.layerName);
            JSONParser jp = new JSONParser();
            JSONObject jo = (JSONObject)jp.parse(Util.readUrl((String)(CommonData.getLayersServer() + "/field/" + field)));
            JSONArray objects = (JSONArray)jo.get((Object)"objects");
            double totalArea = 0.0;
            for (int i = 0; i < objects.size(); ++i) {
                if (!((JSONObject)objects.get(i)).containsKey((Object)"area_km")) continue;
                totalArea += ((Double)((JSONObject)objects.get(i)).get((Object)"area_km")).doubleValue();
            }
            Query in = query.newFacet(new Facet(field, "*", true), false);
            jo = CommonData.getLayer((String)this.layerName);
            boolean isMarine = Util.isSameDomain((String[])new String[]{"marine"}, (String[])Util.getDomain((JSONObject)jo));
            boolean isTerrestrial = Util.isSameDomain((String[])new String[]{"terrestrial"}, (String[])Util.getDomain((JSONObject)jo));
            String terrestrialQuery = CommonData.getSettings().getProperty("in_out_report.terrestrial.query", "cl2013:*");
            String terrestrialName = CommonData.getSettings().getProperty("in_out_report.terrestrial.name", "Other - ASGS Australian States and Territories");
            Double terrestrialArea = Double.parseDouble(CommonData.getSettings().getProperty("in_out_report.terrestrial.area", "7719806.774"));
            String marineQuery = CommonData.getSettings().getProperty("in_out_report.marine.query", "cl21:*");
            String marineName = CommonData.getSettings().getProperty("in_out_report.marine.name", "Other - IMCRA 4");
            Double marineArea = Double.parseDouble(CommonData.getSettings().getProperty("in_out_report.marine.area", "8669607.781"));
            double outArea = 0.0;
            if (isMarine && isTerrestrial) {
                outName = marineName + " AND " + terrestrialName;
                outArea = terrestrialArea + marineArea;
                out = query.newFacets(Arrays.asList(new Facet(field, "*", false), Facet.parseFacet((String)("(" + terrestrialQuery + " OR " + marineQuery + ")"))), false);
            } else if (isMarine) {
                outName = marineName;
                outArea = marineArea;
                out = query.newFacets(Arrays.asList(new Facet(field, "*", false), Facet.parseFacet((String)marineQuery)), false);
            } else if (isTerrestrial) {
                outName = terrestrialName;
                outArea = terrestrialArea;
                out = query.newFacets(Arrays.asList(new Facet(field, "*", false), Facet.parseFacet((String)terrestrialQuery)), false);
            } else {
                outName = "rest of the world";
                outArea = 5.1E8;
                out = query.newFacet(new Facet(field, "*", false), false);
            }
            results.append("Species,Area name,Sq km,Occurrences,Species\n");
            results.append(this.getSelectedSpeciesName()).append(",");
            results.append(this.layerDisplayName).append(",").append(totalArea).append(",").append(in.getOccurrenceCount()).append(",").append(in.getSpeciesCount()).append("\n");
            results.append(this.getSelectedSpeciesName()).append(",");
            results.append("Not in: ").append(this.layerDisplayName).append(" (").append(outName).append("),").append(outArea - totalArea).append(",").append(out.getOccurrenceCount()).append(",").append(out.getSpeciesCount()).append("\n");
            String metadata = "<html><body><div class='aooeoo'><div>Report for: " + this.getSelectedSpeciesName() + "<br />In area (" + this.layerDisplayName + ")<br />Out area (" + outName + ") </div><br />" + "<table >" + "<tr><td>Area name</td><td>Sq km</td><td>Occurrences</td><td>Species</td></tr>" + "<tr><td>" + this.layerDisplayName + "</td><td>" + String.format("%.2g", totalArea) + "</td><td>" + in.getOccurrenceCount() + "</td><td>" + in.getSpeciesCount() + "</td></tr>" + "<tr><td>Not in: " + this.layerDisplayName + "</td><td>" + String.format("%.2g", outArea - totalArea) + "</td><td>" + out.getOccurrenceCount() + "</td><td>" + out.getSpeciesCount() + "</td></tr>" + "</table></div>";
            Event ev = new Event("onClick", null, (Object)("In Out Report\n" + metadata));
            this.getMapComposer().openHTML(ev);
            Filedownload.save((String)results.toString(), (String)"text/plain", (String)"In Out Report.csv");
            this.detach();
            return true;
        }
        catch (Exception e) {
            LOGGER.error((Object)"failed In Out finish", (Throwable)e);
            return false;
        }
    }

    public boolean download(Event event) {
        return false;
    }

    void fixFocus() {
    }

    public void onChange$autoCompleteLayers(Event event) {
        if (this.autoCompleteLayers.getItemCount() > 0 && this.autoCompleteLayers.getSelectedItem() != null) {
            JSONObject jo = (JSONObject)this.autoCompleteLayers.getSelectedItem().getValue();
            this.layerName = (String)jo.get((Object)"name");
            this.layerDisplayName = (String)jo.get((Object)"displayname");
            this.btnOk.setDisabled(false);
        } else {
            this.btnOk.setDisabled(true);
        }
    }
}

