/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.tool;

import au.org.ala.spatial.composer.tool.ToolComposer;
import au.org.ala.spatial.util.BiocacheQuery;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.Query;
import au.org.ala.spatial.util.QueryUtil;
import au.org.ala.spatial.util.Util;
import au.org.emii.portal.menu.MapLayer;
import au.org.emii.portal.menu.MapLayerMetadata;
import au.org.emii.portal.menu.SelectedArea;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Scanner;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.log4j.Logger;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.Button;
import org.zkoss.zul.Checkbox;
import org.zkoss.zul.Combobox;
import org.zkoss.zul.Filedownload;
import org.zkoss.zul.Hbox;
import org.zkoss.zul.Label;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.Radiogroup;
import org.zkoss.zul.Slider;
import org.zkoss.zul.Textbox;

public class GDMComposer
extends ToolComposer {
    private static final Logger LOGGER = Logger.getLogger(GDMComposer.class);
    private Query query = null;
    private String sbenvsel = "";
    private String area = null;
    private Listbox lbenvlayers;
    private Button btnClearlbenvlayers;
    private Listbox cutpoint;
    private Radiogroup rgdistance;
    private Combobox weighting;
    private Checkbox useSubSample;
    private Textbox sitePairsSize;
    private Slider sitesslider;
    private Label sitesslidermin;
    private Label sitesslidermax;
    private Label sitessliderper;
    private Label sitessliderdef;
    private Hbox sliderbox;
    private double maxScroll = 100.0;
    private String step1Id = null;
    private String step2Id = null;
    private String statusMsg = "";
    private long startTime;

    public void afterCompose() {
        super.afterCompose();
        this.selectedMethod = "GDM";
        this.totalSteps = 5;
        this.loadAreaLayers();
        this.loadSpeciesLayers();
        this.loadGridLayers(true, false, true);
        this.updateWindowTitle();
        try {
            this.sitesslider.addEventListener("onScrolling", (EventListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Error in slider");
            LOGGER.debug((Object)e.getMessage());
        }
    }

    public void onClick$btnClearlbenvlayers(Event event) {
        this.lbenvlayers.clearSelection();
        if (this.lbenvlayers.getSelectedCount() == 0) {
            this.btnOk.setDisabled(true);
        }
    }

    public void onSelect$lbenvlayers(Event event) {
        this.btnOk.setDisabled(this.lbenvlayers.getSelectedCount() < 1);
    }

    public void onLastPanel() {
        super.onLastPanel();
        this.updateName(this.getMapComposer().getNextAreaLayerName("My GDM"));
    }

    public boolean onFinish() {
        if (this.query == null) {
            this.getMapComposer().showMessage("There is a problem selecting the species.  Try to select the species again", (Component)this);
            return false;
        }
        if (this.searchSpeciesACComp.hasValidItemSelected()) {
            this.getMapComposer().mapSpeciesFromAutocompleteComponent(this.searchSpeciesACComp, this.getSelectedArea(), this.getGeospatialKosher(), false);
        } else if (this.rgSpecies.getSelectedItem() != null && "multiple".equals(this.rgSpecies.getSelectedItem().getValue())) {
            this.getMapComposer().mapSpecies(this.query, "Species assemblage", "species", 0, 21, null, -1, 3, 0.6f, Util.nextColour(), false);
        }
        return this.rungdm();
    }

    public void onClick$btnOk(Event event) {
        LOGGER.debug((Object)("Completing step " + this.currentStep + " for GDM"));
        if (this.currentStep == 3) {
            LOGGER.debug((Object)"checking with server for step 1");
            boolean step1 = this.runGDMStep1();
            return;
        }
        super.onClick$btnOk(event);
    }

    public boolean runGDMStep1() {
        try {
            SelectedArea sa = this.getSelectedArea();
            this.query = QueryUtil.queryFromSelectedArea((Query)this.getSelectedSpecies(), (SelectedArea)sa, (boolean)false, (boolean[])this.getGeospatialKosher());
            this.sbenvsel = this.getSelectedLayers();
            if (this.query.getSpeciesCount() < 2) {
                this.getMapComposer().showMessage("An list of species with multiple occurrences for each species is required by GDM.", (Component)this);
                return false;
            }
            HttpClient client = new HttpClient();
            PostMethod get = new PostMethod(CommonData.getSatServer() + "/ws/gdm/step1?" + "envlist=" + URLEncoder.encode(this.sbenvsel, "UTF-8") + "&taxacount=" + this.query.getSpeciesCount() + "&speciesq=" + URLEncoder.encode(QueryUtil.queryFromSelectedArea((Query)this.query, (SelectedArea)sa, (boolean)false, (boolean[])this.getGeospatialKosher()).getQ(), "UTF-8") + "&bs=" + URLEncoder.encode(this.query.getBS(), "UTF-8"));
            this.area = sa.getMapLayer() != null && sa.getMapLayer().getEnvelope() != null ? "ENVELOPE(" + sa.getMapLayer().getEnvelope() + ")" : sa.getWkt();
            if (this.getSelectedArea() != null) {
                get.addParameter("area", this.area);
            }
            get.addRequestHeader("Accept", "text/plain");
            LOGGER.debug((Object)"calling gdm ws step 1");
            client.executeMethod((HttpMethod)get);
            this.step1Id = get.getResponseBodyAsString();
            LOGGER.debug((Object)this.step1Id);
            this.getFellow("runningMsg1").setVisible(true);
            this.statusMsg = ((Label)this.getFellow("runningMsg1")).getValue();
            this.startTime = System.currentTimeMillis();
            Events.echoEvent((String)"step1Status", (Component)this, null);
            this.btnOk.setDisabled(true);
            return true;
        }
        catch (Exception e) {
            LOGGER.error((Object)"GDM error: ", (Throwable)e);
            this.getMapComposer().showMessage("Unknown error.", (Component)this);
            return false;
        }
    }

    public void step1Status(Event event) {
        try {
            String response = Util.readUrl((String)(CommonData.getSatServer() + "/ws/gdm/step1/status?id=" + this.step1Id));
            if (response != null) {
                if (response.startsWith("error")) {
                    this.detach();
                    this.getMapComposer().showMessage("GDM error");
                    LOGGER.error((Object)("GDM error for step 1. id=" + this.step1Id));
                    return;
                }
                if (!response.startsWith("running")) {
                    Listcell lc;
                    Listitem li;
                    Scanner s = new Scanner(response);
                    this.pid = s.nextLine();
                    s.nextLine();
                    if (!this.cutpoint.getItems().isEmpty()) {
                        this.cutpoint.getItems().clear();
                        li = new Listitem();
                        lc = new Listcell("0");
                        lc.setParent((Component)li);
                        lc = new Listcell("All records");
                        lc.setParent((Component)li);
                        lc = new Listcell("All records");
                        lc.setParent((Component)li);
                        li.setValue((Object)"0");
                        li.setParent((Component)this.cutpoint);
                    }
                    while (s.hasNext()) {
                        li = new Listitem();
                        String[] sxs = s.nextLine().split(",");
                        lc = new Listcell(sxs[0]);
                        lc.setParent((Component)li);
                        lc = new Listcell(sxs[1]);
                        lc.setParent((Component)li);
                        lc = new Listcell(sxs[2]);
                        lc.setParent((Component)li);
                        li.setValue((Object)sxs[0]);
                        li.setParent((Component)this.cutpoint);
                    }
                    this.cutpoint.setSelectedIndex(0);
                    if (this.cutpoint.getItemCount() < 2) {
                        this.detach();
                        this.getMapComposer().showMessage("An assemblage of species with multiple occurrences \nfor each species is required by GDM.");
                    }
                    double maxBytes = 5.24288E8;
                    double maxS = maxBytes / (double)(this.lbListLayers.getSelectedCount() * 3 + 1) / 8.0;
                    double minS = (int)(maxS * 0.1);
                    this.maxScroll = maxS;
                    this.sitesslider.setCurpos((int)minS);
                    this.sitesslider.setMaxpos((int)maxS);
                    this.sitePairsSize.setValue(Long.toString(Math.round(minS)));
                    this.sitessliderdef.setValue(Long.toString(Math.round(minS)));
                    this.sitesslidermax.setValue(Long.toString(Math.round(maxS)));
                    this.btnOk.setDisabled(false);
                    super.onClick$btnOk(event);
                    return;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("error in GDM step1. id:" + this.step1Id), (Throwable)e);
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        ((Label)this.getFellow("runningMsg1")).setValue(this.statusMsg + " " + (System.currentTimeMillis() - this.startTime) / 1000L + "s");
        Events.echoEvent((String)"step1Status", (Component)this, null);
    }

    public void step2Status(Event event) {
        try {
            String response = Util.readUrl((String)(CommonData.getSatServer() + "/ws/gdm/step2/status?id=" + this.step2Id));
            if (response != null) {
                if (response.startsWith("error")) {
                    this.detach();
                    this.getMapComposer().showMessage("GDM error");
                    LOGGER.error((Object)("GDM error for step 2. id=" + this.step2Id));
                    return;
                }
                if (!response.startsWith("running")) {
                    this.pid = response.replace("\n", "");
                    this.loadMap(null);
                    this.setVisible(false);
                    String fileUrl = CommonData.getSatServer() + "/ws/download/" + this.pid;
                    Filedownload.save((InputStream)new URL(fileUrl).openStream(), (String)"application/zip", (String)(this.tToolName.getValue().replaceAll(" ", "_") + ".zip"));
                    String options = "";
                    options = options + "cutpoint: " + this.cutpoint.getSelectedItem().getValue();
                    options = options + ";useDistance: " + this.rgdistance.getSelectedItem().getValue();
                    options = options + ";weighting: " + this.weighting;
                    options = options + ";useSubSample: " + (this.useSubSample.isChecked() ? "1" : "0");
                    options = options + ";sitePairsSize: " + this.sitePairsSize.getValue();
                    if (this.query instanceof BiocacheQuery) {
                        BiocacheQuery bq = (BiocacheQuery)this.query;
                        options = bq.getWS() + "|" + bq.getBS() + "|" + bq.getFullQ(false) + "|" + options;
                        this.remoteLogger.logMapAnalysis(this.tToolName.getValue(), "Tool - Prediction", this.area, bq.getLsids(), this.sbenvsel, this.pid, options, "STARTED");
                    } else {
                        this.remoteLogger.logMapAnalysis(this.tToolName.getValue(), "Tool - Prediction", this.area, this.query.getName() + "__" + this.query.getQ(), this.sbenvsel, this.pid, options, "STARTED");
                    }
                    this.detach();
                    return;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("error checking GDM status. step2Id:" + this.pid), (Throwable)e);
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        ((Label)this.getFellow("runningMsg2")).setValue(this.statusMsg + " " + (System.currentTimeMillis() - this.startTime) / 1000L + "s");
        this.btnOk.setDisabled(true);
        Events.echoEvent((String)"step2Status", (Component)this, null);
    }

    public void onScroll$sitesslider(Event event) {
        double a = this.sitesslider.getCurpos();
        double b = a / this.maxScroll;
        long p = Math.round(b * 100.0);
        this.sitePairsSize.setValue(Integer.toString(this.sitesslider.getCurpos()));
        this.sitessliderper.setValue(p + "%");
    }

    public void onBlur$sitePairsSize(Event event) {
        try {
            this.sitesslider.setCurpos(Integer.parseInt(this.sitePairsSize.getValue()));
            this.onScroll$sitesslider(event);
        }
        catch (NumberFormatException e) {
            this.sitesslider.setCurpos(Integer.parseInt(this.sitessliderdef.getValue()));
        }
    }

    public void onCheck$useSubSample(Event event) {
        if (this.useSubSample.isChecked()) {
            this.sitePairsSize.setDisabled(true);
            this.sliderbox.setVisible(false);
        } else {
            this.sitePairsSize.setDisabled(false);
            this.sliderbox.setVisible(true);
            this.sitesslider.setCurpos(Integer.parseInt(this.sitePairsSize.getValue()));
        }
    }

    public boolean rungdm() {
        try {
            StringBuilder sbProcessUrl = new StringBuilder();
            sbProcessUrl.append(CommonData.getSatServer()).append("/ws/gdm/step2?");
            sbProcessUrl.append("&pid=").append(this.pid);
            sbProcessUrl.append("&cutpoint=").append(this.cutpoint.getSelectedItem().getValue());
            sbProcessUrl.append("&useDistance=").append(this.rgdistance.getSelectedItem().getValue());
            sbProcessUrl.append("&weighting=").append(this.weighting.getSelectedItem().getValue());
            sbProcessUrl.append("&useSubSample=").append(this.useSubSample.isChecked() ? "1" : "0");
            sbProcessUrl.append("&sitePairsSize=").append(this.sitePairsSize.getValue());
            sbProcessUrl.append("&name=").append(this.query.getName());
            HttpClient client = new HttpClient();
            PostMethod get = new PostMethod(sbProcessUrl.toString());
            get.addRequestHeader("Accept", "text/plain");
            LOGGER.debug((Object)("calling gdm ws: " + sbProcessUrl.toString()));
            client.executeMethod((HttpMethod)get);
            this.step2Id = get.getResponseBodyAsString();
            this.getFellow("runningMsg2").setVisible(true);
            this.statusMsg = ((Label)this.getFellow("runningMsg2")).getValue();
            this.startTime = System.currentTimeMillis();
            Events.echoEvent((String)"step2Status", (Component)this, null);
            return false;
        }
        catch (Exception e) {
            LOGGER.error((Object)"error finalizing GDM", (Throwable)e);
            return false;
        }
    }

    public void loadMap(Event event) {
        String[] envlist;
        for (String env : envlist = this.getSelectedLayers().split(":")) {
            String mapurl = CommonData.getGeoServer() + "/wms?service=WMS&version=1.1.0&request=GetMap&layers=ALA:gdm_" + env + "Tran_" + this.pid + "&styles=alastyles&FORMAT=image%2Fpng";
            String legendurl = CommonData.getGeoServer() + "/wms?REQUEST=GetLegendGraphic&VERSION=1.0.0&FORMAT=image/png&WIDTH=10&HEIGHT=1" + "&LAYER=ALA:gdm_" + env + "Tran_" + this.pid + "&STYLE=alastyles";
            LOGGER.debug((Object)legendurl);
            String layername = "Tranformed " + CommonData.getLayerDisplayName((String)env);
            this.getMapComposer().addWMSLayer(this.pid + "_" + env, layername, mapurl, 0.5f, null, legendurl, 16, null, null);
            MapLayer ml = this.getMapComposer().getMapLayer(this.pid + "_" + env);
            ml.setPid(this.pid + "_" + env);
            String infoUrl = CommonData.getSatServer() + "/output/gdm/" + this.pid + "/gdm.html";
            MapLayerMetadata md = ml.getMapLayerMetadata();
            md.setMoreInfo(infoUrl + "\nGDM Output\npid:" + this.pid);
            md.setId(Long.valueOf(this.pid).longValue());
        }
    }

    void fixFocus() {
        switch (this.currentStep) {
            case 1: {
                this.rgArea.setFocus(true);
                break;
            }
            case 2: {
                if (this.rSpeciesSearch.isChecked()) {
                    this.searchSpeciesACComp.getAutoComplete().setFocus(true);
                    break;
                }
                this.rgSpecies.setFocus(true);
                break;
            }
            case 3: {
                this.lbListLayers.setFocus(true);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.tToolName.setFocus(true);
                break;
            }
            default: {
                LOGGER.error((Object)("invalid step for GDMComposer: " + this.currentStep));
            }
        }
    }

    static /* synthetic */ double access$000(GDMComposer x0) {
        return x0.maxScroll;
    }

    static /* synthetic */ Slider access$100(GDMComposer x0) {
        return x0.sitesslider;
    }
}

