/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.tool;

import au.org.ala.spatial.composer.tool.ToolComposer;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.ShapefileUtils;
import au.org.ala.spatial.util.Zipper;
import au.org.emii.portal.menu.SelectedArea;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKTReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.geotools.kml.KML;
import org.geotools.kml.KMLConfiguration;
import org.geotools.xml.Configuration;
import org.geotools.xml.Encoder;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zul.Filedownload;
import org.zkoss.zul.Radiogroup;

public class ExportLayerComposer
extends ToolComposer {
    private static final Logger LOGGER = Logger.getLogger(ExportLayerComposer.class);
    private Radiogroup exportFormat;

    public void afterCompose() {
        super.afterCompose();
        this.selectedMethod = "Export area";
        this.totalSteps = 2;
        this.loadAreaLayers();
        this.updateWindowTitle();
        this.updateName(this.getMapComposer().getNextAreaLayerName("My Export Area"));
        if (this.rgArea.getItemCount() == 0) {
            this.getMapComposer().showMessage("No areas mapped. Create an area using Add to Map | Area");
            this.detach();
        }
    }

    public void onCheck$exportFormat(Event event) {
        this.btnOk.setDisabled(false);
    }

    public boolean onFinish() {
        this.exportAreaAs((String)this.exportFormat.getSelectedItem().getValue(), this.rAreaSelected.getLabel(), this.getSelectedArea());
        this.detach();
        return true;
    }

    void fixFocus() {
        if (this.currentStep == 1) {
            this.rgArea.setFocus(true);
        } else if (this.currentStep == 2) {
            this.exportFormat.setFocus(true);
        }
    }

    public void exportAreaAs(String type, String name, SelectedArea sa) {
        String exportBaseDir = CommonData.getSettings().getProperty("analysis_output_dir") + File.separator + "export" + File.separator;
        try {
            String id = String.valueOf(System.currentTimeMillis());
            File shpDir = new File(exportBaseDir + id + File.separator);
            shpDir.mkdirs();
            String contentType = "application/zip";
            String outfile = name.replaceAll(" ", "_");
            if ("shp".equals(type)) {
                File shpfile = new File(exportBaseDir + id + File.separator + outfile + "_Shapefile.shp");
                ShapefileUtils.saveShapefile((File)shpfile, (String)sa.getWkt(), (String)name);
                outfile = outfile + "_SHP.zip";
            } else if ("kml".equals(type)) {
                StringBuilder sbKml = new StringBuilder();
                sbKml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append("\r");
                sbKml.append("<kml xmlns=\"http://earth.google.com/kml/2.2\">").append("\r");
                sbKml.append("<Document>").append("\r");
                sbKml.append("  <name>Spatial Portal Active Area</name>").append("\r");
                sbKml.append("  <description><![CDATA[Active area saved from the ALA Spatial Portal: http://spatial.ala.org.au/]]></description>").append("\r");
                sbKml.append("  <Style id=\"style1\">").append("\r");
                sbKml.append("    <LineStyle>").append("\r");
                sbKml.append("      <color>40000000</color>").append("\r");
                sbKml.append("      <width>3</width>").append("\r");
                sbKml.append("    </LineStyle>").append("\r");
                sbKml.append("    <PolyStyle>").append("\r");
                sbKml.append("      <color>73FF0000</color>").append("\r");
                sbKml.append("      <fill>1</fill>").append("\r");
                sbKml.append("      <outline>1</outline>").append("\r");
                sbKml.append("    </PolyStyle>").append("\r");
                sbKml.append("  </Style>").append("\r");
                sbKml.append("  <Placemark>").append("\r");
                sbKml.append("    <name>").append(name).append("</name>").append("\r");
                sbKml.append("    <description><![CDATA[<div dir=\"ltr\">").append(name).append("<br></div>]]></description>").append("\r");
                sbKml.append("    <styleUrl>#style1</styleUrl>").append("\r");
                Geometry geom = new WKTReader().read(sa.getWkt());
                Encoder encoder = new Encoder((Configuration)new KMLConfiguration());
                encoder.setIndenting(true);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                encoder.encode((Object)geom, KML.Geometry, (OutputStream)baos);
                String kmlGeometry = new String(baos.toByteArray());
                sbKml.append(kmlGeometry.substring(kmlGeometry.indexOf("?>") + 2));
                sbKml.append("  </Placemark>").append("\r");
                sbKml.append("</Document>").append("\r");
                sbKml.append("</kml>").append("\r");
                File shpfile = new File(exportBaseDir + id + File.separator + outfile + "_KML.kml");
                BufferedWriter wout = new BufferedWriter(new FileWriter(shpfile));
                wout.write(sbKml.toString());
                wout.close();
                outfile = outfile + "_KML.zip";
            } else if ("wkt".equals(type)) {
                File shpfile = new File(exportBaseDir + id + File.separator + outfile + "_WKT.txt");
                BufferedWriter wout = new BufferedWriter(new FileWriter(shpfile));
                wout.write(sa.getWkt());
                wout.close();
                outfile = outfile + "_WKT.zip";
            }
            Zipper.zipDirectory((String)(exportBaseDir + id + File.separator), (String)(exportBaseDir + id + ".zip"));
            try {
                byte[] bytes = FileUtils.readFileToByteArray((File)new File(exportBaseDir + id + ".zip"));
                Filedownload.save((byte[])bytes, (String)contentType, (String)outfile);
            }
            catch (Exception e) {
                LOGGER.error((Object)("failed to download file : " + exportBaseDir + id + ".zip"), (Throwable)e);
            }
            try {
                this.remoteLogger.logMapAnalysis(name, "Export - " + StringUtils.capitalize((String)type) + " Area", sa.getWkt(), "", "", "", outfile, "download");
            }
            catch (Exception e) {
                LOGGER.error((Object)"remote logger error", (Throwable)e);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unable to export user area", (Throwable)e);
        }
    }
}

