/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.tool;

import au.org.ala.spatial.composer.layer.ContextualLayersAutoComplete;
import au.org.ala.spatial.composer.tool.ContextualLayerListComposer;
import au.org.ala.spatial.composer.tool.ToolComposer;
import au.org.ala.spatial.util.CommonData;
import java.util.HashMap;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zul.Button;
import org.zkoss.zul.Window;

public class ContextualLayerSelection
extends ToolComposer {
    private Button btnNext;
    private ContextualLayersAutoComplete autoCompleteLayers;
    private String treeName;
    private String treePath;
    private String treeMetadata;
    private int treeSubType;

    public void afterCompose() {
        super.afterCompose();
        this.btnNext.setDisabled(true);
    }

    public void onClick$btnCancel(Event event) {
        this.detach();
    }

    public void onClick$btnNext(Event event) {
        HashMap<String, Object> winProps = new HashMap<String, Object>();
        winProps.put("parent", this);
        winProps.put("parentname", "Tool");
        winProps.put("selectedMethod", this.selectedMethod);
        if (this.treeName != null) {
            this.getMapComposer().addWMSLayer(this.getMapComposer().getNextAreaLayerName(this.treeName), this.treeName, this.treePath.replace("&layers=", "&layer="), 0.75f, this.treeMetadata, null, this.treeSubType, null, null);
            String activeLayerName = this.treePath.replaceAll("^.*ALA:", "").replaceAll("&.*", "");
            String lyrSubType = "";
            if (this.treeSubType == 19) {
                lyrSubType = "Contextual";
            } else if (this.treeSubType == 20) {
                lyrSubType = "environmental";
            }
            this.remoteLogger.logMapArea(this.treeName, "Layer - " + lyrSubType, this.treePath, activeLayerName, this.treeMetadata);
        }
        Window window = (Window)Executions.createComponents((String)"WEB-INF/zul/add/area/AreaMapPolygon.zul", (Component)this.getParent(), winProps);
        window.doOverlapped();
        String script = this.getMapComposer().getOpenLayersJavascript().addFeatureSelectionTool();
        this.getMapComposer().getOpenLayersJavascript().execute(this.getMapComposer().getOpenLayersJavascript().getIFrameReferences() + script);
        this.detach();
    }

    public void onChange$autoCompleteLayers(Event event) {
        this.treeName = null;
        ContextualLayerListComposer llc = (ContextualLayerListComposer)this.getFellow("layerTree").getFellow("contextuallayerlistwindow");
        if (this.autoCompleteLayers.getItemCount() > 0 && this.autoCompleteLayers.getSelectedItem() != null) {
            JSONObject jo = (JSONObject)this.autoCompleteLayers.getSelectedItem().getValue();
            String metadata = CommonData.getLayersServer() + "/layers/view/more/" + jo.get((Object)"id");
            this.setLayer(jo.get((Object)"displayname").toString(), jo.get((Object)"displaypath").toString(), metadata, "environmental".equalsIgnoreCase(jo.get((Object)"type").toString()) ? 20 : 19);
        } else {
            if (llc.tree.getSelectedItem() == null) {
                return;
            }
            JSONParser jp = new JSONParser();
            JSONObject joLayer = null;
            try {
                joLayer = (JSONObject)jp.parse(llc.tree.getSelectedItem().getTreerow().getAttribute("lyr").toString());
            }
            catch (ParseException e) {
                // empty catch block
            }
            if (!"class".equals(joLayer.get((Object)"type"))) {
                String metadata = CommonData.getLayersServer() + "/layers/view/more/" + joLayer.get((Object)"id");
                this.setLayer(joLayer.get((Object)"displayname").toString(), joLayer.get((Object)"displaypath").toString(), metadata, "environmental".equalsIgnoreCase(joLayer.get((Object)"type").toString()) ? 20 : 19);
            } else {
                String classValue = joLayer.get((Object)"displayname").toString();
                String layer = joLayer.get((Object)"layername").toString();
                String displaypath = CommonData.getGeoServer() + "/wms?service=WMS&version=1.1.0&request=GetMap&layers=ALA:Objects&format=image/png&viewparams=s:" + joLayer.get((Object)"displaypath");
                displaypath = displaypath.replace("gwc/service/", "");
                String metadata = CommonData.getLayersServer() + "/layers/view/more/" + joLayer.get((Object)"id");
                this.setLayer(layer + " - " + classValue, displaypath, metadata, "environmental".equalsIgnoreCase(joLayer.get((Object)"type").toString()) ? 20 : 19);
            }
            if (this.getRoot().hasFellow("addlayerwindow")) {
                this.getRoot().getFellow("addlayerwindow").detach();
            }
        }
    }

    public void setLayer(String name, String displaypath, String metadata, int subType) {
        this.treeName = name;
        this.treePath = displaypath;
        this.treeMetadata = metadata;
        this.treeSubType = subType;
        this.autoCompleteLayers.setText(name);
        ContextualLayerListComposer llc = (ContextualLayerListComposer)this.getFellow("layerTree").getFellow("contextuallayerlistwindow");
        llc.tree.clearSelection();
        this.btnNext.setDisabled(false);
    }
}

