/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.tool;

import au.org.ala.spatial.composer.tool.ContextualLayerSelection;
import au.org.ala.spatial.util.CommonData;
import au.org.emii.portal.composer.UtilityComposer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.zkoss.zul.DefaultTreeModel;
import org.zkoss.zul.DefaultTreeNode;
import org.zkoss.zul.Tree;
import org.zkoss.zul.TreeModel;
import org.zkoss.zul.TreeNode;
import org.zkoss.zul.TreeitemRenderer;

public class ContextualLayerListComposer
extends UtilityComposer {
    private static final Logger LOGGER = Logger.getLogger(ContextualLayerListComposer.class);
    protected Tree tree;
    private ContextualLayerSelection contextualLayerSelection;
    private List empty = new ArrayList();

    public void afterCompose() {
        super.afterCompose();
        this.iterateAndLoad();
    }

    public void iterateAndLoad() {
        try {
            ArrayList<DefaultTreeNode> top = new ArrayList<DefaultTreeNode>();
            TreeMap htCat1 = new TreeMap();
            TreeMap htCat2 = new TreeMap();
            JSONArray layerlist = CommonData.getLayerListJSONArray();
            for (int i = 0; i < layerlist.size(); ++i) {
                JSONObject jo = (JSONObject)layerlist.get(i);
                if (!jo.get((Object)"enabled").toString().equalsIgnoreCase("true") || !"Contextual".equalsIgnoreCase(jo.get((Object)"type").toString())) continue;
                DefaultTreeNode stn = new DefaultTreeNode((Object)jo, (Collection)this.empty);
                String c1 = jo.containsKey((Object)"classification1") ? jo.get((Object)"classification1").toString() : "";
                String c2 = jo.containsKey((Object)"classification2") ? jo.get((Object)"classification2").toString() : "";
                this.addToMap(htCat1, htCat2, c1, c2, stn);
            }
            for (Map.Entry o : htCat1.entrySet()) {
                JSONParser jp = new JSONParser();
                JSONObject joCat = (JSONObject)jp.parse("{\"displayname\":\"" + o.getKey() + "\",\"type\":\"node\",\"subtype\":\"" + 19 + "\"}");
                ArrayList sorted = (ArrayList)o.getValue();
                Collections.sort(sorted, new /* Unavailable Anonymous Inner Class!! */);
                DefaultTreeNode cat = new DefaultTreeNode((Object)joCat, (Collection)sorted);
                top.add(cat);
            }
            DefaultTreeNode root = new DefaultTreeNode((Object)"ROOT", top);
            DefaultTreeModel stm = new DefaultTreeModel((TreeNode)root);
            this.tree.setModel((TreeModel)stm);
            this.renderTree();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error loading contextual layer list", (Throwable)e);
        }
    }

    private void addToMap(Map htCat1, Map htCat2, String cat1, String cat2, DefaultTreeNode treeNode) {
        String nCat1 = cat1;
        if (cat1.trim().isEmpty() || "?".equals(cat1.trim()) || "null".equals(cat1.trim())) {
            nCat1 = "Other";
        }
        if (cat2.trim().isEmpty() || "?".equals(cat2.trim()) || "null".equals(cat2.trim())) {
            ArrayList<DefaultTreeNode> alCat1 = (ArrayList<DefaultTreeNode>)htCat1.get(cat1);
            if (alCat1 == null) {
                alCat1 = new ArrayList<DefaultTreeNode>();
            }
            alCat1.add(treeNode);
            htCat1.put(nCat1, alCat1);
        } else {
            ArrayList<DefaultTreeNode> alCat1;
            String cat2Full = nCat1 + ">" + cat2;
            ArrayList<DefaultTreeNode> alCat2 = (ArrayList<DefaultTreeNode>)htCat2.get(cat2Full);
            if (alCat2 == null) {
                alCat2 = new ArrayList<DefaultTreeNode>();
            }
            alCat2.add(treeNode);
            if (!htCat2.containsKey(cat2Full)) {
                htCat2.put(cat2Full, alCat2);
            }
            if ((alCat1 = (ArrayList<DefaultTreeNode>)htCat1.get(cat1)) == null) {
                alCat1 = new ArrayList<DefaultTreeNode>();
            }
            String subtype = ((JSONObject)treeNode.getData()).get((Object)"type").toString();
            JSONParser jp = new JSONParser();
            JSONObject joCat2 = null;
            try {
                joCat2 = (JSONObject)jp.parse("{displayname:'" + cat2Full + "',type:'node',subtype:" + ("environmental".equalsIgnoreCase(subtype) ? 20 : 19) + "}");
            }
            catch (ParseException e) {
                LOGGER.error((Object)"parse error");
            }
            DefaultTreeNode stnCat2 = new DefaultTreeNode(joCat2, alCat2);
            boolean found = false;
            for (int i = 0; i < alCat1.size(); ++i) {
                if (!stnCat2.toString().equals(alCat1.get(i).toString())) continue;
                found = true;
                break;
            }
            if (!found) {
                alCat1.add(stnCat2);
            }
            if (!htCat1.containsKey(nCat1)) {
                htCat1.put(nCat1, alCat1);
            }
        }
    }

    void initALC() {
        if (this.contextualLayerSelection == null) {
            try {
                this.contextualLayerSelection = (ContextualLayerSelection)this.getFellow("contextuallayerselectionwindow", true);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Error initialising Contextual Layer Selection windows", (Throwable)e);
            }
        }
    }

    private void renderTree() {
        this.tree.setItemRenderer((TreeitemRenderer)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ ContextualLayerSelection access$000(ContextualLayerListComposer x0) {
        return x0.contextualLayerSelection;
    }
}

