/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.tool;

import au.org.ala.spatial.composer.tool.AreaReportPDFComposer;
import au.org.ala.spatial.composer.tool.ToolComposer;
import au.org.emii.portal.menu.MapLayer;
import au.org.emii.portal.menu.SelectedArea;
import au.org.emii.portal.util.AreaReportPDF;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zul.Div;
import org.zkoss.zul.Filedownload;
import org.zkoss.zul.Label;
import org.zkoss.zul.Progressmeter;
import org.zkoss.zul.Window;

public class AreaReportPDFComposer
extends ToolComposer {
    private static final Logger LOGGER = Logger.getLogger(AreaReportPDFComposer.class);
    private ExecutorService pool;
    private Future<AreaReportPDF> future;
    private Map progress;
    private Label progressLabel;
    private Div divProgress;
    private Progressmeter jobprogress;

    public void afterCompose() {
        super.afterCompose();
        this.selectedMethod = "Detailed Area Report (PDF)";
        this.totalSteps = 1;
        this.loadAreaLayers();
        this.updateWindowTitle();
    }

    public boolean onFinish() {
        if (this.pool != null) {
            return true;
        }
        Window w = (Window)this.getPage().getFellowIfAny("popupResults");
        if (w != null) {
            w.detach();
        }
        SelectedArea sa = this.getSelectedArea();
        String areaName = this.getSelectedAreaName();
        String areaDisplayName = this.getSelectedAreaDisplayName();
        MapLayer ml = this.getMapComposer().getMapLayer(areaName);
        double[] bbox = null;
        if (ml != null && ml.getMapLayerMetadata().getBbox() != null && ml.getMapLayerMetadata().getBbox().size() == 4) {
            bbox = new double[]{(Double)ml.getMapLayerMetadata().getBbox().get(0), (Double)ml.getMapLayerMetadata().getBbox().get(1), (Double)ml.getMapLayerMetadata().getBbox().get(2), (Double)ml.getMapLayerMetadata().getBbox().get(3)};
        }
        String area = areaDisplayName;
        String wkt = ml == null ? sa.getWkt() : (ml.getFacets() == null ? ml.getWKT() : null);
        List facets = ml != null && ml.getFacets() != null ? ml.getFacets() : null;
        this.progress = new ConcurrentHashMap();
        this.progress.put("label", "Starting");
        this.progress.put("percent", 0.0);
        1 pdfAreaReport = new /* Unavailable Anonymous Inner Class!! */;
        this.pool = Executors.newFixedThreadPool(1);
        this.future = this.pool.submit(pdfAreaReport);
        this.getMapComposer().getOpenLayersJavascript().execute("setTimeout('checkProgress()', 2000);");
        this.divProgress.setVisible(true);
        return true;
    }

    public void checkProgress(Event event) {
        if (this.future.isDone()) {
            this.progressLabel.setValue("Finished. Starting download.");
            this.jobprogress.setValue(100);
            try {
                Filedownload.save((byte[])((AreaReportPDF)this.future.get()).getPDF(), (String)"application/pdf", (String)"areaReport.pdf");
                this.detach();
            }
            catch (Exception e) {
                LOGGER.error((Object)"failed to download finished PDF report", (Throwable)e);
            }
        } else {
            this.progressLabel.setValue("Running> " + (String)this.progress.get("label"));
            this.jobprogress.setValue(Math.min(100, (int)((Double)this.progress.get("percent") * 100.0)));
            this.getMapComposer().getOpenLayersJavascript().execute("setTimeout('checkProgress()', 2000);");
        }
    }

    void fixFocus() {
        this.rgArea.setFocus(true);
    }

    public void onClick$btnCancel(Event event) {
        try {
            this.progress.put("cancel", true);
            this.pool.shutdownNow();
        }
        catch (Exception e) {
            LOGGER.error((Object)"failed to shutdown pdf area report when cancelled.", (Throwable)e);
        }
        super.onClick$btnCancel(event);
    }

    static /* synthetic */ Map access$000(AreaReportPDFComposer x0) {
        return x0.progress;
    }
}

