/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.tool;

import au.org.ala.spatial.composer.tool.ToolComposer;
import au.org.ala.spatial.util.CommonData;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.zkoss.zk.ui.event.Event;

public class AddLayerController
extends ToolComposer {
    private static final Logger LOGGER = Logger.getLogger(AddLayerController.class);

    public void afterCompose() {
        super.afterCompose();
        this.btnOk.setDisabled(true);
        this.selectedMethod = "Add layers";
        this.totalSteps = 1;
        this.setIncludeAnalysisLayersForUploadQuery(true);
        this.loadGridLayers(false, true, false);
        this.updateWindowTitle();
    }

    void fixFocus() {
        LOGGER.debug((Object)this.currentStep);
        if (this.currentStep == 1) {
            this.selectedLayersCombobox.setFocus(true);
        }
    }

    public void onClick$btnOk(Event event) {
        if (this.currentStep == 1) {
            this.loadMap(event);
        }
    }

    public void loadMap(Event event) {
        if (this.lbListLayers.getSelectedLayers().length > 0) {
            String[] sellayers;
            for (String s : sellayers = this.lbListLayers.getSelectedLayers()) {
                String type = "";
                String treeName = "";
                String treePath = "";
                String legendurl = "";
                String metadata = "";
                JSONArray layerlist = CommonData.getLayerListJSONArray();
                for (int j = 0; j < layerlist.size(); ++j) {
                    JSONObject jo = (JSONObject)layerlist.get(j);
                    String name = jo.get((Object)"name").toString();
                    if (!name.equals(s)) continue;
                    String uid = jo.get((Object)"id").toString();
                    type = jo.get((Object)"type").toString();
                    treeName = StringUtils.capitalize((String)jo.get((Object)"displayname").toString());
                    treePath = jo.get((Object)"displaypath").toString();
                    legendurl = CommonData.getGeoServer() + "/wms?REQUEST=GetLegendGraphic&VERSION=1.0.0&FORMAT=image/png&WIDTH=20&HEIGHT=9&LAYER=" + s;
                    metadata = CommonData.getLayersServer() + "/layers/view/more/" + uid;
                    break;
                }
                this.getMapComposer().addWMSLayer(s, treeName, treePath, 0.75f, metadata, legendurl, "environmental".equalsIgnoreCase(type) ? 20 : 19, null, null, null);
                this.remoteLogger.logMapArea(treeName, "Layer - " + type, treePath, s, metadata);
            }
        }
        this.detach();
    }

    public String getUid(String name) {
        String uid = "";
        try {
            JSONArray layerlist = CommonData.getLayerListJSONArray();
            for (int j = 0; j < layerlist.size(); ++j) {
                JSONObject jo = (JSONObject)layerlist.get(j);
                String n = jo.get((Object)"name").toString();
                if (!name.equals(n)) continue;
                uid = jo.get((Object)"id").toString();
                LOGGER.debug((Object)("id=" + uid));
                break;
            }
            return uid;
        }
        catch (Exception e) {
            LOGGER.error((Object)"error setting up env list", (Throwable)e);
            return null;
        }
    }
}

