/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.tool;

import au.org.ala.spatial.composer.progress.ProgressController;
import au.org.ala.spatial.composer.tool.ToolComposer;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.Util;
import au.org.emii.portal.menu.MapLayer;
import au.org.emii.portal.menu.MapLayerMetadata;
import au.org.emii.portal.menu.SelectedArea;
import au.org.emii.portal.wms.WMSStyle;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.log4j.Logger;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zul.Filedownload;
import org.zkoss.zul.Intbox;
import org.zkoss.zul.Window;

public class ALOCComposer
extends ToolComposer {
    private static final Logger LOGGER = Logger.getLogger(ALOCComposer.class);
    private String selectedLayers = "";
    private int generationCount = 1;
    private String layerLabel = "";
    private String legendPath = "";
    private Intbox groupCount;

    public void afterCompose() {
        super.afterCompose();
        this.selectedMethod = "Classification";
        this.totalSteps = 4;
        this.setIncludeAnalysisLayersForAnyQuery(true);
        this.loadAreaLayers();
        this.loadGridLayers(true, false, true);
        this.updateWindowTitle();
        this.updateName(this.getMapComposer().getNextAreaLayerName("My Classification"));
    }

    public void onLastPanel() {
        super.onLastPanel();
        this.updateName(this.getMapComposer().getNextAreaLayerName("My Classification"));
    }

    public boolean onFinish() {
        if (!this.hasEstimated && !this.isUserLoggedIn()) {
            this.checkEstimate();
            return false;
        }
        return this.runclassification();
    }

    public long getEstimate() {
        try {
            String sbenvsel = this.getSelectedLayers();
            if (sbenvsel.split(":").length > 50) {
                this.getMapComposer().showMessage(sbenvsel.split(":").length + " layers selected.  Please select fewer than 50 environmental layers in step 1.");
                return -1L;
            }
            if (this.groupCount.getValue() <= 1 || this.groupCount.getValue() > 200) {
                this.getMapComposer().showMessage("Please enter the number of groups to generate (2 to 200) in step 2.");
                return -1L;
            }
            SelectedArea sa = this.getSelectedArea();
            Object bbox = null;
            List bb = sa.getMapLayer() != null ? sa.getMapLayer().getMapLayerMetadata().getBbox() : Util.getBoundingBox((String)sa.getWkt());
            bbox = new double[][]{{(Double)bb.get(0), (Double)bb.get(1)}, {(Double)bb.get(2), (Double)bb.get(3)}};
            long cellsInBBox = (long)((bbox[1][0] - bbox[0][0]) / 0.01 * (bbox[1][1] - bbox[0][1]) / 0.01);
            long size = (long)(this.groupCount.getValue() + sbenvsel.split(":").length + 2) * cellsInBBox * 4L;
            LOGGER.debug((Object)("ALOC estimate size in MB, cells=" + cellsInBBox + ", bbox=" + bbox[0][0] + "," + bbox[0][1] + "," + bbox[1][0] + "," + bbox[1][1] + ", groups=" + this.groupCount.getValue() + ", layers=" + sbenvsel.split(":").length + ", size=" + size / 1024L / 1024L + ", max size=" + CommonData.getSettings().getProperty("aloc_size_limit_in_mb")));
            if (size / 1024L / 1024L > (long)Integer.parseInt(CommonData.getSettings().getProperty("aloc_size_limit_in_mb"))) {
                this.getMapComposer().showMessage("Analysis is too large.  Reduce the number of groups, number of layers or area.", (Component)this);
                return -1L;
            }
            HttpClient client = new HttpClient();
            PostMethod get = new PostMethod(CommonData.getSatServer() + "/ws/aloc/estimate?" + "gc=" + URLEncoder.encode(String.valueOf(this.groupCount.getValue()), "UTF-8") + "&envlist=" + URLEncoder.encode(sbenvsel, "UTF-8"));
            String area = sa.getMapLayer() != null && sa.getMapLayer().getEnvelope() != null ? "ENVELOPE(" + sa.getMapLayer().getEnvelope() + ")" : sa.getWkt();
            get.addParameter("area", area);
            get.addRequestHeader("Accept", "text/plain");
            client.executeMethod((HttpMethod)get);
            String estimate = get.getResponseBodyAsString();
            return Long.valueOf(estimate);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unable to get estimates", (Throwable)e);
            return -1L;
        }
    }

    void fixFocus() {
        switch (this.currentStep) {
            case 1: {
                this.rgArea.setFocus(true);
                break;
            }
            case 2: {
                this.lbListLayers.setFocus(true);
                break;
            }
            case 3: {
                this.groupCount.setFocus(true);
                break;
            }
            case 4: {
                this.tToolName.setFocus(true);
                break;
            }
            default: {
                LOGGER.error((Object)("invalid step for ALOCComposer: " + this.currentStep));
            }
        }
    }

    public void loadMap(Event event) {
        try {
            for (String s : this.getJob().split(";")) {
                if (!s.startsWith("gc")) continue;
                this.layerLabel = this.tToolName.getValue();
                ++this.generationCount;
                break;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"error getting ALOC job info", (Throwable)e);
        }
        if (this.layerLabel == null) {
            this.layerLabel = "My Classification " + this.generationCount;
            ++this.generationCount;
        }
        String mapurl = CommonData.getGeoServer() + "/wms?service=WMS&version=1.1.0&request=GetMap&layers=ALA:aloc_" + this.pid + "&FORMAT=image%2Fpng";
        String legendurl = CommonData.getGeoServer() + "/wms?REQUEST=GetLegendGraphic&VERSION=1.0.0&FORMAT=image/png&WIDTH=10&HEIGHT=1" + "&LAYER=ALA:aloc_" + this.pid;
        LOGGER.debug((Object)legendurl);
        this.legendPath = legendurl;
        this.getMapComposer().addWMSLayer("aloc_" + this.pid, this.layerLabel, mapurl, 0.5f, null, legendurl, 14, null, null);
        MapLayer mapLayer = this.getMapComposer().getMapLayer("aloc_" + this.pid);
        if (mapLayer != null) {
            mapLayer.setPid(this.pid);
            WMSStyle style = new WMSStyle();
            style.setName("Default");
            style.setDescription("Default style");
            style.setTitle("Default");
            style.setLegendUri(legendurl);
            LOGGER.debug((Object)("legend:" + this.legendPath));
            mapLayer.addStyle(style);
            mapLayer.setSelectedStyleIndex(1);
            MapLayerMetadata md = mapLayer.getMapLayerMetadata();
            String infoUrl = CommonData.getSatServer() + "/output/aloc/" + this.pid + "/classification.html" + "\nClassification output\npid:" + this.pid;
            md.setMoreInfo(infoUrl);
            md.setId(Long.valueOf(this.pid).longValue());
            this.getMapComposer().updateLayerControls();
            try {
                String fileUrl = CommonData.getSatServer() + "/ws/download/" + this.pid;
                Filedownload.save((InputStream)new URL(fileUrl).openStream(), (String)"application/zip", (String)(this.tToolName.getValue().replaceAll(" ", "_") + ".zip"));
            }
            catch (Exception ex) {
                LOGGER.error((Object)"Error generating download for classification model:", (Throwable)ex);
            }
        }
        this.detach();
    }

    String getJob() {
        try {
            StringBuilder sbProcessUrl = new StringBuilder();
            sbProcessUrl.append(CommonData.getSatServer()).append("/ws/jobs/").append("inputs").append("?pid=").append(this.pid);
            LOGGER.debug((Object)sbProcessUrl.toString());
            HttpClient client = new HttpClient();
            GetMethod get = new GetMethod(sbProcessUrl.toString());
            get.addRequestHeader("Accept", "text/plain");
            client.executeMethod((HttpMethod)get);
            String slist = get.getResponseBodyAsString();
            LOGGER.debug((Object)slist);
            return slist;
        }
        catch (Exception e) {
            LOGGER.error((Object)("error getting gob info pid=" + this.pid), (Throwable)e);
            return "";
        }
    }

    public boolean runclassification() {
        try {
            List bb;
            this.layerLabel = this.tToolName.getValue();
            String sbenvsel = this.getSelectedLayers();
            if (sbenvsel.split(":").length > 50) {
                this.getMapComposer().showMessage(sbenvsel.split(":").length + " layers selected.  Please select fewer than 50 environmental layers in step 1.");
                return false;
            }
            if (this.groupCount.getValue() <= 1 || this.groupCount.getValue() > 200) {
                this.getMapComposer().showMessage("Please enter the number of groups to generate (2 to 200) in step 2.");
                return false;
            }
            SelectedArea sa = this.getSelectedArea();
            Object bbox = null;
            if (sa.getMapLayer() != null && sa.getMapLayer().getMapLayerMetadata().getBbox() != null) {
                bb = sa.getMapLayer().getMapLayerMetadata().getBbox();
                bbox = new double[][]{{(Double)bb.get(0), (Double)bb.get(1)}, {(Double)bb.get(2), (Double)bb.get(3)}};
            } else {
                bb = Util.getBoundingBox((String)sa.getWkt());
                bbox = new double[][]{{(Double)bb.get(0), (Double)bb.get(1)}, {(Double)bb.get(2), (Double)bb.get(3)}};
            }
            if (bbox == null) {
                bbox = new double[][]{{-180.0, -90.0}, {180.0, 90.0}};
            }
            long cellsInBBox = (long)((bbox[1][0] - bbox[0][0]) / 0.01 * (bbox[1][1] - bbox[0][1]) / 0.01);
            long size = (long)(this.groupCount.getValue() + sbenvsel.split(":").length + 2) * cellsInBBox * 4L;
            LOGGER.debug((Object)("ALOC estimate size in MB, cells=" + cellsInBBox + ", bbox=" + bbox[0][0] + "," + bbox[0][1] + "," + bbox[1][0] + "," + bbox[1][1] + ", groups=" + this.groupCount.getValue() + ", layers=" + sbenvsel.split(":").length + ", size=" + size / 1024L / 1024L + ", max size=" + CommonData.getSettings().getProperty("aloc_size_limit_in_mb")));
            if (size / 1024L / 1024L > (long)Integer.parseInt(CommonData.getSettings().getProperty("aloc_size_limit_in_mb"))) {
                this.getMapComposer().showMessage("Analysis is too large.  Reduce the number of groups, number of layers or area.", (Component)this);
                return false;
            }
            HttpClient client = new HttpClient();
            PostMethod get = new PostMethod(CommonData.getSatServer() + "/ws/aloc?" + "gc=" + URLEncoder.encode(String.valueOf(this.groupCount.getValue()), "UTF-8") + "&envlist=" + URLEncoder.encode(sbenvsel, "UTF-8"));
            String area = sa.getMapLayer() != null && sa.getMapLayer().getEnvelope() != null ? "ENVELOPE(" + sa.getMapLayer().getEnvelope() + ")" : sa.getWkt();
            get.addParameter("area", area);
            get.addRequestHeader("Accept", "text/plain");
            client.executeMethod((HttpMethod)get);
            String slist = get.getResponseBodyAsString();
            ++this.generationCount;
            this.pid = slist;
            this.legendPath = "/WEB-INF/zul/legend/LayerLegendClassification.zul?pid=" + this.pid + "&layer=" + URLEncoder.encode(this.layerLabel, "UTF-8");
            try {
                this.remoteLogger.logMapAnalysis(this.tToolName.getValue(), "Tool - Classification", area, "", sbenvsel, this.pid, "gc: " + this.groupCount.getValue(), "STARTED");
            }
            catch (Exception e) {
                LOGGER.error((Object)"error with remote logger", (Throwable)e);
            }
            ProgressController window = (ProgressController)Executions.createComponents((String)"WEB-INF/zul/progress/AnalysisProgress.zul", (Component)this.getMapComposer(), null);
            window.setParentWindow((Window)this);
            window.start(this.pid, "Classification");
            window.setParent((Component)this.getMapComposer());
            window.doModal();
            this.setVisible(false);
            return true;
        }
        catch (Exception ex) {
            LOGGER.error((Object)("error opening AnalysisProgress.zul for classification: " + this.pid), (Throwable)ex);
            this.getMapComposer().showMessage("Unknown error.", (Component)this);
            return false;
        }
    }
}

