/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.species;

import au.org.ala.spatial.composer.species.SpeciesListListbox;
import au.org.ala.spatial.dto.SpeciesListDTO;
import au.org.ala.spatial.dto.SpeciesListItemDTO;
import au.org.ala.spatial.util.BiocacheQuery;
import au.org.ala.spatial.util.SpeciesListUtil;
import au.org.ala.spatial.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.log4j.Logger;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listhead;
import org.zkoss.zul.Listheader;
import org.zkoss.zul.ListitemRenderer;
import org.zkoss.zul.SimpleListModel;
import org.zkoss.zul.Textbox;

public class SpeciesListListbox
extends Listbox {
    private static final Logger LOGGER = Logger.getLogger(SpeciesListListbox.class);
    private List<String> selectedLists = new ArrayList();
    private List<SpeciesListDTO> currentLists;

    public SpeciesListListbox() {
        this.init();
    }

    private void postCheckBoxStatusChanged() {
        Events.sendEvent((Event)new Event("onSlCheckBoxChanged", (Component)this, (Object)this.selectedLists.size()));
    }

    public List<String> getSelectedLists() {
        return this.selectedLists;
    }

    public String getTitle() {
        return "Species List Items";
    }

    public void init() {
        this.setItemRenderer((ListitemRenderer)new /* Unavailable Anonymous Inner Class!! */);
        String searchTerm = this.getParent() != null ? ((Textbox)this.getParent().getFellowIfAny("txtSearchTerm") != null ? ((Textbox)this.getParent().getFellowIfAny("txtSearchTerm")).getValue() : null) : null;
        MutableInt listCount = new MutableInt();
        this.currentLists = new ArrayList(SpeciesListUtil.getPublicSpeciesLists((String)Util.getUserEmail(), (Integer)0, (Integer)1000000, null, null, (String)searchTerm, (MutableInt)listCount));
        this.setModel((ListModel)new SimpleListModel(this.currentLists));
    }

    public void onInitRender() {
        LOGGER.debug((Object)"ON INIT RENDER");
        Listhead head = this.getListhead();
        Listheader namehead = (Listheader)head.getChildren().get(1);
        namehead.setSortAscending((Comparator)new SpeciesListComparator("listName", true));
        namehead.setSortDescending((Comparator)new SpeciesListComparator("listName", false));
        Listheader datehead = (Listheader)head.getChildren().get(2);
        datehead.setSortAscending((Comparator)new SpeciesListComparator("dateCreated", true));
        datehead.setSortDescending((Comparator)new SpeciesListComparator("dateCreated", false));
        Listheader ownerhead = (Listheader)head.getChildren().get(3);
        ownerhead.setSortAscending((Comparator)new SpeciesListComparator("username", true));
        ownerhead.setSortDescending((Comparator)new SpeciesListComparator("username", false));
        Listheader counthead = (Listheader)head.getChildren().get(4);
        counthead.setSortAscending((Comparator)new SpeciesListComparator("count", true));
        counthead.setSortDescending((Comparator)new SpeciesListComparator("count", false));
        super.onInitRender();
    }

    public BiocacheQuery extractQueryFromSelectedLists(boolean[] geospatialKosher) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> names = new ArrayList<String>();
        for (String list : this.selectedLists) {
            Collection items = SpeciesListUtil.getListItems((String)list);
            for (SpeciesListItemDTO item : items) {
                if (item.getLsid() != null) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(item.getLsid());
                    continue;
                }
                names.add(item.getName());
            }
        }
        String[] unmatchedNames = !names.isEmpty() ? names.toArray(new String[names.size()]) : null;
        String lsids = sb.length() > 0 ? sb.toString() : null;
        return new BiocacheQuery(lsids, unmatchedNames, null, null, null, false, geospatialKosher);
    }

    public String getSelectedNames() {
        String name = "";
        for (String list : this.selectedLists) {
            for (SpeciesListDTO i : this.currentLists) {
                if (!i.getDataResourceUid().equals(list)) continue;
                if (name.length() > 0) {
                    name = name + "|";
                }
                name = name + i.getListName();
            }
        }
        return name;
    }

    public void onClick$btnSearchSpeciesListListbox(Event event) {
        this.init();
    }

    public void onClick$btnClearSearchSpeciesListListbox(Event event) {
        this.init();
    }

    static /* synthetic */ List access$000(SpeciesListListbox x0) {
        return x0.selectedLists;
    }

    static /* synthetic */ void access$100(SpeciesListListbox x0) {
        x0.postCheckBoxStatusChanged();
    }

    static /* synthetic */ Logger access$200() {
        return LOGGER;
    }
}

