/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.species;

import au.org.ala.spatial.composer.species.SpeciesAutoComplete;
import au.org.ala.spatial.util.BiocacheQuery;
import au.org.ala.spatial.util.Query;
import au.org.ala.spatial.util.QueryUtil;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.CheckEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.Checkbox;
import org.zkoss.zul.Comboitem;
import org.zkoss.zul.Div;
import org.zkoss.zul.Vbox;

public class SpeciesAutoCompleteComponent
extends Div {
    private static final Logger LOGGER = Logger.getLogger(SpeciesAutoCompleteComponent.class);
    private Vbox vbox;
    private Checkbox chkUseRawName;
    private SpeciesAutoComplete autoComplete;

    public SpeciesAutoCompleteComponent() {
        this.initChildren();
        this.appendChild((Component)this.vbox);
    }

    private void initChildren() {
        this.vbox = new Vbox();
        this.chkUseRawName = new Checkbox("Use the scientific names supplied with the records");
        this.chkUseRawName.setChecked(false);
        this.chkUseRawName.addEventListener("onCheck", (EventListener)new /* Unavailable Anonymous Inner Class!! */);
        this.autoComplete = new SpeciesAutoComplete();
        this.autoComplete.setAutodrop(true);
        this.autoComplete.setWidth("330px");
        this.autoComplete.addEventListener("onChange", (EventListener)new /* Unavailable Anonymous Inner Class!! */);
        this.vbox.appendChild((Component)this.chkUseRawName);
        this.vbox.appendChild((Component)this.autoComplete);
    }

    void autoCompleteSelectionChanged(Event event) {
        Events.sendEvent((Event)new Event("onValueSelected", (Component)this));
    }

    public boolean hasValidItemSelected() {
        return this.autoComplete.getSelectedItem() != null && this.autoComplete.getSelectedItem().getValue() != null;
    }

    public boolean hasValidAnnotatedItemSelected() {
        return this.autoComplete.getSelectedItem() != null && this.autoComplete.getSelectedItem().getAnnotatedProperties() != null && !this.autoComplete.getSelectedItem().getAnnotatedProperties().isEmpty();
    }

    public SpeciesAutoComplete getAutoComplete() {
        return this.autoComplete;
    }

    public Query getQuery(Map points, boolean forMapping, boolean[] geokosher) {
        Query query = this.chkUseRawName.isChecked() ? QueryUtil.get((String)this.autoComplete.getFacetField(), (String)((String)this.autoComplete.getSelectedItem().getAnnotatedProperties().get(0)), (boolean)forMapping, (boolean[])geokosher) : QueryUtil.get((String)((String)this.autoComplete.getSelectedItem().getAnnotatedProperties().get(0)), (Map)points, (boolean)forMapping, (boolean[])geokosher);
        return query;
    }

    public void onCheck$chkUseRawName(Event event) {
        boolean checked = ((CheckEvent)event).isChecked();
        BiocacheQuery q = checked ? new BiocacheQuery(null, null, null, null, false, new boolean[]{true, true, false}) : null;
        this.autoComplete.setBiocacheQuery(q);
    }

    public boolean shouldUseRawName() {
        return this.chkUseRawName.isChecked();
    }

    public String[] getSelectedTaxonDetails() {
        if (this.hasValidAnnotatedItemSelected()) {
            String rank;
            Comboitem si = this.autoComplete.getSelectedItem();
            if (this.shouldUseRawName()) {
                return new String[]{this.autoComplete.getValue(), "unmatched"};
            }
            String taxon = this.autoComplete.getValue();
            String spVal = si.getDescription();
            if (spVal.trim().contains(": ")) {
                taxon = spVal.trim().substring(spVal.trim().indexOf(":") + 1, spVal.trim().indexOf("-")).trim() + " (" + taxon + ")";
                rank = spVal.trim().substring(0, spVal.trim().indexOf(":"));
            } else {
                rank = StringUtils.substringBefore((String)spVal, (String)" ").toLowerCase();
                LOGGER.debug((Object)("mapping rank and species: " + rank + " - " + taxon));
            }
            if ("scientific name".equalsIgnoreCase(rank) || "scientific".equalsIgnoreCase(rank)) {
                rank = "taxon";
            }
            return new String[]{taxon, rank};
        }
        return new String[0];
    }
}

