/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.species;

import au.org.ala.spatial.dto.UserDataDTO;
import au.org.ala.spatial.util.BiocacheQuery;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.LsidCountsDynamic;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Sessions;
import org.zkoss.zk.ui.event.InputEvent;
import org.zkoss.zul.Combobox;
import org.zkoss.zul.Comboitem;

public class SpeciesAutoComplete
extends Combobox {
    private static final Logger LOGGER = Logger.getLogger(SpeciesAutoComplete.class);
    private boolean biocacheOnly = false;
    private boolean bSearchCommon = false;
    private BiocacheQuery biocacheQuery;
    private String facetField = "raw_taxon_name";

    public SpeciesAutoComplete() {
        this.refresh("");
    }

    public SpeciesAutoComplete(String value) {
        super(value);
    }

    public SpeciesAutoComplete(BiocacheQuery query) {
        this.biocacheQuery = query;
    }

    public void setValue(String value) {
        super.setValue(value);
    }

    public boolean isSearchCommon() {
        return this.bSearchCommon;
    }

    public void setSearchCommon(boolean searchCommon) {
        this.bSearchCommon = searchCommon;
    }

    public void onChanging(InputEvent evt) {
        if (!evt.isChangingBySelectBack()) {
            this.refresh(evt.getValue());
        }
    }

    public void refresh(String val) {
        if (val.length() < 3) {
            return;
        }
        try {
            LOGGER.debug((Object)("Looking for common name: " + this.isSearchCommon()));
            this.getItems().clear();
            Iterator it = this.getItems().iterator();
            if (val.length() == 0) {
                Comboitem myci;
                if (it.hasNext()) {
                    myci = (Comboitem)it.next();
                    myci.setLabel("Please start by typing in a species name...");
                } else {
                    it = null;
                    myci = new Comboitem("Please start by typing in a species name...");
                    myci.setParent((Component)this);
                }
                myci.setDescription("");
                myci.setDisabled(true);
            } else {
                StringBuilder sb = new StringBuilder();
                if (this.biocacheQuery != null) {
                    sb.append(this.biocacheQuery.getAutoComplete("raw_taxon_name", val, 50));
                } else {
                    sb.append(this.searchService(val));
                }
                if (!this.biocacheOnly) {
                    sb.append(this.loadUserPoints(val));
                }
                String sslist = sb.toString();
                LOGGER.debug((Object)("SpeciesAutoComplete: \n" + sslist));
                Object[] aslist = sslist.split("\n");
                if (aslist.length > 0 && aslist[0].length() > 0) {
                    Arrays.sort(aslist);
                    for (int i = 0; i < aslist.length; ++i) {
                        String[] wmsChecklists;
                        Comboitem myci;
                        String[] spVal = ((String)aslist[i]).split("/");
                        String taxon = spVal[0].trim();
                        if (it != null && it.hasNext()) {
                            myci = (Comboitem)it.next();
                            myci.setLabel(taxon);
                        } else {
                            it = null;
                            myci = new Comboitem(taxon);
                            myci.setParent((Component)this);
                        }
                        String desc = spVal.length >= 4 ? spVal[2] + " - " + spVal[3] : spVal[2];
                        String[] wmsDistributions = CommonData.getSpeciesDistributionWMS((String)spVal[1]);
                        if (wmsDistributions.length > 0) {
                            desc = wmsDistributions.length == 1 ? desc + " +1 expert distribution" : desc + " +" + wmsDistributions.length + " expert distributions";
                        }
                        if ((wmsChecklists = CommonData.getSpeciesChecklistWMS((String)spVal[1])).length > 0) {
                            desc = wmsChecklists.length == 1 ? desc + " +1 checklist area" : desc + " +" + wmsChecklists.length + " checklist areas";
                        }
                        myci.setDescription(desc);
                        myci.setDisabled(false);
                        myci.setValue((Object)taxon);
                        myci.setDisabled(false);
                        if (myci.getAnnotations() != null) {
                            myci.getAnnotations().clear();
                        }
                        if (StringUtils.isNotBlank((String)spVal[1])) {
                            myci.addAnnotation(spVal[1], "LSID", null);
                            continue;
                        }
                        myci.addAnnotation(spVal[0], "value", null);
                    }
                }
            }
            while (it != null && it.hasNext()) {
                it.next();
                it.remove();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Oopss! something went wrong in SpeciesAutoComplete.refresh", (Throwable)e);
        }
    }

    private String loadUserPoints(String val) {
        Map htUserSpecies = (Map)Sessions.getCurrent().getAttribute("userpoints");
        String userPoints = "";
        String lVal = val.toLowerCase();
        try {
            if (htUserSpecies != null && !htUserSpecies.isEmpty()) {
                StringBuilder sbup = new StringBuilder();
                for (Map.Entry e : htUserSpecies.entrySet()) {
                    String k = (String)e.getKey();
                    UserDataDTO ud = (UserDataDTO)e.getValue();
                    if (!"user".contains(lVal) && !ud.getName().toLowerCase().contains(lVal) && !ud.getDescription().toLowerCase().contains(lVal)) continue;
                    sbup.append(ud.getName());
                    sbup.append(" /");
                    sbup.append(k);
                    sbup.append("/");
                    sbup.append("user");
                    sbup.append("/");
                    sbup.append(ud.getFeatureCount());
                    sbup.append("\n");
                }
                userPoints = sbup.toString();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unable to load user points into Species Auto Complete", (Throwable)e);
        }
        return userPoints;
    }

    String searchService(String val) throws Exception {
        String nsurl = CommonData.getBieServer() + "/search.json?pageSize=100&q=" + URLEncoder.encode(val, "UTF-8") + "&fq=idxtype:TAXON";
        HttpClient client = new HttpClient();
        GetMethod get = new GetMethod(nsurl);
        get.addRequestHeader("Content-type", "text/plain");
        client.executeMethod((HttpMethod)get);
        String rawJSON = get.getResponseBodyAsString();
        JSONParser jp = new JSONParser();
        JSONObject jo = (JSONObject)jp.parse(rawJSON);
        jo = (JSONObject)jo.get((Object)"searchResults");
        StringBuilder slist = new StringBuilder();
        JSONArray ja = (JSONArray)jo.get((Object)"results");
        for (int i = 0; i < ja.size(); ++i) {
            JSONObject o = (JSONObject)ja.get(i);
            try {
                if (!o.containsKey((Object)"name") || !o.containsKey((Object)"guid") || !o.containsKey((Object)"rank")) continue;
                CommonData.getLsidCounts();
                Integer count = LsidCountsDynamic.getCount((String)o.get((Object)"guid").toString());
                if (slist.length() > 0) {
                    slist.append("\n");
                }
                String commonName = null;
                boolean commonNameMatch = false;
                if (o.containsKey((Object)"commonName") && !"none".equals(o.get((Object)"commonName")) && !"null".equals(o.get((Object)"commonName"))) {
                    commonName = o.get((Object)"commonName").toString();
                    commonName = commonName.trim().replace("/", ",");
                    String[] cns = commonName.split(",");
                    for (int j = 0; j < cns.length; ++j) {
                        if (!cns[j].toLowerCase().contains(val)) continue;
                        commonName = cns[j];
                        commonNameMatch = true;
                        break;
                    }
                    if (commonName.indexOf(44) > 1) {
                        commonName = commonName.substring(0, commonName.indexOf(44));
                    }
                }
                if (commonNameMatch) {
                    slist.append(commonName).append(" /");
                    slist.append(o.get((Object)"guid")).append("/");
                    slist.append(o.get((Object)"rank"));
                    slist.append(", ").append(o.get((Object)"name").toString().replace("/", ","));
                    slist.append("/");
                    if (count != null) {
                        slist.append("found ");
                        slist.append(count);
                        continue;
                    }
                    slist.append("counting");
                    continue;
                }
                slist.append(o.get((Object)"name").toString().replace("/", ",")).append(" /");
                slist.append(o.get((Object)"guid")).append("/");
                slist.append(o.get((Object)"rank"));
                if (commonName != null) {
                    slist.append(", ").append(commonName);
                }
                slist.append("/");
                if (count != null) {
                    slist.append("found ");
                    slist.append(count);
                    continue;
                }
                slist.append("counting");
                continue;
            }
            catch (Exception e) {
                LOGGER.error((Object)("failed to add species autocomplete item: " + o), (Throwable)e);
            }
        }
        return slist.toString();
    }

    String autoService(String val) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd hh:mm:ss");
        StringBuilder slist = new StringBuilder();
        long start = System.currentTimeMillis();
        String nsurl = "";
        try {
            nsurl = CommonData.getBieServer() + "/search/auto.json?limit=50&q=" + URLEncoder.encode(val, "UTF-8");
            HttpClient client = new HttpClient();
            GetMethod get = new GetMethod(nsurl);
            get.addRequestHeader("Content-type", "text/plain");
            int result = client.executeMethod((HttpMethod)get);
            if (result != 200) {
                LOGGER.debug((Object)("SPECIES AUTOCOMPLETE ERROR|" + sdf.format(new Date()) + "|" + (System.currentTimeMillis() - start) + "ms|" + nsurl + "|response code " + result));
            } else {
                String rawJSON = get.getResponseBodyAsString();
                LOGGER.debug((Object)("SPECIES AUTOCOMPLETE SUCCESSFUL|" + sdf.format(new Date()) + "|" + (System.currentTimeMillis() - start) + "ms|" + nsurl));
                JSONParser jp = new JSONParser();
                JSONObject jo = (JSONObject)jp.parse(rawJSON);
                JSONArray ja = (JSONArray)jo.get((Object)"autoCompleteList");
                HashSet<String> lsids = new HashSet<String>();
                for (int i = 0; i < ja.size(); ++i) {
                    JSONObject o = (JSONObject)ja.get(i);
                    try {
                        if (!o.containsKey((Object)"left") || !o.containsKey((Object)"right") || !o.containsKey((Object)"name") || !o.containsKey((Object)"guid") || !o.containsKey((Object)"rankString") || lsids.contains(o.get((Object)"guid"))) continue;
                        CommonData.getLsidCounts();
                        Integer count = LsidCountsDynamic.getCount((String)o.get((Object)"guid").toString());
                        lsids.add(o.get((Object)"guid").toString());
                        if (slist.length() > 0) {
                            slist.append("\n");
                        }
                        String matchedName = o.get((Object)"name").toString().replace("/", ",");
                        if (o.containsKey((Object)"matchedNames") && !"null".equals(o.get((Object)"matchedNames")) && !"[]".equals(o.get((Object)"matchedNames"))) {
                            matchedName = ((JSONArray)o.get((Object)"matchedNames")).get(0).toString();
                        }
                        String commonName = null;
                        if (o.containsKey((Object)"commonName") && !"none".equals(o.get((Object)"commonName")) && !"null".equals(o.get((Object)"commonName"))) {
                            commonName = o.get((Object)"commonName").toString().replaceAll("\n", "");
                            commonName = commonName.trim().replace("/", ",");
                            String[] cns = commonName.split(",");
                            for (int j = 0; j < cns.length; ++j) {
                                if (!cns[j].toLowerCase().contains(val)) continue;
                                commonName = cns[j];
                                break;
                            }
                            if (commonName.indexOf(44) > 1) {
                                commonName = commonName.substring(0, commonName.indexOf(44));
                            }
                        }
                        if (o.containsKey((Object)"commonNameMatches") && !"null".equals(o.get((Object)"commonNameMatches")) && !"[]".equals(o.get((Object)"commonNameMatches"))) {
                            slist.append(matchedName).append(" /");
                            slist.append(o.get((Object)"guid")).append("/");
                            slist.append(o.get((Object)"rankString"));
                            slist.append(", ").append(o.get((Object)"name").toString().replace("/", ","));
                            slist.append("/");
                            if (count != null) {
                                slist.append("found ");
                                slist.append(count);
                                continue;
                            }
                            slist.append("counting");
                            continue;
                        }
                        slist.append(matchedName).append(" /");
                        slist.append(o.get((Object)"guid")).append("/");
                        slist.append(o.get((Object)"rankString"));
                        if (commonName != null) {
                            slist.append(", ").append(commonName);
                        }
                        slist.append("/");
                        if (count != null) {
                            slist.append("found ");
                            slist.append(count);
                            continue;
                        }
                        slist.append("counting");
                        continue;
                    }
                    catch (Exception e) {
                        LOGGER.debug((Object)("SPECIES AUTOCOMPLETE ERROR|" + sdf.format(new Date()) + "|" + (System.currentTimeMillis() - start) + "ms|" + nsurl), (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("SPECIES AUTOCOMPLETE ERROR|" + sdf.format(new Date()) + "|" + (System.currentTimeMillis() - start) + "ms|" + nsurl), (Throwable)e);
        }
        return slist.toString();
    }

    public void setBiocacheOnly(boolean biocacheOnly) {
        this.biocacheOnly = biocacheOnly;
    }

    public BiocacheQuery getBiocacheQuery() {
        return this.biocacheQuery;
    }

    public void setBiocacheQuery(BiocacheQuery biocacheQuery) {
        this.biocacheQuery = biocacheQuery;
    }

    public String getFacetField() {
        return this.facetField;
    }

    public void setFacetField(String facetField) {
        this.facetField = facetField;
    }
}

