/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.sandbox;

import au.org.ala.legend.Facet;
import au.org.ala.spatial.util.BiocacheQuery;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.Query;
import au.org.ala.spatial.util.Util;
import au.org.emii.portal.composer.UtilityComposer;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.impl.common.ReaderInputStream;
import org.zkoss.util.media.Media;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.ForwardEvent;
import org.zkoss.zk.ui.event.UploadEvent;
import org.zkoss.zul.Div;
import org.zkoss.zul.Iframe;

public class SandboxPasteController
extends UtilityComposer {
    private static final Logger LOGGER = Logger.getLogger(SandboxPasteController.class);
    private String dataResourceUid;
    private Div sandboxReady;
    private Iframe sandboxFrame;
    private BiocacheQuery query;
    private boolean addtoMap;
    private boolean defineArea;
    private EventListener callback;
    private String uploadId;
    private String uploadFn;

    public void afterCompose() {
        super.afterCompose();
    }

    public void setAddToMap(boolean addtoMap) {
        this.addtoMap = addtoMap;
    }

    public void gotDrUid(Event event) {
        this.dataResourceUid = (String)event.getData();
        this.sandboxReady.setVisible(true);
        this.sandboxFrame.setVisible(false);
        ArrayList<Facet> facetList = new ArrayList<Facet>();
        facetList.add(new Facet("data_resource_uid", this.dataResourceUid, true));
        this.query = new BiocacheQuery(null, null, null, facetList, true, null, CommonData.getSettings().getProperty("sandbox.biocache.url"), CommonData.getSettings().getProperty("sandbox.biocache.ws.url"), true);
        if (this.addtoMap) {
            this.getMapComposer().mapSpecies((Query)this.query, this.query.getSolrName(), "species", this.query.getOccurrenceCount(), 21, null, 0, 3, 0.6f, Util.nextColour(), false);
        }
        if (this.callback != null) {
            try {
                this.callback.onEvent((Event)new ForwardEvent("", null, null, (Object)new String[]{this.dataResourceUid, "normal"}));
            }
            catch (Exception e) {
                LOGGER.error((Object)"failed to cancel species points upload", (Throwable)e);
            }
        }
        this.onClick$btnOk(null);
    }

    public void setDefineArea(boolean defineArea) {
        this.defineArea = defineArea;
    }

    public void onClick$btnOk(Event event) {
        this.detach();
    }

    public void onClick$btnCancel(Event event) {
        if (this.callback != null) {
            try {
                this.callback.onEvent((Event)new ForwardEvent("", null, null, (Object)new String[]{"", "cancel"}));
            }
            catch (Exception e) {
                LOGGER.error((Object)"failed to cancel species points upload", (Throwable)e);
            }
        }
        this.detach();
    }

    private boolean upload(byte[] bytes, String filename, String contentType) throws Exception {
        File tmp = File.createTempFile("pointsUpload", "_" + filename);
        FileUtils.writeByteArrayToFile((File)tmp, (byte[])bytes);
        String url = CommonData.getSettings().getProperty("sandbox.url") + "upload/uploadFile";
        HttpClient httpClient = new HttpClient();
        PostMethod filePost = new PostMethod(url);
        Part[] parts = new Part[]{new FilePart("myFile", filename, tmp, contentType, null)};
        filePost.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, filePost.getParams()));
        int status = httpClient.executeMethod((HttpMethod)filePost);
        if (status == 302) {
            String responseText = filePost.getResponseHeader("Location").getValue();
            this.uploadId = responseText.substring(responseText.indexOf("preview/") + "preview/".length(), responseText.lastIndexOf(63));
            this.uploadFn = responseText.substring(responseText.indexOf(63) + 4);
            System.out.println(responseText);
            return true;
        }
        return false;
    }

    public void onUpload$fileUpload(Event event) {
        this.doFileUpload(event);
    }

    public void doFileUpload(Event event) {
        UploadEvent ue = null;
        if (event instanceof UploadEvent) {
            ue = (UploadEvent)event;
        } else if (event instanceof ForwardEvent) {
            ue = (UploadEvent)((ForwardEvent)event).getOrigin();
        }
        if (ue == null) {
            LOGGER.debug((Object)"unable to upload file");
            return;
        }
        LOGGER.debug((Object)"fileUploaded()");
        try {
            Media m = ue.getMedia();
            String filename = m.getName();
            String contentType = m.getContentType();
            String format = m.getFormat();
            boolean loaded = false;
            if (!loaded) {
                try {
                    loaded = this.upload(m.getByteData(), filename, contentType);
                    LOGGER.debug((Object)(m.getContentType() + " with getByteData"));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!loaded) {
                try {
                    loaded = this.upload(IOUtils.toByteArray((InputStream)m.getStreamData()), filename, contentType);
                    LOGGER.debug((Object)(m.getContentType() + " with getStreamData"));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                Reader r = m.getReaderData();
                ReaderInputStream is = new ReaderInputStream(r, "UTF-8");
                loaded = this.upload(IOUtils.toByteArray((InputStream)is), filename, contentType);
                LOGGER.debug((Object)(m.getContentType() + " with getReaderData"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!loaded) {
                try {
                    loaded = this.upload(m.getStringData().getBytes(), filename, contentType);
                    LOGGER.debug((Object)(m.getContentType() + " with getStringData"));
                }
                catch (Exception e) {
                    this.getMapComposer().showMessage(CommonData.lang((String)"error_uploading_file"));
                    LOGGER.error((Object)"unable to load user layer list: ", (Throwable)e);
                }
            }
            if (loaded) {
                ((Iframe)this.getFellow("sandboxFrame")).setSrc("sandboxPreview.html?uploadId=" + this.uploadId + "&uploadFn=" + this.uploadFn);
                this.getMapComposer().getOpenLayersJavascript().execute("$('#sandboxContainer')[0].style.display = \"inline\";setTimeout(\"setUrls()\",500)");
                this.getFellow("fileUpload").setVisible(false);
                this.getFellow("fileUpload").detach();
                this.getFellow("divSandbox").setVisible(false);
                this.setTop("10px");
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)"error reading uploaded file", (Throwable)ex);
        }
    }
}

