/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.sandbox;

import au.org.ala.legend.Facet;
import au.org.ala.spatial.util.BiocacheQuery;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.Query;
import au.org.ala.spatial.util.Util;
import au.org.emii.portal.composer.UtilityComposer;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.ForwardEvent;
import org.zkoss.zul.Div;
import org.zkoss.zul.Iframe;
import org.zkoss.zul.Label;

public class SandboxEmbeddedController
extends UtilityComposer {
    private static final Logger LOGGER = Logger.getLogger(SandboxEmbeddedController.class);
    private String dataResourceUid;
    private Div sandboxReady;
    private Iframe sandboxFrame;
    private BiocacheQuery query;
    private boolean addtoMap;
    private EventListener callback;
    private String tag;

    public void afterCompose() {
        super.afterCompose();
        this.tag = "SP" + System.currentTimeMillis();
        ((Label)this.getFellow("uploadTag")).setValue(this.tag);
        this.sandboxFrame.setSrc(CommonData.getSettings().getProperty("sandbox.url") + "upload?tag=" + this.tag);
    }

    public void setAddToMap(boolean addtoMap) {
        this.addtoMap = addtoMap;
    }

    public void gotDrUid(Event event) {
        this.dataResourceUid = (String)event.getData();
        this.sandboxReady.setVisible(true);
        this.sandboxFrame.setVisible(false);
        ArrayList<Facet> facetList = new ArrayList<Facet>();
        facetList.add(new Facet("data_resource_uid", this.dataResourceUid, true));
        this.query = new BiocacheQuery(null, null, null, facetList, true, null, CommonData.getSettings().getProperty("sandbox.biocache.url"), CommonData.getSettings().getProperty("sandbox.biocache.ws.url"), true);
        if (this.addtoMap) {
            this.getMapComposer().mapSpecies((Query)this.query, this.query.getSolrName(), "species", this.query.getOccurrenceCount(), 21, null, 0, 3, 0.6f, Util.nextColour(), false);
        }
        if (this.callback != null) {
            try {
                this.callback.onEvent((Event)new ForwardEvent("", null, null, (Object)new String[]{this.dataResourceUid, "normal"}));
            }
            catch (Exception e) {
                LOGGER.error((Object)"failed to cancel species points upload", (Throwable)e);
            }
        }
        this.onClick$btnOk(null);
    }

    public void onClick$btnOk(Event event) {
        this.detach();
    }

    public void onClick$btnCancel(Event event) {
        if (this.callback != null) {
            try {
                this.callback.onEvent((Event)new ForwardEvent("", null, null, (Object)new String[]{"", "cancel"}));
            }
            catch (Exception e) {
                LOGGER.error((Object)"failed to cancel species points upload", (Throwable)e);
            }
        }
        this.detach();
    }
}

