/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.results;

import au.org.ala.legend.Facet;
import au.org.ala.spatial.logger.RemoteLogger;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.Query;
import au.org.ala.spatial.util.QueryUtil;
import au.org.emii.portal.composer.UtilityComposer;
import au.org.emii.portal.menu.SelectedArea;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.zkoss.zhtml.Filedownload;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zul.Button;
import org.zkoss.zul.Label;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ListModelArray;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listhead;
import org.zkoss.zul.Listheader;
import org.zkoss.zul.ListitemRenderer;

public class SpeciesListResults
extends UtilityComposer {
    private static final Logger LOGGER = Logger.getLogger(SpeciesListResults.class);
    private String pid;
    private String[] results;
    private Button download;
    private Listbox popupListboxResults;
    private Label resultsLabel;
    private RemoteLogger remoteLogger;
    private SelectedArea selectedArea;
    private boolean[] geospatialKosher;
    private boolean chooseEndemic;
    private String extraParams;
    private boolean addedListener = false;

    public void afterCompose() {
        super.afterCompose();
        this.selectedArea = (SelectedArea)Executions.getCurrent().getArg().get("selectedarea");
        this.geospatialKosher = (boolean[])Executions.getCurrent().getArg().get("geospatialKosher");
        this.chooseEndemic = (Boolean)Executions.getCurrent().getArg().get("chooseEndemic");
        this.extraParams = (String)Executions.getCurrent().getArg().get("extraParams");
        List header = CommonData.getSpeciesListAdditionalColumnsHeader();
        for (int i = 0; i < header.size(); ++i) {
            Listhead lh = (Listhead)this.getFellow("listhead");
            Listheader lhr = new Listheader((String)header.get(i));
            lhr.setParent((Component)lh);
        }
        this.populateList();
    }

    public void populateList() {
        if (this.selectedArea == null) {
            this.selectedArea = new SelectedArea(null, this.getMapComposer().getViewArea());
        }
        try {
            Query sq = QueryUtil.queryFromSelectedArea(null, (SelectedArea)this.selectedArea, (String)this.extraParams, (boolean)false, (boolean[])this.geospatialKosher);
            if (sq.getSpeciesCount() <= 0) {
                this.getMapComposer().showMessage("No species records in the active area.");
                this.results = null;
                this.popupListboxResults.setVisible(false);
                this.resultsLabel.setVisible(false);
                this.detach();
                return;
            }
            String speciesList = this.chooseEndemic ? sq.endemicSpeciesList() : sq.speciesList();
            this.results = speciesList.substring(speciesList.indexOf(10) + 1).split("\n");
            Arrays.sort(this.results);
            Object[] tmp = this.results;
            if (this.results.length > 200) {
                tmp = Arrays.copyOf(this.results, 200);
                this.resultsLabel.setValue("preview of first 200 of " + this.results.length + " species found");
            } else {
                this.resultsLabel.setValue("preview of all " + this.results.length + " species found");
            }
            this.popupListboxResults.setModel((ListModel)new ListModelArray(tmp, false));
            this.popupListboxResults.setItemRenderer((ListitemRenderer)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            LOGGER.error((Object)"error reading species list data", (Throwable)e);
        }
    }

    public void onClick$btnDownload() {
        StringBuilder sb = new StringBuilder();
        sb.append("LSID,Scientific Name,Taxon Concept,Taxon Rank,Kingdom,Phylum,Class,Order,Family,Genus,Vernacular Name,Number of records");
        for (int i = 0; i < CommonData.getSpeciesListAdditionalColumnsHeader().size(); ++i) {
            sb.append(",").append((String)CommonData.getSpeciesListAdditionalColumnsHeader().get(i));
        }
        sb.append("\r\n");
        for (String s : this.results) {
            sb.append(s);
            sb.append("\r\n");
        }
        String spid = this.pid;
        if (spid == null || "none".equals(spid)) {
            spid = String.valueOf(System.currentTimeMillis());
        }
        SimpleDateFormat date = new SimpleDateFormat("yyyyMMdd");
        String sdate = date.format(new Date());
        Filedownload.save((String)sb.toString(), (String)"text/plain", (String)("Species_list_" + sdate + "_" + spid + ".csv"));
        if (this.selectedArea == null) {
            this.selectedArea = new SelectedArea(null, this.getMapComposer().getViewArea());
        }
        this.remoteLogger.logMapAnalysis("Species List", "Export - Species List", this.selectedArea.getFacets() != null ? ((Facet)this.selectedArea.getFacets().get(0)).toString() : this.selectedArea.getWkt(), "", "", spid, "Species_list_" + sdate + "_" + spid + ".csv", "");
        this.detach();
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }
}

