/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.results;

import au.com.bytecode.opencsv.CSVReader;
import au.org.ala.spatial.composer.results.PhylogeneticDiversityListResults;
import au.org.ala.spatial.logger.RemoteLogger;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.Query;
import au.org.ala.spatial.util.QueryUtil;
import au.org.ala.spatial.util.Util;
import au.org.emii.portal.composer.UtilityComposer;
import au.org.emii.portal.menu.SelectedArea;
import au.org.emii.portal.util.AreaReportPDF;
import java.io.ByteArrayOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.log4j.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.zkoss.zhtml.Filedownload;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zul.Button;
import org.zkoss.zul.Div;
import org.zkoss.zul.Label;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.ListitemRenderer;
import org.zkoss.zul.Progressmeter;
import org.zkoss.zul.SimpleListModel;

public class PhylogeneticDiversityListResults
extends UtilityComposer {
    private static final Logger LOGGER = Logger.getLogger(PhylogeneticDiversityListResults.class);
    private String pid;
    private Button download;
    private Listbox popupListboxResults;
    private Label resultsLabel;
    private RemoteLogger remoteLogger;
    private List<SelectedArea> selectedAreas;
    private List<Object> selectedTrees;
    private List<String> header;
    private List<Map<String, String>> areaPds;
    private List<Map<String, JSONArray>> areaSpeciesMatches;
    private String csv;
    private List<String[]> csvCells;
    private ExecutorService pool;
    private LinkedBlockingQueue<SelectedArea> queue = new LinkedBlockingQueue();
    private Future<AreaReportPDF> future;
    private Map progress;
    private Label progressLabel;
    private Div divProgress;
    private Div divResults;
    private Progressmeter jobprogress;
    private Query selectedQuery;

    public void afterCompose() {
        super.afterCompose();
        this.selectedAreas = (List)Executions.getCurrent().getArg().get("selectedareas");
        this.selectedTrees = (List)Executions.getCurrent().getArg().get("selectedtrees");
        this.selectedQuery = (Query)Executions.getCurrent().getArg().get("query");
        this.populateListWithProgressBar();
    }

    private void fillPDTreeList() {
        List list = this.csvCells.subList(1, this.csvCells.size());
        this.popupListboxResults.setModel((ListModel)new SimpleListModel(list));
        this.popupListboxResults.setItemRenderer((ListitemRenderer)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void populateListWithProgressBar() {
        this.areaPds = new ArrayList();
        this.areaSpeciesMatches = new ArrayList();
        for (SelectedArea sa : this.selectedAreas) {
            this.queue.add(sa);
        }
        this.progress = new ConcurrentHashMap();
        this.progress.put("label", "Starting");
        this.progress.put("percent", 0.0);
        2 backgroundProcess = new /* Unavailable Anonymous Inner Class!! */;
        this.pool = Executors.newFixedThreadPool(1);
        this.future = this.pool.submit(backgroundProcess);
        this.getMapComposer().getOpenLayersJavascript().execute("setTimeout('checkProgress()', 2000);");
        this.divProgress.setVisible(true);
        this.divResults.setVisible(false);
    }

    public void checkProgress(Event event) {
        if (this.future.isDone()) {
            this.progressLabel.setValue("Finished.");
            this.jobprogress.setValue(100);
            this.makeCSV();
            this.fillPDTreeList();
            this.divProgress.setVisible(false);
            this.divResults.setVisible(true);
        } else {
            this.progressLabel.setValue("Running> " + (String)this.progress.get("label"));
            this.jobprogress.setValue(Math.min(100, (int)(Double.parseDouble(String.valueOf(this.progress.get("percent"))) * 100.0)));
            this.getMapComposer().getOpenLayersJavascript().execute("setTimeout('checkProgress()', 2000);");
        }
    }

    public void populateList() {
        this.areaPds = new ArrayList();
        this.areaSpeciesMatches = new ArrayList();
        try {
            for (int i = 0; i < this.selectedAreas.size(); ++i) {
                SelectedArea sa = (SelectedArea)this.selectedAreas.get(i);
                this.evalArea(sa);
            }
            this.makeCSV();
            this.fillPDTreeList();
        }
        catch (Exception e) {
            LOGGER.error((Object)"error reading Phylogenetic Diversity list data", (Throwable)e);
            this.getMapComposer().showMessage("Unknown error.");
            this.detach();
        }
    }

    private void evalArea(SelectedArea sa) {
        try {
            Query sq = QueryUtil.queryFromSelectedArea((Query)this.selectedQuery, (SelectedArea)sa, null, (boolean)false, null);
            CSVReader r = new CSVReader((Reader)new StringReader(sq.speciesList()));
            JSONArray ja = new JSONArray();
            for (String[] s : r.readAll()) {
                ja.add((Object)s[1]);
            }
            String url = CommonData.getSettings().getProperty("phylolist_url") + "/phylo/getPD";
            NameValuePair[] params = new NameValuePair[]{new NameValuePair("noTreeText", "true"), new NameValuePair("speciesList", ja.toString())};
            JSONParser jp = new JSONParser();
            JSONArray pds = (JSONArray)jp.parse(Util.readUrlPost((String)url, (NameValuePair[])params));
            HashMap<String, String> pdrow = new HashMap<String, String>();
            HashMap<String, JSONArray> speciesRow = new HashMap<String, JSONArray>();
            for (int j = 0; j < pds.size(); ++j) {
                String tree = "" + ((JSONObject)pds.get(j)).get((Object)"studyId");
                pdrow.put(tree, ((JSONObject)pds.get(j)).get((Object)"pd").toString());
                speciesRow.put(tree, (JSONArray)((JSONObject)pds.get(j)).get((Object)"taxaRecognised"));
                String maxPd = ((JSONObject)pds.get(j)).get((Object)"maxPd").toString();
                for (int k = 0; k < this.selectedTrees.size(); ++k) {
                    if (!((String)((Map)this.selectedTrees.get(k)).get("studyId")).equals(tree)) continue;
                    ((Map)this.selectedTrees.get(k)).put("maxPd", maxPd);
                }
            }
            this.areaPds.add(pdrow);
            this.areaSpeciesMatches.add(speciesRow);
        }
        catch (Exception e) {
            LOGGER.error((Object)"failed processing a pd for a selected area.", (Throwable)e);
        }
    }

    private void makeCSV() {
        StringBuilder sb = new StringBuilder();
        sb.append("Area Name,Area (sq km),PD,Proportional PD (PD / Tree PD),");
        sb.append("Species,Proportional Species (Species / Tree Species),Tree Name,Tree ID,DOI,Study Name,Notes,Tree PD");
        for (int j = 0; j < this.selectedTrees.size(); ++j) {
            Map map = (Map)this.selectedTrees.get(j);
            for (int i = 0; i < this.selectedAreas.size(); ++i) {
                sb.append("\n");
                double pd = 0.0;
                double maxpd = 0.0;
                int speciesFound = 0;
                int studySpecieCount = 1;
                try {
                    pd = Double.parseDouble((String)((Map)this.areaPds.get(i)).get(map.get("studyId")));
                    maxpd = Double.parseDouble((String)map.get("maxPd"));
                    speciesFound = ((JSONArray)((Map)this.areaSpeciesMatches.get(i)).get(map.get("studyId"))).size();
                    studySpecieCount = Integer.parseInt((String)map.get("numberOfLeaves"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (((SelectedArea)this.selectedAreas.get(i)).getMapLayer() == null) {
                    sb.append(this.toCSVString("Current extent")).append(",");
                    sb.append(((SelectedArea)this.selectedAreas.get(i)).getKm2Area()).append(",");
                } else {
                    sb.append(this.toCSVString(((SelectedArea)this.selectedAreas.get(i)).getMapLayer().getDisplayName())).append(",");
                    sb.append(this.toCSVString(((SelectedArea)this.selectedAreas.get(i)).getKm2Area())).append(",");
                }
                String s = (String)((Map)this.areaPds.get(i)).get(map.get("studyId"));
                if (s == null) {
                    s = "";
                }
                sb.append(s).append(",");
                sb.append(String.format("%.4f,", pd / maxpd));
                sb.append("" + speciesFound).append(",");
                sb.append(String.format("%.4f,", (double)speciesFound / (double)studySpecieCount));
                sb.append(this.toCSVString((String)map.get("authors"))).append(",");
                sb.append(this.toCSVString((String)map.get("studyId"))).append(",");
                sb.append(this.toCSVString((String)map.get("doi"))).append(",");
                sb.append(this.toCSVString((String)map.get("studyName"))).append(",");
                sb.append(this.toCSVString((String)map.get("notes"))).append(",");
                sb.append(this.toCSVString((String)map.get("maxPd")));
            }
        }
        this.csv = sb.toString();
        try {
            this.csvCells = new CSVReader((Reader)new StringReader(this.csv)).readAll();
        }
        catch (Exception e) {
            LOGGER.error((Object)"failed to parse phylogenetic diversity list", (Throwable)e);
        }
    }

    private String toCSVString(String string) {
        if (string == null) {
            return "";
        }
        return "\"" + string.replace("\"", "\"\"").replace("\\", "\\\\") + "\"";
    }

    public void onClick$btnDownload() {
        HashMap<String, String> files = new HashMap<String, String>();
        String csvName = "Phylogenetic_Diversity.csv";
        files.put(csvName, this.csv);
        for (int j = 0; j < this.selectedTrees.size(); ++j) {
            Map map = (Map)this.selectedTrees.get(j);
            String treeId = (String)map.get("studyId");
            StringBuilder sb = new StringBuilder();
            sb.append("taxaRecognised (studyId ").append(treeId).append(")");
            for (int i = 0; i < this.selectedAreas.size(); ++i) {
                sb.append(",");
                if (((SelectedArea)this.selectedAreas.get(i)).getMapLayer() != null) {
                    sb.append(this.toCSVString(((SelectedArea)this.selectedAreas.get(i)).getMapLayer().getDisplayName()));
                    continue;
                }
                sb.append(this.toCSVString("Current extent"));
            }
            HashSet species = new HashSet();
            for (int i = 0; i < this.selectedAreas.size(); ++i) {
                if (((Map)this.areaSpeciesMatches.get(i)).get(treeId) == null) continue;
                Collections.sort((List)((Map)this.areaSpeciesMatches.get(i)).get(treeId));
                species.addAll((Collection)((Map)this.areaSpeciesMatches.get(i)).get(treeId));
            }
            String[] a = new String[species.size()];
            species.toArray(a);
            for (int i = 0; i < species.size(); ++i) {
                sb.append("\n");
                String s = a[i];
                sb.append("\"").append(s.replace("\"", "\"\"").replace("\\", "\\\\")).append("\"");
                for (int k = 0; k < this.selectedAreas.size(); ++k) {
                    int pos;
                    String v = "0";
                    if (((Map)this.areaSpeciesMatches.get(k)).get(treeId) != null && (pos = Collections.binarySearch((List)((Map)this.areaSpeciesMatches.get(k)).get(treeId), s)) >= 0 && pos < ((JSONArray)((Map)this.areaSpeciesMatches.get(k)).get(treeId)).size() && ((JSONArray)((Map)this.areaSpeciesMatches.get(k)).get(treeId)).get(pos).equals(s)) {
                        v = "1";
                    }
                    sb.append(",").append(v);
                }
            }
            files.put("taxaRecognised_studyId_" + treeId + ".csv", sb.toString());
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ZipOutputStream zos = new ZipOutputStream(bos);
            for (Map.Entry entry : files.entrySet()) {
                ZipEntry ze = new ZipEntry((String)entry.getKey());
                zos.putNextEntry(ze);
                zos.write(((String)entry.getValue()).getBytes());
                zos.closeEntry();
            }
            zos.close();
        }
        catch (Exception e) {
            LOGGER.error((Object)"error making zip file", (Throwable)e);
        }
        String spid = this.pid;
        if (spid == null || "none".equals(spid)) {
            spid = String.valueOf(System.currentTimeMillis());
        }
        SimpleDateFormat date = new SimpleDateFormat("yyyyMMdd");
        String sdate = date.format(new Date());
        Filedownload.save((byte[])bos.toByteArray(), (String)"application/zip", (String)("Phylogenetic_Diversity_" + sdate + "_" + spid + ".zip"));
        this.remoteLogger.logMapAnalysis("Phylogenetic Diversity", "Export - Phylogenetic Diversity", "", "", "", spid, "Phylogenetic_Diversity" + sdate + "_" + spid + ".zip", "");
        this.detach();
    }

    public void detach() {
        super.detach();
        this.queue.clear();
    }

    static /* synthetic */ List access$000(PhylogeneticDiversityListResults x0) {
        return x0.selectedTrees;
    }

    static /* synthetic */ LinkedBlockingQueue access$100(PhylogeneticDiversityListResults x0) {
        return x0.queue;
    }

    static /* synthetic */ List access$200(PhylogeneticDiversityListResults x0) {
        return x0.selectedAreas;
    }

    static /* synthetic */ Map access$300(PhylogeneticDiversityListResults x0) {
        return x0.progress;
    }

    static /* synthetic */ void access$400(PhylogeneticDiversityListResults x0, SelectedArea x1) {
        x0.evalArea(x1);
    }
}

