/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.results;

import au.com.bytecode.opencsv.CSVReader;
import au.org.ala.spatial.composer.results.DListComparator;
import au.org.emii.portal.composer.UtilityComposer;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zul.Caption;
import org.zkoss.zul.Doublebox;
import org.zkoss.zul.Filedownload;
import org.zkoss.zul.Label;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ListModelList;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listhead;
import org.zkoss.zul.Listheader;
import org.zkoss.zul.ListitemRenderer;

public class DistributionsController
extends UtilityComposer {
    private static final String EXPERT_DISTRIBUTION_AREA_NAME = "Expert distribution";
    private static final Logger LOGGER = Logger.getLogger(DistributionsController.class);
    private Label distributionLabel;
    private Listbox distributionListbox;
    private String[] text;
    private List<String[]> originalData;
    private List<String[]> currentData;
    private String type;
    private String originalCount;
    private Doublebox minDepth;
    private Doublebox maxDepth;

    public void afterCompose() {
        super.afterCompose();
        String title = null;
        String size = null;
        String[] table = null;
        Map m = Executions.getCurrent().getArg();
        if (m != null) {
            for (Map.Entry o : m.entrySet()) {
                if (!(o.getKey() instanceof String)) continue;
                if ("title".equals(o.getKey())) {
                    title = (String)o.getValue();
                }
                if ("size".equals(o.getKey())) {
                    size = (String)o.getValue();
                }
                if (!"table".equals(o.getKey())) continue;
                table = (String[])o.getValue();
            }
        }
        if (table != null) {
            this.init(table, title, size);
        }
    }

    public void onClick$btnApplyDepthFilter() {
        ArrayList newData = new ArrayList();
        for (int i = 0; i < this.originalData.size(); ++i) {
            try {
                double min = Double.parseDouble(((String[])this.originalData.get(i))[7]);
                double max = Double.parseDouble(((String[])this.originalData.get(i))[8]);
                if (this.minDepth.getValue() != null && !(this.minDepth.getValue() <= min) || this.maxDepth.getValue() != null && !(this.maxDepth.getValue() >= max)) continue;
                newData.add(this.originalData.get(i));
                continue;
            }
            catch (Exception e) {
                LOGGER.error((Object)"error applying depth filter", (Throwable)e);
            }
        }
        this.update(newData, String.valueOf(newData.size()));
    }

    public void onClick$btnClearDepthFilter() {
        this.minDepth.setValue(null);
        this.maxDepth.setValue(null);
        this.update(this.originalData, this.originalCount);
    }

    public void onClick$btnDownload(Event event) {
        try {
            String spid = String.valueOf(System.currentTimeMillis());
            SimpleDateFormat date = new SimpleDateFormat("yyyyMMdd");
            String sdate = date.format(new Date());
            StringBuilder sb = new StringBuilder();
            for (String s : this.text) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(s);
            }
            Filedownload.save((String)sb.toString(), (String)"text/plain;charset=UTF-8", (String)(this.type + "_" + sdate + "_" + spid + ".csv"));
        }
        catch (Exception e) {
            LOGGER.error((Object)"error downloading distributions area data", (Throwable)e);
        }
    }

    public void init(String[] text, String type, String count) {
        ((Caption)this.getFellow("cTitle")).setLabel(type);
        this.originalCount = count;
        this.type = type;
        String[] stringArray = this.text = text == null ? null : (String[])text.clone();
        if (text != null && text.length > 1) {
            ArrayList<String[]> data = new ArrayList<String[]>();
            for (int i = 1; i < text.length; ++i) {
                if (text[i] == null || text[i].length() <= 0) continue;
                try {
                    StringReader sreader = new StringReader(text[i]);
                    CSVReader reader = new CSVReader((Reader)sreader);
                    String[] row = reader.readNext();
                    String[] newrow = Arrays.copyOf(row, 15);
                    try {
                        String niceAreaSqKm;
                        newrow[12] = niceAreaSqKm = String.format("%.1f", Float.valueOf((float)Double.parseDouble(row[12])));
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)("error parsing area from: " + (row != null && row.length > 12 ? row[12] : "bad data")));
                    }
                    data.add(newrow);
                    reader.close();
                    sreader.close();
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error((Object)"error reading distributions row", (Throwable)e);
                }
            }
            if (this.originalData == null) {
                this.originalData = data;
            }
            this.update(data, this.originalCount);
        }
    }

    void update(List<String[]> data, String count) {
        this.currentData = data;
        this.distributionLabel.setValue("found " + count + " " + this.type + " in the Area");
        this.distributionListbox.setItemRenderer((ListitemRenderer)new /* Unavailable Anonymous Inner Class!! */);
        ListModelList lme = new ListModelList(data);
        this.distributionListbox.setModel((ListModel)lme);
        Listhead head = this.distributionListbox.getListhead();
        for (int i = 0; i < head.getChildren().size(); ++i) {
            Listheader lh = (Listheader)head.getChildren().get(i);
            if (i == 8 || i == 9 || i == 13) {
                lh.setSortAscending((Comparator)new DListComparator(true, true, i - 1));
                lh.setSortDescending((Comparator)new DListComparator(false, true, i - 1));
                continue;
            }
            if (i <= 0 || i == 10 || i == 11) continue;
            lh.setSortAscending((Comparator)new DListComparator(true, false, i - 1));
            lh.setSortDescending((Comparator)new DListComparator(false, false, i - 1));
        }
    }

    static /* synthetic */ List access$000(DistributionsController x0) {
        return x0.originalData;
    }

    static /* synthetic */ List access$100(DistributionsController x0) {
        return x0.currentData;
    }

    static /* synthetic */ Listbox access$200(DistributionsController x0) {
        return x0.distributionListbox;
    }

    static /* synthetic */ Logger access$300() {
        return LOGGER;
    }
}

