/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.results;

import au.org.ala.spatial.composer.results.AreaReportController;
import au.org.ala.spatial.composer.results.DistributionsController;
import au.org.ala.spatial.dto.AreaReportItemDTO;
import au.org.ala.spatial.logger.RemoteLogger;
import au.org.ala.spatial.util.BiocacheQuery;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.Query;
import au.org.ala.spatial.util.QueryUtil;
import au.org.ala.spatial.util.SpeciesListUtil;
import au.org.ala.spatial.util.Util;
import au.org.emii.portal.composer.UtilityComposer;
import au.org.emii.portal.menu.SelectedArea;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.zkoss.util.Locales;
import org.zkoss.util.resource.Labels;
import org.zkoss.zhtml.Filedownload;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.Caption;
import org.zkoss.zul.Div;
import org.zkoss.zul.Grid;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.RowRenderer;

/*
 * Exception performing whole class analysis ignored.
 */
public class AreaReportController
extends UtilityComposer {
    private static final String VIEW_RECORDS = "View Records";
    private static final Logger LOGGER = Logger.getLogger(AreaReportController.class);
    private String pid;
    private RemoteLogger remoteLogger;
    private String[] speciesDistributionText = null;
    private String[] speciesChecklistText = null;
    private String[] areaChecklistText = null;
    private boolean addedListener = false;
    private SelectedArea selectedArea = null;
    private String areaName = "Area Report";
    private String areaDisplayName = "Area Report";
    private String areaSqKm = null;
    private boolean includeEndemic;
    private Div divWorldNote;
    private JSONArray gazPoints = null;
    private JSONArray pointsOfInterest = null;
    private Map<String, Future<Map<String, String>>> futures = null;
    private long futuresStart = -1L;
    private ExecutorService pool = null;
    private List<String> firedEvents = null;
    private Grid facetsValues;
    private ChangableSimpleListModel areaReportListModel;
    private Map<String, AreaReportItemDTO> reportModelMap;
    private String journalmapHtml = null;

    public static void open(SelectedArea sa, String name, String displayName, String areaSqKm, double[] boundingBox, boolean includeEndemic) {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("includeEndemic", includeEndemic);
        params.put("displayPointsOfInterest", CommonData.getDisplayPointsOfInterest());
        AreaReportController win = (AreaReportController)Executions.createComponents((String)"/WEB-INF/zul/results/AreaReportResults.zul", null, params);
        try {
            win.doOverlapped();
            win.setPosition("center");
            win.setReportArea(sa, name, displayName, areaSqKm, boundingBox == null ? null : (double[])boundingBox.clone(), includeEndemic);
        }
        catch (Exception e) {
            LOGGER.error((Object)"error opening AreaReportResults.zul", (Throwable)e);
        }
    }

    public static JSONArray getGazPoints(String wkt) {
        try {
            int limit = Integer.MAX_VALUE;
            String url = CommonData.getLayersServer() + "/objects/inarea/" + CommonData.getSettings().get("area_report_gaz_field") + "?limit=" + limit;
            HttpClient client = new HttpClient();
            PostMethod post = new PostMethod(url);
            LOGGER.debug((Object)url);
            if (wkt != null) {
                post.addParameter("wkt", wkt);
            }
            post.addRequestHeader("Accept", "application/json, text/javascript, */*");
            int result = client.executeMethod((HttpMethod)post);
            if (result == 200) {
                String txt = post.getResponseBodyAsString();
                JSONParser jp = new JSONParser();
                return (JSONArray)jp.parse(txt);
            }
            LOGGER.debug((Object)(result + ", " + post.getResponseBodyAsString()));
        }
        catch (Exception e) {
            LOGGER.error((Object)("error getting number of gaz points in an area: " + wkt), (Throwable)e);
        }
        return null;
    }

    public static JSONArray getPointsOfInterest(String wkt) {
        try {
            String url = CommonData.getLayersServer() + "/intersect/poi/wkt";
            HttpClient client = new HttpClient();
            PostMethod post = new PostMethod(url);
            if (wkt != null) {
                NameValuePair nvp = new NameValuePair("wkt", wkt);
                post.setRequestBody(new NameValuePair[]{nvp});
            }
            post.addRequestHeader("Accept", "application/json, text/javascript, */*");
            int result = client.executeMethod((HttpMethod)post);
            if (result == 200) {
                String txt = post.getResponseBodyAsString();
                JSONParser jp = new JSONParser();
                return (JSONArray)jp.parse(txt);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("error getting points of interest in an area: " + wkt), (Throwable)e);
        }
        return null;
    }

    public static int getPointsOfInterestCount(String wkt) {
        try {
            String url = CommonData.getLayersServer() + "/intersect/poi/count/wkt";
            HttpClient client = new HttpClient();
            PostMethod post = new PostMethod(url);
            if (wkt != null) {
                NameValuePair nvp = new NameValuePair("wkt", wkt);
                post.setRequestBody(new NameValuePair[]{nvp});
            }
            post.addRequestHeader("Accept", "application/json, text/javascript, */*");
            int result = client.executeMethod((HttpMethod)post);
            if (result == 200) {
                String txt = post.getResponseBodyAsString();
                JSONParser jp = new JSONParser();
                return Integer.parseInt(((JSONObject)jp.parse(txt)).get((Object)"count").toString());
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("error getting points of interest in an area: " + wkt), (Throwable)e);
        }
        return -1;
    }

    public boolean shouldIncludeEndemic() {
        return this.includeEndemic;
    }

    public void setReportArea(SelectedArea sa, String name, String displayname, String areaSqKm, double[] boundingBox, boolean includeEndemic) {
        this.selectedArea = sa;
        this.areaName = name;
        this.areaDisplayName = displayname;
        this.areaSqKm = areaSqKm;
        this.includeEndemic = includeEndemic;
        ((Caption)this.getFellow("cTitle")).setLabel(displayname);
        if ("Current extent".equals(name)) {
            this.addListener();
        }
        this.startQueries();
        String extras = "";
        extras = extras + "areaSqKm: " + areaSqKm;
        if (boundingBox != null) {
            extras = extras + ";boundingBox: " + boundingBox[0] + "," + boundingBox[1] + "," + boundingBox[2] + "," + boundingBox[3];
        }
        this.remoteLogger.logMapAnalysis(displayname, "Tool - Area Report", this.areaName + "__" + sa.getReducedWkt(), "", "", this.pid, extras, "0");
        Events.echoEvent((String)"checkFutures", (Component)this, null);
    }

    public void detach() {
        this.getMapComposer().getLeftmenuSearchComposer().removeViewportEventListener("filteringResults");
        super.detach();
    }

    void addListener() {
        if (!this.addedListener) {
            this.addedListener = true;
            1 el = new /* Unavailable Anonymous Inner Class!! */;
            this.getMapComposer().getLeftmenuSearchComposer().addViewportEventListener("filteringResults", (EventListener)el);
        }
    }

    private Map<String, AreaReportItemDTO> setUpModelMap(boolean isWorldSelected) {
        LinkedHashMap<String, AreaReportItemDTO> values = new LinkedHashMap<String, AreaReportItemDTO>();
        String worldSuffix = isWorldSelected ? "*" : "";
        values.put("area", new AreaReportItemDTO("Area (sq km)"));
        values.put("species" + worldSuffix, new AreaReportItemDTO("Number of species"));
        values.put("spatialSpecies", new AreaReportItemDTO("Number of species - spatially valid only"));
        if (this.includeEndemic) {
            values.put("endemicSpecies", new AreaReportItemDTO("Number of endemic species"));
            values.put("spatialEndemicSpecies", new AreaReportItemDTO("Number of endemic species - spatially valid only"));
        }
        values.put("occurrences" + worldSuffix, new AreaReportItemDTO("Occurrences"));
        values.put("spatialOccurrences", new AreaReportItemDTO("Occurrences - spatially valid only"));
        values.put("expertDistributions", new AreaReportItemDTO("Expert distributions"));
        values.put("checklistArea", new AreaReportItemDTO("Checklist areas"));
        values.put("checklistSpecies", new AreaReportItemDTO("Checklist species"));
        values.put("journalmap", new AreaReportItemDTO("Journalmap documents"));
        values.put("gazetteer", new AreaReportItemDTO("Gazetteer points"));
        if (CommonData.getDisplayPointsOfInterest()) {
            values.put("poi", new AreaReportItemDTO("Points of interest"));
        }
        for (int i = 0; i < CommonData.getAreaReportFacets().length; ++i) {
            values.put("configuedFacets" + i, new AreaReportItemDTO(""));
        }
        return values;
    }

    void startQueries() {
        int i;
        boolean worldAreaSelected = "POLYGON((-179.999 -89.999,-179.999 89.999,179.999 84.999,179.999 -89.999,-179.999 -89.999))".equals(this.selectedArea.getFacets() == null ? this.selectedArea.getWkt() : null);
        this.reportModelMap = this.setUpModelMap(worldAreaSelected);
        this.areaReportListModel = new ChangableSimpleListModel(new ArrayList(this.reportModelMap.values()));
        this.facetsValues.setModel((ListModel)this.areaReportListModel);
        this.facetsValues.setRowRenderer((RowRenderer)new /* Unavailable Anonymous Inner Class!! */);
        this.divWorldNote.setVisible(worldAreaSelected);
        3 occurrenceCount = new /* Unavailable Anonymous Inner Class!! */;
        4 occurrenceCountKosher = new /* Unavailable Anonymous Inner Class!! */;
        5 speciesCount = new /* Unavailable Anonymous Inner Class!! */;
        6 speciesCountKosher = new /* Unavailable Anonymous Inner Class!! */;
        7 endemismCount = new /* Unavailable Anonymous Inner Class!! */;
        8 endemismCountKosher = new /* Unavailable Anonymous Inner Class!! */;
        9 speciesDistributions = new /* Unavailable Anonymous Inner Class!! */;
        10 calculatedArea = new /* Unavailable Anonymous Inner Class!! */;
        11 speciesChecklists = new /* Unavailable Anonymous Inner Class!! */;
        12 gazPointsC = new /* Unavailable Anonymous Inner Class!! */;
        13 journalmap = new /* Unavailable Anonymous Inner Class!! */;
        14 pointsOfInterestC = new /* Unavailable Anonymous Inner Class!! */;
        Callable[] areaFacets = new Callable[CommonData.getAreaReportFacets().length];
        for (i = 0; i < CommonData.getAreaReportFacets().length; ++i) {
            String facet = CommonData.getAreaReportFacets()[i];
            String s = String.valueOf(i);
            areaFacets[i] = new /* Unavailable Anonymous Inner Class!! */;
        }
        try {
            this.pool = Executors.newFixedThreadPool(50);
            this.futures = new HashMap();
            this.firedEvents = new ArrayList();
            this.futures.put("CalculatedArea", this.pool.submit(calculatedArea));
            this.futures.put("OccurrenceCount", this.pool.submit(occurrenceCount));
            this.futures.put("OccurrenceCountKosher", this.pool.submit(occurrenceCountKosher));
            for (i = 0; i < areaFacets.length; ++i) {
                this.futures.put("AreaFacetCounts" + i, this.pool.submit(areaFacets[i]));
            }
            this.futures.put("SpeciesCount", this.pool.submit(speciesCount));
            this.futures.put("SpeciesCountKosher", this.pool.submit(speciesCountKosher));
            this.futures.put("GazPoints", this.pool.submit(gazPointsC));
            this.futures.put("SpeciesChecklists", this.pool.submit(speciesChecklists));
            this.futures.put("SpeciesDistributions", this.pool.submit(speciesDistributions));
            this.futures.put("Journalmap", this.pool.submit(journalmap));
            if (CommonData.getDisplayPointsOfInterest()) {
                this.futures.put("PointsOfInterest", this.pool.submit(pointsOfInterestC));
            }
            if (this.includeEndemic) {
                this.futures.put("EndemicCount", this.pool.submit(endemismCount));
                this.futures.put("EndemicCountKosher", this.pool.submit(endemismCountKosher));
            }
            this.futuresStart = System.currentTimeMillis();
        }
        catch (Exception e) {
            LOGGER.error((Object)"error setting counts for futures", (Throwable)e);
        }
    }

    public void checkFutures() {
        try {
            boolean allComplete;
            LOGGER.debug((Object)"Check futures.....");
            int cancelled = 0;
            for (Map.Entry futureEntry : this.futures.entrySet()) {
                String eventToFire = "render" + (String)futureEntry.getKey();
                if (((Future)futureEntry.getValue()).isDone() && !this.firedEvents.contains(eventToFire)) {
                    this.firedEvents.add(eventToFire);
                    this.areaReportListModel.setModelChanged();
                }
                if (((Future)futureEntry.getValue()).isDone() || System.currentTimeMillis() - this.futuresStart <= 300000L) continue;
                ((Future)futureEntry.getValue()).cancel(true);
                for (AreaReportItemDTO model : this.areaReportListModel.getInnerList()) {
                    if (!model.isLoading()) continue;
                    model.setCount("Request timed out");
                }
                ++cancelled;
                this.areaReportListModel.setModelChanged();
            }
            LOGGER.debug((Object)("Fired events: " + this.firedEvents.size() + ", Futures: " + this.futures.size() + ", Cancelled: " + cancelled));
            boolean bl = allComplete = this.firedEvents.size() + cancelled == this.futures.size();
            if (!allComplete) {
                Thread.sleep(1000L);
                Events.echoEvent((String)"checkFutures", (Component)this, null);
            } else {
                LOGGER.debug((Object)"All futures completed.");
                this.pool.shutdown();
                this.futures = null;
            }
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"", (Throwable)e);
        }
    }

    Map<String, Integer> endemismCount(boolean worldSelected, AreaReportItemDTO model) {
        HashMap<String, Integer> countsData = new HashMap<String, Integer>();
        Query sq = QueryUtil.queryFromSelectedArea(null, (SelectedArea)this.selectedArea, (boolean)false, (boolean[])new boolean[]{true, true, false});
        int endemicCount = sq.getEndemicSpeciesCount();
        countsData.put("endemicSpeciesCount", endemicCount);
        model.setCount(String.format("%,d", endemicCount));
        model.setGeospatialKosher(false);
        if (endemicCount > 0) {
            model.setExtraInfo(new AreaReportItemDTO.ExtraInfoEnum[]{AreaReportItemDTO.ExtraInfoEnum.LIST, AreaReportItemDTO.ExtraInfoEnum.MAP_ALL});
            model.setListType(AreaReportItemDTO.ListType.SPECIES);
            model.setEndemic(true);
        }
        model.setEndemic(true);
        return countsData;
    }

    Map<String, Integer> endemismCountKosher(boolean worldSelected, AreaReportItemDTO model) {
        HashMap<String, Integer> countsData = new HashMap<String, Integer>();
        Query sq2 = QueryUtil.queryFromSelectedArea(null, (SelectedArea)this.selectedArea, (boolean)false, (boolean[])new boolean[]{true, false, false});
        int count = sq2.getEndemicSpeciesCount();
        countsData.put("endemicSpeciesCountKosher", count);
        model.setCount(String.format("%,d", count));
        if (count > 0) {
            model.setExtraInfo(new AreaReportItemDTO.ExtraInfoEnum[]{AreaReportItemDTO.ExtraInfoEnum.LIST, AreaReportItemDTO.ExtraInfoEnum.MAP_ALL});
            model.setListType(AreaReportItemDTO.ListType.SPECIES);
            model.setEndemic(true);
            model.setGeospatialKosher(true);
        }
        return countsData;
    }

    Map<String, Integer> speciesCount(boolean worldSelected, AreaReportItemDTO model) {
        HashMap<String, Integer> countsData = new HashMap<String, Integer>();
        try {
            Query sq = QueryUtil.queryFromSelectedArea(null, (SelectedArea)this.selectedArea, (boolean)false, null);
            int resultsCount = sq.getSpeciesCount();
            if (resultsCount == 0) {
                countsData.put("speciesCount", 0);
                model.setCount("0");
                return countsData;
            }
            countsData.put("speciesCount", resultsCount);
            model.setExtraInfo(new AreaReportItemDTO.ExtraInfoEnum[]{AreaReportItemDTO.ExtraInfoEnum.LIST});
            model.setListType(AreaReportItemDTO.ListType.SPECIES);
            model.setGeospatialKosher(false);
            model.setCount(String.format("%,d", resultsCount));
        }
        catch (Exception ex) {
            LOGGER.error((Object)"error getting speciescount", (Throwable)ex);
        }
        return countsData;
    }

    Map<String, Object> facetCounts(AreaReportItemDTO pmodel, String facet) {
        Locales.setThreadLocal(null);
        LinkedHashMap<String, Object> countsData = new LinkedHashMap<String, Object>();
        LOGGER.debug((Object)("Starting to get facet counts for : " + facet));
        AreaReportItemDTO dto = pmodel;
        int colonIdx = facet.indexOf(58);
        String query = colonIdx > 0 ? facet : facet + ":*";
        Query sq = QueryUtil.queryFromSelectedArea(null, (SelectedArea)this.selectedArea, (String)query, (boolean)false, null);
        int count = sq.getSpeciesCount();
        if (count == -1) {
            count = 0;
        }
        String label = Labels.getLabel((String)("facet." + facet), (String)facet);
        dto.setTitle(label);
        dto.setCount(String.format("%,d", count));
        if (facet.equals(CommonData.speciesListThreatened)) {
            dto.setTitle("Threatened Species");
        } else if (facet.equals(CommonData.speciesListInvasive)) {
            dto.setTitle("Invasive Species");
        } else if (facet.startsWith("species_list") && colonIdx > 0) {
            String dataResourceUid = facet.substring(colonIdx + 1);
            String title = (String)SpeciesListUtil.getSpeciesListMap().get(dataResourceUid);
            if (title != null) {
                dto.setTitle(title);
            }
            dto.addUrlDetails("Full List", CommonData.getSpeciesListServer() + "/speciesListItem/list/" + dataResourceUid);
        } else if (facet.startsWith("species_group")) {
            dto.setTitle(facet.substring(colonIdx + 1));
        }
        if (count > 0) {
            dto.addUrlDetails("View Records", CommonData.getBiocacheWebServer() + "/occurrences/search?q=" + sq.getQ() + "&qc=" + sq.getQc());
            dto.setExtraParams(query);
            dto.setExtraInfo(new AreaReportItemDTO.ExtraInfoEnum[]{AreaReportItemDTO.ExtraInfoEnum.LIST, AreaReportItemDTO.ExtraInfoEnum.MAP_ALL});
            dto.setListType(AreaReportItemDTO.ListType.SPECIES);
        }
        countsData.put(facet, dto);
        LOGGER.debug((Object)("Facet Counts ::: " + countsData));
        return countsData;
    }

    Map<String, Integer> speciesCountKosher(boolean worldSelected, AreaReportItemDTO model) {
        HashMap<String, Integer> countsData = new HashMap<String, Integer>();
        try {
            Query sq = QueryUtil.queryFromSelectedArea(null, (SelectedArea)this.selectedArea, (boolean)false, (boolean[])new boolean[]{true, false, false});
            int resultsCountKosher = sq.getSpeciesCount();
            if (resultsCountKosher == 0) {
                countsData.put("speciesCountKosher", 0);
                model.setCount("0");
                return countsData;
            }
            countsData.put("speciesCountKosher", resultsCountKosher);
            model.setExtraInfo(new AreaReportItemDTO.ExtraInfoEnum[]{AreaReportItemDTO.ExtraInfoEnum.LIST});
            model.setListType(AreaReportItemDTO.ListType.SPECIES);
            model.setGeospatialKosher(true);
            model.setCount(String.format("%,d", resultsCountKosher));
        }
        catch (Exception ex) {
            LOGGER.error((Object)"error getting speciesCountKosher", (Throwable)ex);
        }
        return countsData;
    }

    Map<String, Object> occurrenceCount(boolean worldSelected, AreaReportItemDTO model) {
        HashMap<String, Object> countsData = new HashMap<String, Object>();
        try {
            Query sq = QueryUtil.queryFromSelectedArea(null, (SelectedArea)this.selectedArea, (boolean)false, null);
            int resultsCountOccurrences = sq.getOccurrenceCount();
            if (resultsCountOccurrences == 0) {
                countsData.put("occurrencesCount", "0");
                model.setCount("0");
                return countsData;
            }
            model.addUrlDetails("View Records", CommonData.getBiocacheWebServer() + "/occurrences/search?q=" + sq.getQ() + "&qc=" + sq.getQc());
            countsData.put("occurrencesCount", resultsCountOccurrences);
            model.setCount(String.format("%,d", resultsCountOccurrences));
            if (resultsCountOccurrences > 0 && resultsCountOccurrences <= Integer.parseInt(CommonData.getSettings().getProperty("max_record_count_map"))) {
                model.setExtraInfo(new AreaReportItemDTO.ExtraInfoEnum[]{AreaReportItemDTO.ExtraInfoEnum.MAP_ALL, AreaReportItemDTO.ExtraInfoEnum.SAMPLE});
            }
            model.setGeospatialKosher(false);
        }
        catch (Exception ex) {
            LOGGER.error((Object)"error getting occurrences count", (Throwable)ex);
        }
        return countsData;
    }

    Map<String, Object> occurrenceCountKosher(boolean worldSelected, AreaReportItemDTO model) {
        HashMap<String, Object> countsData = new HashMap<String, Object>();
        try {
            Query sq = QueryUtil.queryFromSelectedArea(null, (SelectedArea)this.selectedArea, (boolean)false, (boolean[])new boolean[]{true, false, false});
            int resultsCountOccurrencesKosher = sq.getOccurrenceCount();
            if (resultsCountOccurrencesKosher == 0) {
                countsData.put("occurrencesCountKosher", 0);
                model.setCount("0");
                return countsData;
            }
            countsData.put("viewRecordsKosherUrl", CommonData.getBiocacheWebServer() + "/occurrences/search?q=" + sq.getQ() + "&qc=" + sq.getQc());
            model.addUrlDetails("View Records", CommonData.getBiocacheWebServer() + "/occurrences/search?q=" + sq.getQ() + "&qc=" + sq.getQc());
            model.setExtraInfo(new AreaReportItemDTO.ExtraInfoEnum[]{AreaReportItemDTO.ExtraInfoEnum.MAP_ALL, AreaReportItemDTO.ExtraInfoEnum.SAMPLE});
            model.setGeospatialKosher(true);
            if (resultsCountOccurrencesKosher > 0 && resultsCountOccurrencesKosher <= Integer.parseInt(CommonData.getSettings().getProperty("max_record_count_map"))) {
                countsData.put("occurrencesCountKosher", resultsCountOccurrencesKosher);
            }
            model.setCount(String.format("%,d", resultsCountOccurrencesKosher));
        }
        catch (Exception ex) {
            LOGGER.error((Object)"error getting occurrences count", (Throwable)ex);
        }
        return countsData;
    }

    public void onMapSpecies(Event event) {
        try {
            SelectedArea sa = !"Current extent".equalsIgnoreCase(this.areaName) ? this.selectedArea : new SelectedArea(null, this.getMapComposer().getViewArea());
            BiocacheQuery baseQuery = null;
            if (event != null && event.getData() != null) {
                baseQuery = new BiocacheQuery(null, null, (String)event.getData(), null, false, null);
            }
            Query query = QueryUtil.queryFromSelectedArea(baseQuery, (SelectedArea)sa, (boolean)true, null);
            String activeAreaLayerName = this.getMapComposer().getNextActiveAreaLayerName(this.areaDisplayName);
            this.getMapComposer().mapSpecies(query, activeAreaLayerName, "species", -1, 21, null, -1, 3, 0.6f, Util.nextColour(), false);
        }
        catch (Exception e) {
            LOGGER.error((Object)"error mapping species in area", (Throwable)e);
        }
    }

    public void onMapSpeciesKosher(Event event) {
        try {
            SelectedArea sa = !"Current extent".equalsIgnoreCase(this.areaName) ? this.selectedArea : new SelectedArea(null, this.getMapComposer().getViewArea());
            BiocacheQuery baseQuery = null;
            if (event != null && event.getData() != null) {
                baseQuery = new BiocacheQuery(null, null, (String)event.getData(), null, false, null);
            }
            Query query = QueryUtil.queryFromSelectedArea((Query)baseQuery, (SelectedArea)sa, (boolean)true, (boolean[])new boolean[]{true, false, false});
            String activeAreaLayerName = this.getMapComposer().getNextActiveAreaLayerName(this.areaDisplayName + " geospatial kosher");
            this.getMapComposer().mapSpecies(query, activeAreaLayerName, "species", -1, 21, null, -1, 3, 0.6f, Util.nextColour(), false);
        }
        catch (Exception e) {
            LOGGER.error((Object)"error mapping kosher species in area", (Throwable)e);
        }
    }

    public void onMapPointsOfInterest(Event event) {
        try {
            String activeAreaLayerName = "Points of interest in " + this.areaDisplayName;
            StringBuilder sb = new StringBuilder();
            sb.append("MULTIPOINT(");
            if (this.pointsOfInterest == null) {
                String wkt = this.selectedArea.getReducedWkt();
                if (wkt.contains("ENVELOPE") && this.selectedArea.getMapLayer() != null) {
                    List bbox = this.selectedArea.getMapLayer().getMapLayerMetadata().getBbox();
                    double long1 = (Double)bbox.get(0);
                    double lat1 = (Double)bbox.get(1);
                    double long2 = (Double)bbox.get(2);
                    double lat2 = (Double)bbox.get(3);
                    wkt = "POLYGON((" + long1 + " " + lat1 + "," + long1 + " " + lat2 + "," + long2 + " " + lat2 + "," + long2 + " " + lat1 + "," + long1 + " " + lat1 + "))";
                }
                this.pointsOfInterest = AreaReportController.getPointsOfInterest((String)wkt);
            }
            for (int i = 0; i < this.pointsOfInterest.size(); ++i) {
                JSONObject jsonObjPoi = (JSONObject)this.pointsOfInterest.get(i);
                double latitude = Double.parseDouble(jsonObjPoi.get((Object)"latitude").toString());
                double longitude = Double.parseDouble(jsonObjPoi.get((Object)"longitude").toString());
                sb.append(longitude);
                sb.append(" ");
                sb.append(latitude);
                if (i >= this.pointsOfInterest.size() - 1) continue;
                sb.append(",");
            }
            sb.append(")");
            this.getMapComposer().mapPointsOfInterest(sb.toString(), activeAreaLayerName, activeAreaLayerName);
        }
        catch (Exception e) {
            LOGGER.error((Object)"error mapping points of interest", (Throwable)e);
        }
    }

    public Map<String, Integer> intersectWithSpeciesDistributions(AreaReportItemDTO model) {
        HashMap<String, Integer> speciesDistributions = new HashMap<String, Integer>();
        try {
            String[] lines;
            String wkt = this.selectedArea.getReducedWkt();
            if (wkt.contains("ENVELOPE") && this.selectedArea.getMapLayer() != null) {
                List bbox = this.selectedArea.getMapLayer().getMapLayerMetadata().getBbox();
                double long1 = (Double)bbox.get(0);
                double lat1 = (Double)bbox.get(1);
                double long2 = (Double)bbox.get(2);
                double lat2 = (Double)bbox.get(3);
                wkt = "POLYGON((" + long1 + " " + lat1 + "," + long1 + " " + lat2 + "," + long2 + " " + lat2 + "," + long2 + " " + lat1 + "," + long1 + " " + lat1 + "))";
            }
            if ((lines = Util.getDistributionsOrChecklists((String)"distributions", (String)wkt, null, null)).length <= 1) {
                speciesDistributions.put("intersectWithSpeciesDistributions", 0);
                model.setCount("0");
                this.speciesDistributionText = null;
            } else {
                speciesDistributions.put("intersectWithSpeciesDistributions", lines.length - 1);
                model.setCount(Integer.toString(lines.length - 1));
                model.setExtraInfo(new AreaReportItemDTO.ExtraInfoEnum[]{AreaReportItemDTO.ExtraInfoEnum.LIST});
                model.setListType(AreaReportItemDTO.ListType.DISTRIBUTION);
                this.speciesDistributionText = lines;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"error getting intersected distribution areas", (Throwable)e);
        }
        return speciesDistributions;
    }

    public Map<String, String> intersectWithSpeciesChecklists(AreaReportItemDTO areaModel, AreaReportItemDTO spModel) {
        HashMap<String, String> checklistsCounts = new HashMap<String, String>();
        try {
            String[] lines;
            String wkt = this.selectedArea.getReducedWkt();
            if (wkt.contains("ENVELOPE") && this.selectedArea.getMapLayer() != null) {
                List bbox = this.selectedArea.getMapLayer().getMapLayerMetadata().getBbox();
                double long1 = (Double)bbox.get(0);
                double lat1 = (Double)bbox.get(1);
                double long2 = (Double)bbox.get(2);
                double lat2 = (Double)bbox.get(3);
                wkt = "POLYGON((" + long1 + " " + lat1 + "," + long1 + " " + lat2 + "," + long2 + " " + lat2 + "," + long2 + " " + lat1 + "," + long1 + " " + lat1 + "))";
            }
            if ((lines = Util.getDistributionsOrChecklists((String)"checklists", (String)wkt, null, null)).length <= 1) {
                spModel.setCount("0");
                checklistsCounts.put("intersectWithSpeciesChecklists", "0");
                areaModel.setCount("0");
                checklistsCounts.put("intersectWithAreaChecklists", "0");
                this.speciesChecklistText = null;
            } else {
                checklistsCounts.put("intersectWithSpeciesChecklists", String.format("%,d", lines.length - 1));
                spModel.setCount(String.format("%,d", lines.length - 1));
                spModel.setExtraInfo(new AreaReportItemDTO.ExtraInfoEnum[]{AreaReportItemDTO.ExtraInfoEnum.LIST});
                spModel.setListType(AreaReportItemDTO.ListType.SPECIES_CHECKLIST);
                this.areaChecklistText = Util.getAreaChecklists((String[])lines);
                checklistsCounts.put("intersectWithAreaChecklists", String.format("%,d", this.areaChecklistText.length - 1));
                areaModel.setCount(String.format("%,d", this.areaChecklistText.length - 1));
                areaModel.setExtraInfo(new AreaReportItemDTO.ExtraInfoEnum[]{AreaReportItemDTO.ExtraInfoEnum.LIST});
                areaModel.setListType(AreaReportItemDTO.ListType.AREA_CHECKLIST);
                this.speciesChecklistText = lines;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"error getting intersected species checklists", (Throwable)e);
        }
        return checklistsCounts;
    }

    public Map<String, String> countGazPoints(AreaReportItemDTO model) {
        HashMap<String, String> gazPointsCounts = new HashMap<String, String>();
        try {
            JSONArray ja;
            String wkt = this.selectedArea.getReducedWkt();
            if (wkt.contains("ENVELOPE") && this.selectedArea.getMapLayer() != null) {
                List bbox = this.selectedArea.getMapLayer().getMapLayerMetadata().getBbox();
                double long1 = (Double)bbox.get(0);
                double lat1 = (Double)bbox.get(1);
                double long2 = (Double)bbox.get(2);
                double lat2 = (Double)bbox.get(3);
                wkt = "POLYGON((" + long1 + " " + lat1 + "," + long1 + " " + lat2 + "," + long2 + " " + lat2 + "," + long2 + " " + lat1 + "," + long1 + " " + lat1 + "))";
            }
            if ((ja = AreaReportController.getGazPoints((String)wkt)) == null || ja.isEmpty()) {
                gazPointsCounts.put("countGazPoints", "0");
                model.setCount("0");
                this.speciesChecklistText = null;
            } else {
                gazPointsCounts.put("countGazPoints", String.format("%,d", ja.size()));
                model.setCount(String.format("%,d", ja.size()));
                model.setExtraInfo(new AreaReportItemDTO.ExtraInfoEnum[]{AreaReportItemDTO.ExtraInfoEnum.MAP_ALL});
                this.gazPoints = ja;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"error with area gaz point count", (Throwable)e);
        }
        return gazPointsCounts;
    }

    public Map<String, String> countPointsOfInterest(AreaReportItemDTO model) {
        HashMap<String, String> poiCounts = new HashMap<String, String>();
        try {
            int count;
            String wkt = this.selectedArea.getReducedWkt();
            if (wkt.contains("ENVELOPE") && this.selectedArea.getMapLayer() != null) {
                List bbox = this.selectedArea.getMapLayer().getMapLayerMetadata().getBbox();
                double long1 = (Double)bbox.get(0);
                double lat1 = (Double)bbox.get(1);
                double long2 = (Double)bbox.get(2);
                double lat2 = (Double)bbox.get(3);
                wkt = "POLYGON((" + long1 + " " + lat1 + "," + long1 + " " + lat2 + "," + long2 + " " + lat2 + "," + long2 + " " + lat1 + "," + long1 + " " + lat1 + "))";
            }
            if ((count = AreaReportController.getPointsOfInterestCount((String)wkt)) <= 0) {
                poiCounts.put("countPointsOfInterest", "0");
                model.setCount("0");
                this.speciesChecklistText = null;
            } else {
                poiCounts.put("countPointsOfInterest", String.format("%,d", count));
                model.setCount(String.format("%,d", count));
                model.setExtraInfo(new AreaReportItemDTO.ExtraInfoEnum[]{AreaReportItemDTO.ExtraInfoEnum.MAP_ALL});
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"area report error counting points of interest", (Throwable)e);
        }
        return poiCounts;
    }

    Map<String, String> journalmap(AreaReportItemDTO model) {
        HashMap<String, String> countData = new HashMap<String, String>();
        try {
            String area = this.selectedArea.getWkt();
            double lat1 = 0.0;
            double lat2 = 0.0;
            double long1 = 0.0;
            double long2 = 0.0;
            if (area.contains("ENVELOPE") && this.selectedArea.getMapLayer() != null) {
                List bbox = this.selectedArea.getMapLayer().getMapLayerMetadata().getBbox();
                long1 = (Double)bbox.get(0);
                lat1 = (Double)bbox.get(1);
                long2 = (Double)bbox.get(2);
                lat2 = (Double)bbox.get(3);
                area = "POLYGON((" + long1 + " " + lat1 + "," + long1 + " " + lat2 + "," + long2 + " " + lat2 + "," + long2 + " " + lat1 + "," + long1 + " " + lat1 + "))";
            }
            List list = CommonData.filterJournalMapArticles((String)area);
            String journalmapUrl = CommonData.getSettings().getProperty("journalmap.url", null);
            StringBuilder sb = new StringBuilder();
            sb.append("<ol>");
            for (int i = 0; i < list.size(); ++i) {
                JSONObject o = (JSONObject)list.get(i);
                sb.append("<li>");
                sb.append("<a href=\"").append(journalmapUrl + "articles/" + o.get((Object)"id").toString()).append("\" ");
                sb.append("target=\"_blank\">");
                sb.append(o.get((Object)"title"));
                sb.append("</li>");
            }
            sb.append("</ol>");
            if (!list.isEmpty()) {
                this.journalmapHtml = sb.toString();
            }
            countData.put("journalmap", String.valueOf(list.size()));
            model.setCount(Integer.toString(list.size()));
            if (!list.isEmpty()) {
                model.setExtraInfo(new AreaReportItemDTO.ExtraInfoEnum[]{AreaReportItemDTO.ExtraInfoEnum.LIST});
                model.setListType(AreaReportItemDTO.ListType.JOURNAL_MAP);
                model.addUrlDetails("JournalMap", "https://www.journalmap.org/");
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"unable to get area info from journalmap", (Throwable)e);
            countData.put("journalmap", "unavailable");
            model.setCount("Unavailable");
        }
        return countData;
    }

    public void listDistributions(AreaReportItemDTO model) {
        int c = 0;
        try {
            c = Integer.parseInt(model.getCount().replace(",", ""));
        }
        catch (Exception e) {
            LOGGER.error((Object)"failed to list distributions", (Throwable)e);
        }
        if (c > 0 && this.speciesDistributionText != null) {
            if (this.getMapComposer().hasFellow("distributionresults")) {
                this.getMapComposer().getFellowIfAny("distributionresults").detach();
            }
            DistributionsController dc = (DistributionsController)Executions.createComponents((String)"WEB-INF/zul/results/AnalysisDistributionResults.zul", (Component)this, null);
            try {
                dc.setParent((Component)this);
                dc.doModal();
                dc.init(this.speciesDistributionText, "Expert Distributions", model.getCount());
            }
            catch (Exception e) {
                LOGGER.error((Object)"error opening expert distributions window", (Throwable)e);
            }
        }
    }

    public void listSpeciesChecklists(AreaReportItemDTO model) {
        int c = 0;
        try {
            c = Integer.parseInt(model.getCount().replace(",", ""));
        }
        catch (Exception e) {
            LOGGER.error((Object)"failed to get checklists", (Throwable)e);
        }
        if (c > 0 && this.speciesChecklistText != null) {
            DistributionsController dc = (DistributionsController)Executions.createComponents((String)"WEB-INF/zul/results/AnalysisDistributionResults.zul", (Component)this, null);
            try {
                dc.setParent((Component)this);
                dc.doModal();
                dc.init(this.speciesChecklistText, "Species Checklists", model.getCount());
            }
            catch (Exception e) {
                LOGGER.error((Object)"error opening species checklists window", (Throwable)e);
            }
        }
    }

    public void listAreaChecklists(AreaReportItemDTO model) {
        int c = 0;
        try {
            c = Integer.parseInt(model.getCount().replace(",", ""));
        }
        catch (Exception e) {
            LOGGER.error((Object)"failed to get checklists", (Throwable)e);
        }
        if (c > 0 && this.areaChecklistText != null) {
            DistributionsController dc = (DistributionsController)Executions.createComponents((String)"WEB-INF/zul/results/AnalysisDistributionResults.zul", (Component)this, null);
            try {
                dc.setParent((Component)this);
                dc.doModal();
                dc.init(this.areaChecklistText, "Checklist areas", model.getCount());
            }
            catch (Exception e) {
                LOGGER.error((Object)"error opening area checklists window", (Throwable)e);
            }
        }
    }

    public void onClick$downloadexpert(Event event) {
        this.onClick$sdDownload(event);
    }

    public void onClick$sdDownload(Event event) {
        String spid = this.pid;
        if (spid == null || "none".equals(spid)) {
            spid = String.valueOf(System.currentTimeMillis());
        }
        SimpleDateFormat date = new SimpleDateFormat("yyyyMMdd");
        String sdate = date.format(new Date());
        StringBuilder sb = new StringBuilder();
        for (String s : this.speciesDistributionText) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(s);
        }
        Filedownload.save((String)sb.toString(), (String)"text/plain", (String)("Species_distributions_" + sdate + "_" + spid + ".csv"));
    }

    public void onClick$downloadchecklist(Event event) {
        this.onClick$clDownload(event);
    }

    public void onClick$clDownload(Event event) {
        String spid = this.pid;
        if (spid == null || "none".equals(spid)) {
            spid = String.valueOf(System.currentTimeMillis());
        }
        SimpleDateFormat date = new SimpleDateFormat("yyyyMMdd");
        String sdate = date.format(new Date());
        StringBuilder sb = new StringBuilder();
        for (String s : this.speciesChecklistText) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(s);
        }
        Filedownload.save((String)sb.toString(), (String)"text/plain", (String)("Species_checklists_" + sdate + "_" + spid + ".csv"));
    }

    public void onClick$aclDownload(Event event) {
        String spid = this.pid;
        if (spid == null || "none".equals(spid)) {
            spid = String.valueOf(System.currentTimeMillis());
        }
        SimpleDateFormat date = new SimpleDateFormat("yyyyMMdd");
        String sdate = date.format(new Date());
        StringBuilder sb = new StringBuilder();
        for (String s : this.areaChecklistText) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(s);
        }
        Filedownload.save((String)sb.toString(), (String)"text/plain", (String)("Area_checklists_" + sdate + "_" + spid + ".csv"));
    }

    protected Map<String, String> calculateArea(AreaReportItemDTO model) {
        HashMap<String, String> areaCalc = new HashMap<String, String>();
        if (this.areaSqKm != null) {
            areaCalc.put("area", this.areaSqKm);
            model.setCount(this.areaSqKm);
            this.speciesDistributionText = null;
            model.addUrlDetails("Info", "note-area-sq-km");
            return areaCalc;
        }
        try {
            double totalarea = Util.calculateArea((String)this.selectedArea.getWkt());
            DecimalFormat df = new DecimalFormat("###,###.##");
            areaCalc.put("area", df.format(totalarea / 1000.0 / 1000.0));
            model.setCount(df.format(totalarea / 1000.0 / 1000.0));
            model.addUrlDetails("Info", "note-area-sq-km");
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error in calculateArea", (Throwable)e);
            areaCalc.put("area", "");
            model.setCount("ERROR...");
        }
        return areaCalc;
    }

    public void onClick$btnCancel(Event event) {
        this.detach();
    }

    public void listJournalmap() {
        if (this.journalmapHtml != null) {
            Event ev = new Event("onClick", (Component)this, (Object)("Journalmap Documents\n" + this.journalmapHtml));
            this.getMapComposer().openHTML(ev);
        }
    }

    public void mapGazetteer() {
        try {
            if (this.gazPoints == null || this.gazPoints.isEmpty()) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            TreeSet columns = new TreeSet();
            for (int i = 0; i < this.gazPoints.size(); ++i) {
                columns.addAll(((JSONObject)this.gazPoints.get(i)).keySet());
            }
            sb.append("longitude,latitude");
            for (String s : columns) {
                if ("longitude".equals(s) || "latitude".equals(s)) continue;
                sb.append(",").append(s);
            }
            for (int i = 0; i < this.gazPoints.size(); ++i) {
                sb.append("\n");
                if (((JSONObject)this.gazPoints.get(i)).containsKey((Object)"geometry")) {
                    String geometry = ((JSONObject)this.gazPoints.get(i)).get((Object)"geometry").toString();
                    geometry = geometry.replace("POINT(", "").replace(")", "").replace(" ", ",");
                    sb.append(geometry);
                } else {
                    sb.append(",");
                }
                for (String s : columns) {
                    if ("longitude".equals(s) || "latitude".equals(s)) continue;
                    String ss = ((JSONObject)this.gazPoints.get(i)).containsKey((Object)s) ? ((JSONObject)this.gazPoints.get(i)).get((Object)s).toString() : "";
                    sb.append(",\"").append(ss.replace("\"", "\"\"").replace("\\", "\\\\")).append("\"");
                }
            }
            this.getMapComposer().setFeaturesCSV(sb.toString());
            this.getMapComposer().getOpenLayersJavascript().execute("mapFrame.mapPoints('" + StringEscapeUtils.escapeJavaScript((String)this.gazPoints.toString()) + "');");
        }
        catch (Exception e) {
            LOGGER.error((Object)"error mapping gaz points from area report", (Throwable)e);
        }
    }

    public void onClick$btnDownload(Event event) {
        String spid = this.pid;
        if (spid == null || "none".equals(spid)) {
            spid = String.valueOf(System.currentTimeMillis());
        }
        SimpleDateFormat date = new SimpleDateFormat("yyyyMMdd");
        String sdate = date.format(new Date());
        StringBuilder sb = new StringBuilder();
        sb.append("Area: " + this.areaDisplayName);
        for (Map.Entry i : this.reportModelMap.entrySet()) {
            sb.append("\n\"").append(((AreaReportItemDTO)i.getValue()).getTitle()).append("\",\"").append(((AreaReportItemDTO)i.getValue()).getCount()).append("\"");
        }
        Filedownload.save((String)sb.toString(), (String)"text/plain", (String)("Area_report_" + sdate + "_" + spid + ".csv"));
    }

    static /* synthetic */ SelectedArea access$002(AreaReportController x0, SelectedArea x1) {
        x0.selectedArea = x1;
        return x0.selectedArea;
    }

    static /* synthetic */ String access$100(AreaReportController x0) {
        return x0.areaName;
    }

    static /* synthetic */ Logger access$200() {
        return LOGGER;
    }

    static /* synthetic */ Map access$300(AreaReportController x0) {
        return x0.reportModelMap;
    }
}

