/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.quicklinks;

import au.org.ala.spatial.dto.ScatterplotDataDTO;
import au.org.ala.spatial.util.Query;
import au.org.emii.portal.composer.MapComposer;
import au.org.emii.portal.menu.MapLayer;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;

public class MetadataEvent
implements EventListener {
    private String layerName;

    public MetadataEvent(String layerName) {
        this.layerName = layerName;
    }

    public void onEvent(Event event) throws Exception {
        MapComposer mc = (MapComposer)event.getPage().getFellow("mapPortalPage");
        MapLayer mapLayer = mc.getMapLayer(this.layerName);
        if (mapLayer != null) {
            if (mapLayer.getSpeciesQuery() != null) {
                Query q = mapLayer.getSpeciesQuery();
                Events.echoEvent((String)"openHTML", (Component)mc, (String)q.getMetadataHtml());
            } else if (mapLayer.getMapLayerMetadata().getMoreInfo() != null && mapLayer.getMapLayerMetadata().getMoreInfo().startsWith("http://")) {
                String infourl = mapLayer.getMapLayerMetadata().getMoreInfo().replace("__", ".");
                if (mapLayer.getSubType() == 17) {
                    ScatterplotDataDTO data = mapLayer.getScatterplotDataDTO();
                    infourl = infourl + "?dparam=X-Layer:" + data.getLayer1Name();
                    infourl = infourl + "&dparam=Y-Layer:" + data.getLayer2Name();
                }
                Events.echoEvent((String)"openUrl", (Component)mc, (String)infourl);
            } else if (mapLayer.getMapLayerMetadata().getMoreInfo() != null && mapLayer.getMapLayerMetadata().getMoreInfo().length() > 0) {
                Events.echoEvent((String)"openHTML", (Component)mc, (String)mapLayer.getMapLayerMetadata().getMoreInfo());
            } else {
                mc.showMessage("Metadata currently unavailable");
            }
        }
    }
}

