/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.quicklinks;

import au.org.ala.spatial.composer.quicklinks.Action;
import au.org.ala.spatial.composer.quicklinks.AddToMapEvent;
import au.org.ala.spatial.composer.quicklinks.AreaReportEvent;
import au.org.ala.spatial.composer.quicklinks.ClassificationEvent;
import au.org.ala.spatial.composer.quicklinks.ExportAreaEvent;
import au.org.ala.spatial.composer.quicklinks.GDMEvent;
import au.org.ala.spatial.composer.quicklinks.MetadataEvent;
import au.org.ala.spatial.composer.quicklinks.OpenFacetsEvent;
import au.org.ala.spatial.composer.quicklinks.PredictionEvent;
import au.org.ala.spatial.composer.quicklinks.SamplingEvent;
import au.org.ala.spatial.composer.quicklinks.ScatterplotEvent;
import au.org.ala.spatial.composer.quicklinks.SitesBySpeciesEvent;
import au.org.ala.spatial.composer.quicklinks.SpeciesListEvent;
import au.org.emii.portal.composer.UtilityComposer;
import au.org.emii.portal.menu.MapLayer;
import java.util.ArrayList;
import java.util.List;
import org.zkoss.zhtml.Li;
import org.zkoss.zhtml.Ul;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.A;
import org.zkoss.zul.Vbox;

public class ContextualMenu
extends UtilityComposer {
    private Vbox contents;

    public void afterCompose() {
        super.afterCompose();
        this.getMapComposer().setContextualMenuRefreshListener((EventListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void refresh() {
        for (int i = this.contents.getChildren().size() - 1; i >= 0; --i) {
            ((Component)this.contents.getChildren().get(i)).detach();
        }
        List actions = this.getActions();
        Ul ul = new Ul();
        ul.setStyle("margin:0px");
        ul.setParent((Component)this.contents);
        for (int i = 0; i < actions.size(); ++i) {
            Li li = new Li();
            li.setParent((Component)ul);
            A a = new A(((Action)actions.get((int)i)).label);
            a.addEventListener("onClick", ((Action)actions.get((int)i)).eventListener);
            a.setParent((Component)li);
        }
    }

    List<Action> getActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        List layers = this.getVisibleLayers();
        MapLayer speciesLayer = null;
        MapLayer polygonLayer = null;
        MapLayer gridLayer = null;
        MapLayer firstLayer = null;
        for (int i = 0; i < layers.size(); ++i) {
            if (((MapLayer)layers.get(i)).getSpeciesQuery() != null && ((MapLayer)layers.get(i)).getSubType() != 17) {
                if (speciesLayer == null) {
                    speciesLayer = (MapLayer)layers.get(i);
                }
                if (firstLayer != null) continue;
                firstLayer = (MapLayer)layers.get(i);
                continue;
            }
            if (((MapLayer)layers.get(i)).isPolygonLayer() && ((MapLayer)layers.get(i)).getSubType() != 14) {
                if (polygonLayer == null) {
                    polygonLayer = (MapLayer)layers.get(i);
                }
                if (firstLayer != null) continue;
                firstLayer = (MapLayer)layers.get(i);
                continue;
            }
            if (((MapLayer)layers.get(i)).isGridLayer() && ((MapLayer)layers.get(i)).getSubType() != 15 && ((MapLayer)layers.get(i)).getSubType() != 16 && ((MapLayer)layers.get(i)).getSubType() != 14) {
                if (gridLayer == null) {
                    gridLayer = (MapLayer)layers.get(i);
                }
                if (firstLayer != null) continue;
                firstLayer = (MapLayer)layers.get(i);
                continue;
            }
            if (((MapLayer)layers.get(i)).getSubType() == 17 || firstLayer != null) continue;
            firstLayer = (MapLayer)layers.get(i);
        }
        if (polygonLayer != null) {
            actions.add(new Action("View area report for \"" + polygonLayer.getDisplayName() + "\"", (EventListener)new AreaReportEvent(polygonLayer.getName())));
        }
        if (firstLayer != null) {
            actions.add(new Action("View metadata for \"" + firstLayer.getDisplayName() + "\"", (EventListener)new MetadataEvent(firstLayer.getName())));
        }
        if (polygonLayer != null) {
            actions.add(new Action("Download species list for \"" + polygonLayer.getDisplayName() + "\"", (EventListener)new SpeciesListEvent(polygonLayer.getName())));
        }
        if (speciesLayer != null) {
            actions.add(new Action("Download all records for \"" + speciesLayer.getDisplayName() + "\"" + this.formatLayerName(polygonLayer), (EventListener)new SamplingEvent(speciesLayer.getName(), polygonLayer != null ? polygonLayer.getName() : null, null)));
        } else if (polygonLayer != null) {
            actions.add(new Action("Download all records " + " for \"" + polygonLayer.getDisplayName() + "\"", (EventListener)new SamplingEvent(null, polygonLayer.getName(), null)));
        }
        if (polygonLayer != null) {
            actions.add(new Action("Generate classification for \"" + polygonLayer.getDisplayName() + "\"", (EventListener)new ClassificationEvent(polygonLayer.getName(), null)));
        }
        if (speciesLayer != null) {
            actions.add(new Action("Produce scatterplot for \"" + speciesLayer.getDisplayName() + "\"" + this.formatLayerName(polygonLayer), (EventListener)new ScatterplotEvent(speciesLayer.getName(), polygonLayer != null ? polygonLayer.getName() : null, null)));
        }
        if (speciesLayer != null) {
            actions.add(new Action("Generate prediction for \"" + speciesLayer.getDisplayName() + "\"" + this.formatLayerName(polygonLayer), (EventListener)new PredictionEvent(speciesLayer.getName(), polygonLayer != null ? polygonLayer.getName() : null, null)));
        }
        if (speciesLayer != null) {
            actions.add(new Action("Produce points to grid for \"" + speciesLayer.getDisplayName() + "\"" + this.formatLayerName(polygonLayer), (EventListener)new SitesBySpeciesEvent(speciesLayer.getName(), polygonLayer != null ? polygonLayer.getName() : null, null)));
        }
        if (speciesLayer != null) {
            actions.add(new Action("Produce GDM using species \"" + speciesLayer.getDisplayName() + "\"" + this.formatLayerName(polygonLayer), (EventListener)new GDMEvent(speciesLayer.getName(), polygonLayer != null ? polygonLayer.getName() : null, null)));
        }
        if (polygonLayer != null) {
            actions.add(new Action("Export area \"" + polygonLayer.getDisplayName() + "\"", (EventListener)new ExportAreaEvent(polygonLayer.getName())));
        }
        if (speciesLayer != null && speciesLayer == layers.get(0)) {
            actions.add(new Action("Display facet of \"" + speciesLayer.getDisplayName() + "\"", (EventListener)new OpenFacetsEvent(speciesLayer.getName())));
        }
        if (actions.isEmpty()) {
            actions.add(new Action("Map species occurrences", (EventListener)new AddToMapEvent("species")));
            actions.add(new Action("Map area", (EventListener)new AddToMapEvent("area")));
            actions.add(new Action("Map layer", (EventListener)new AddToMapEvent("layer")));
            actions.add(new Action("Map facet", (EventListener)new AddToMapEvent("facet")));
        }
        return actions;
    }

    private String formatLayerName(MapLayer polygonLayer) {
        return polygonLayer != null ? " in \"" + polygonLayer.getDisplayName() + "\"" : "";
    }

    List<MapLayer> getVisibleLayers() {
        ArrayList<MapLayer> list = new ArrayList<MapLayer>();
        List allLayers = this.getPortalSession().getActiveLayers();
        for (int i = 0; i < allLayers.size(); ++i) {
            if (!((MapLayer)allLayers.get(i)).isDisplayed()) continue;
            list.add((MapLayer)allLayers.get(i));
        }
        return list;
    }
}

