/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.progress;

import au.org.ala.spatial.logger.RemoteLogger;
import au.org.ala.spatial.util.CommonData;
import au.org.emii.portal.composer.UtilityComposer;
import java.net.SocketTimeoutException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.Label;
import org.zkoss.zul.Progressmeter;
import org.zkoss.zul.Textbox;
import org.zkoss.zul.Timer;
import org.zkoss.zul.Window;

public class SitesBySpeciesProgressController
extends UtilityComposer {
    private static final Logger LOGGER = Logger.getLogger(SitesBySpeciesProgressController.class);
    private String pid = null;
    private Window parent = null;
    private RemoteLogger remoteLogger;
    private Label jobstatus;
    private Progressmeter jobprogress;
    private Timer timer;
    private Textbox tbPid;

    public void afterCompose() {
        super.afterCompose();
        this.timer.stop();
    }

    public void start(String pid) {
        this.pid = pid;
        this.tbPid.setValue(pid);
        this.timer.start();
        this.onTimer$timer(null);
    }

    public void onTimer$timer(Event e) {
        String s;
        String status;
        if (this.parent == null) {
            this.parent = (Window)this.getParent();
        }
        if ((status = this.get("status")).length() > 0) {
            this.jobstatus.setValue(status);
        }
        if ("job does not exist".equals(s = this.get("state"))) {
            this.timer.stop();
            this.getMapComposer().showMessage("Points to grid request does not exist", "");
            this.detach();
            return;
        }
        LOGGER.debug((Object)("**************** STATE: " + s));
        this.remoteLogger.logMapAnalysisUpdateStatus(this.pid, s);
        String p = this.get("progress");
        try {
            double d = Double.parseDouble(p);
            this.jobprogress.setValue((int)(d * 100.0));
        }
        catch (Exception ex) {
            LOGGER.error((Object)("failed to parse progress %: " + p));
        }
        if ("SUCCESSFUL".equals(s)) {
            this.timer.stop();
            Events.echoEvent((String)"loadMap", (Component)this.parent, null);
            this.detach();
        } else if (s.startsWith("FAILED")) {
            this.timer.stop();
            String errorInfo = this.get("message");
            errorInfo = !"job does not exist".equals(errorInfo) ? " with the following message: \n\n" + errorInfo : "";
            this.getMapComposer().showMessage("Points to grid failed" + errorInfo);
            this.detach();
            this.parent.detach();
        } else if ("CANCELLED".equals(s)) {
            this.timer.stop();
            this.getMapComposer().showMessage("Points to grid cancelled by user");
            this.detach();
        }
    }

    String get(String type) {
        try {
            HttpClient client = new HttpClient();
            GetMethod get = new GetMethod(CommonData.getSatServer() + "/ws/jobs/" + type + "?pid=" + this.pid);
            get.addRequestHeader("Accept", "text/plain");
            client.getHttpConnectionManager().getParams().setSoTimeout(this.timer.getDelay());
            client.executeMethod((HttpMethod)get);
            return get.getResponseBodyAsString();
        }
        catch (SocketTimeoutException e) {
            LOGGER.debug((Object)"progress timeout exception, will be trying again.");
        }
        catch (Exception e) {
            LOGGER.error((Object)("error getting updated job info pid=" + this.pid), (Throwable)e);
        }
        return "";
    }

    public void onClick$btnCancel(Event e) {
        this.get("cancel");
        this.detach();
    }

    public void onClick$btnHide(Event e) {
        this.detach();
    }
}

