/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.progress;

import au.org.ala.spatial.logger.RemoteLogger;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.Util;
import au.org.emii.portal.composer.UtilityComposer;
import java.net.SocketTimeoutException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.Button;
import org.zkoss.zul.Caption;
import org.zkoss.zul.Label;
import org.zkoss.zul.Progressmeter;
import org.zkoss.zul.Textbox;
import org.zkoss.zul.Timer;
import org.zkoss.zul.Window;

public class ProgressController
extends UtilityComposer {
    private static final Logger LOGGER = Logger.getLogger(ProgressController.class);
    private String pid = null;
    private Window parent = null;
    private String name = "";
    private RemoteLogger remoteLogger;
    private Label jobstatus;
    private Progressmeter jobprogress;
    private Timer timer;
    private Textbox tbPid;
    private Textbox txtLog;
    private String log = "";
    private Button btnHide;

    public void afterCompose() {
        super.afterCompose();
        this.timer.stop();
    }

    public void start(String pid, String name) {
        this.start(pid, name, true);
    }

    public void start(String pid, String name, boolean background) {
        this.pid = pid;
        this.tbPid.setValue(pid);
        this.name = name;
        ((Caption)this.getFellow("cTitle")).setLabel(name);
        if (background) {
            this.btnHide.setVisible(true);
        }
        this.timer.start();
        this.onTimer$timer(null);
    }

    public void onTimer$timer(Event e) {
        String s;
        JSONObject jo;
        if (this.parent == null) {
            this.parent = (Window)this.getParent();
        }
        if ((jo = this.get()) == null) {
            return;
        }
        if (jo.containsKey((Object)"status")) {
            this.jobstatus.setValue(jo.get((Object)"status").toString());
        }
        if ("job does not exist".equals(s = jo.get((Object)"state").toString())) {
            this.timer.stop();
            this.getMapComposer().showMessage(this.name + " request does not exist", "");
            this.detach();
            return;
        }
        String p = jo.get((Object)"progress").toString();
        try {
            double d = Double.parseDouble(p);
            this.jobprogress.setValue((int)(d * 100.0));
        }
        catch (Exception ex) {
            LOGGER.error((Object)("failed to parse progress %: " + p));
        }
        String l = jo.get((Object)"log").toString();
        if (l != null) {
            this.log = this.reverseLines(l) + this.log;
            if (this.txtLog != null) {
                this.txtLog.setValue(this.log);
            }
        }
        this.remoteLogger.logMapAnalysisUpdateStatus(this.pid, s);
        if ("SUCCESSFUL".equals(s)) {
            this.timer.stop();
            LOGGER.debug((Object)"JOB DONE. Calling loadMap");
            Events.echoEvent((String)"loadMap", (Component)this.parent, null);
            this.detach();
        } else if (s.startsWith("FAILED")) {
            this.timer.stop();
            String errorInfo = jo.get((Object)"message").toString();
            errorInfo = !"job does not exist".equals(errorInfo) ? " with the following message: \n\n" + Util.breakString((String)errorInfo, (int)64) : "";
            this.getMapComposer().showMessage(this.name + " failed" + errorInfo);
            this.detach();
            this.parent.detach();
        } else if ("CANCELLED".equals(s)) {
            this.timer.stop();
            this.getMapComposer().showMessage(this.name + " cancelled by user");
            this.detach();
        }
    }

    JSONObject get() {
        try {
            StringBuilder sbProcessUrl = new StringBuilder();
            sbProcessUrl.append(CommonData.getSatServer()).append("/ws/job?pid=").append(this.pid);
            LOGGER.debug((Object)("checking status every '" + this.timer.getDelay() + "' sec: " + sbProcessUrl.toString()));
            HttpClient client = new HttpClient();
            GetMethod get = new GetMethod(sbProcessUrl.toString());
            get.addRequestHeader("Accept", "application/json");
            client.getHttpConnectionManager().getParams().setSoTimeout(this.timer.getDelay());
            int result = client.executeMethod((HttpMethod)get);
            if (result == 200) {
                JSONParser jp = new JSONParser();
                return (JSONObject)jp.parse(get.getResponseBodyAsString());
            }
        }
        catch (SocketTimeoutException e) {
            LOGGER.debug((Object)"progress timeout exception, will be trying again.");
        }
        catch (Exception e) {
            LOGGER.error((Object)("error getting updated job info pid=" + this.pid), (Throwable)e);
        }
        return null;
    }

    public void onClick$btnCancel(Event e) {
        try {
            HttpClient client = new HttpClient();
            GetMethod get = new GetMethod(CommonData.getSatServer() + "/ws/jobs/cancel?pid=" + this.pid);
            get.addRequestHeader("Accept", "text/plain");
            client.getHttpConnectionManager().getParams().setSoTimeout(this.timer.getDelay());
            client.executeMethod((HttpMethod)get);
        }
        catch (Exception ex) {
            LOGGER.error((Object)("error getting updated job info pid=" + this.pid), (Throwable)ex);
        }
        this.detach();
    }

    public void onClick$btnHide(Event e) {
        this.showReferenceNumber("Go to the Spatial Portal Dashboard for an update on the status.");
        this.detach();
    }

    void showReferenceNumber() {
        this.getMapComposer().showMessage("Reference number to retrieve results: " + this.pid);
    }

    void showReferenceNumber(String message) {
        this.getMapComposer().showMessage("Reference number to retrieve results: " + this.pid + "\n" + message);
    }

    private String reverseLines(String log) {
        String[] split = log.split("\n");
        StringBuilder sb = new StringBuilder();
        for (int i = split.length - 1; i >= 0; --i) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(split[i]);
        }
        return sb.toString();
    }

    public void setParentWindow(Window parentWindow) {
        this.parent = parentWindow;
    }
}

