/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.layer;

import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.LayerSelection;
import au.org.emii.portal.composer.MapComposer;
import au.org.emii.portal.menu.MapLayer;
import java.util.List;
import org.zkoss.zk.ui.Component;
import org.zkoss.zul.Combobox;
import org.zkoss.zul.Comboitem;

public class SelectedLayersCombobox
extends Combobox {
    private boolean includeAnalysisLayers = false;

    public void init(List<LayerSelection> layerSelections, MapComposer mc, boolean includeAnalysisLayers) {
        String name;
        int i;
        this.includeAnalysisLayers = includeAnalysisLayers;
        while (this.getItemCount() > 0) {
            this.removeItemAt(0);
        }
        Comboitem ci = new Comboitem("Paste a layer set");
        ci.setParent((Component)this);
        ci = new Comboitem("Import a layer set");
        ci.setParent((Component)this);
        for (i = 0; i < CommonData.getAnalysisLayerSets().size(); ++i) {
            ci = new Comboitem(((LayerSelection)CommonData.getAnalysisLayerSets().get(i)).toString());
            ci.setValue(CommonData.getAnalysisLayerSets().get(i));
            ci.setParent((Component)this);
        }
        for (i = 0; i < layerSelections.size(); ++i) {
            ci = new Comboitem(layerSelections.get(i).toString());
            ci.setValue((Object)layerSelections.get(i));
            ci.setParent((Component)this);
        }
        for (MapLayer ml : mc.getGridLayers()) {
            name = null;
            String url = ml.getUri();
            int p1 = url.indexOf("ALA:") + 4;
            int p2 = url.indexOf(38, p1);
            if (p1 > 4) {
                if (p2 < 0) {
                    p2 = url.length();
                }
                name = url.substring(p1, p2);
            }
            if (name == null) continue;
            ci = new Comboitem(ml.getDisplayName());
            ci.setValue((Object)new LayerSelection(ml.getDisplayName(), name));
            ci.setParent((Component)this);
        }
        if (includeAnalysisLayers) {
            for (MapLayer ml : mc.getAnalysisLayers()) {
                name = null;
                if (ml.getSubType() == 14) {
                    name = ml.getPid();
                } else if (ml.getSubType() == 15) {
                    name = ml.getPid();
                } else if (ml.getSubType() == 16) {
                    name = ml.getPid();
                } else if (ml.getSubType() == 24) {
                    name = ml.getPid();
                } else if (ml.getSubType() == 25) {
                    name = ml.getPid();
                }
                if (name == null) continue;
                ci = new Comboitem(ml.getDisplayName());
                ci.setValue((Object)new LayerSelection(ml.getDisplayName(), name));
                ci.setParent((Component)this);
            }
        }
    }

    public boolean getIncludeAnalysisLayers() {
        return this.includeAnalysisLayers;
    }
}

