/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.layer;

import au.org.ala.spatial.dto.ListEntryDTO;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.Util;
import au.org.emii.portal.composer.MapComposer;
import au.org.emii.portal.menu.MapLayer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.ListitemRenderer;
import org.zkoss.zul.SimpleListModel;

public class EnvironmentalList
extends Listbox {
    private static final Logger LOGGER = Logger.getLogger(EnvironmentalList.class);
    private List<ListEntryDTO> listEntries;
    private float[] threasholds = new float[]{0.1f, 0.3f, 1.0f};
    private MapComposer mapComposer;
    private boolean includeAnalysisLayers;
    private boolean disableContextualLayers;
    private boolean singleDomain;

    public void init(MapComposer mc, boolean includeAnalysisLayers, boolean disableContextualLayers, boolean singleDomain) {
        this.mapComposer = mc;
        this.includeAnalysisLayers = includeAnalysisLayers;
        this.disableContextualLayers = disableContextualLayers;
        this.singleDomain = singleDomain;
        try {
            this.setupListEntries();
            this.setupList();
            this.setMultiple(true);
        }
        catch (Exception e) {
            LOGGER.error((Object)"error with initial setip of Environmental List", (Throwable)e);
        }
    }

    void setupListEntries() {
        this.listEntries = new ArrayList();
        JSONArray ja = CommonData.getLayerListJSONArray();
        for (int i = 0; i < ja.size(); ++i) {
            JSONObject jo = (JSONObject)ja.get(i);
            this.listEntries.add(new ListEntryDTO(jo.get((Object)"name").toString(), jo.containsKey((Object)"displayname") ? jo.get((Object)"displayname").toString() : jo.get((Object)"name").toString(), jo.containsKey((Object)"classification1") ? jo.get((Object)"classification1").toString() : "", jo.containsKey((Object)"classification2") ? jo.get((Object)"classification2").toString() : "", jo.containsKey((Object)"type") ? jo.get((Object)"type").toString() : "", jo.containsKey((Object)"domain") ? jo.get((Object)"domain").toString() : "", jo));
        }
        if (this.includeAnalysisLayers) {
            for (MapLayer ml : this.mapComposer.getAnalysisLayers()) {
                ListEntryDTO le = null;
                if (ml.getSubType() == 14) {
                    le = new ListEntryDTO(ml.getName(), ml.getDisplayName(), "Analysis", "Classification", "Contextual", null, null);
                } else if (ml.getSubType() == 15) {
                    le = new ListEntryDTO(ml.getName(), ml.getDisplayName(), "Analysis", "Prediction", "environmental", null, null);
                } else if (ml.getSubType() == 16) {
                    le = new ListEntryDTO(ml.getName(), ml.getDisplayName(), "Analysis", "GDM", "environmental", null, null);
                } else if (ml.getSubType() == 24) {
                    le = new ListEntryDTO(ml.getName(), ml.getDisplayName(), "Analysis", "Occurrence Density", "environmental", null, null);
                } else if (ml.getSubType() == 25) {
                    le = new ListEntryDTO(ml.getName(), ml.getDisplayName(), "Analysis", "Species Richness", "environmental", null, null);
                }
                if (le == null) continue;
                this.listEntries.add(le);
            }
        }
        Collections.sort(this.listEntries, new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setupList() {
        try {
            this.setItemRenderer((ListitemRenderer)new /* Unavailable Anonymous Inner Class!! */);
            SimpleListModel listModel = new SimpleListModel(this.listEntries);
            this.setModel((ListModel)listModel);
            this.setMultiple(true);
        }
        catch (Exception e) {
            LOGGER.debug((Object)"error setting up env list", (Throwable)e);
        }
    }

    public boolean isMultiple() {
        return true;
    }

    public void toggleItemSelection(Listitem item) {
        super.toggleItemSelection(item);
        this.setMultiple(true);
    }

    public void updateDistances() {
        String fieldId;
        this.setMultiple(true);
        if (this.listEntries == null) {
            return;
        }
        for (ListEntryDTO le : this.listEntries) {
            if ("contextual".equalsIgnoreCase(le.getType()) || le.getLayerObject() == null || !le.getLayerObject().containsKey((Object)"fields") || (fieldId = this.getFieldId(le.getLayerObject())) == null || CommonData.getDistancesMap().get(fieldId) == null) {
                le.setValue(2.0f);
                continue;
            }
            le.setValue(1.0f);
        }
        for (Object o : this.getSelectedItems()) {
            String[] domain;
            ListEntryDTO l = (ListEntryDTO)this.listEntries.get(((Listitem)o).getIndex());
            l.setValue(0.0f);
            if (!"environmental".equalsIgnoreCase(l.getType()) || l.getLayerObject() == null || !l.getLayerObject().containsKey((Object)"fields") || (fieldId = this.getFieldId(l.getLayerObject())) == null || CommonData.getDistancesMap().get(fieldId) == null || (domain = Util.getDomain((JSONObject)l.getLayerObject())).length <= 0) continue;
            for (ListEntryDTO le : this.listEntries) {
                if (le.getLayerObject() == null || !le.getLayerObject().containsKey((Object)"fields") || this.singleDomain && !Util.isSameDomain((String[])Util.getDomain((JSONObject)le.getLayerObject()), (String[])domain)) continue;
                String fieldId2 = this.getFieldId(le.getLayerObject());
                Double d = (Double)((Map)CommonData.getDistancesMap().get(fieldId)).get(fieldId2);
                if (d == null) continue;
                le.setValue((float)Math.min((double)le.getValue(), d));
            }
        }
        for (int i = 0; i < this.listEntries.size(); ++i) {
            float value = ((ListEntryDTO)this.listEntries.get(i)).getValue();
            String type = ((ListEntryDTO)this.listEntries.get(i)).getType();
            Listcell lc = (Listcell)this.getItemAtIndex(i).getLastChild();
            if (!"environmental".equalsIgnoreCase(type)) continue;
            if (this.threasholds[0] > value) {
                lc.setSclass("lcRed");
                continue;
            }
            if (this.threasholds[1] > value) {
                lc.setSclass("lcYellow");
                continue;
            }
            if (1.0f >= value) {
                lc.setSclass("lcGreen");
                continue;
            }
            lc.setSclass("lcWhite");
        }
        this.forceDomain();
    }

    void forceDomain() {
        String[] firstDomain = this.getFirstDomain();
        if (!this.singleDomain || firstDomain.length == 0) {
            for (int i = 0; i < this.listEntries.size(); ++i) {
                boolean defaultDisable = this.disableContextualLayers && "contextual".equalsIgnoreCase(((ListEntryDTO)this.listEntries.get(i)).getType());
                this.getItemAtIndex(i).setDisabled(defaultDisable);
            }
            return;
        }
        for (int i = 0; i < this.listEntries.size(); ++i) {
            String[] thisDomain;
            ListEntryDTO l = (ListEntryDTO)this.listEntries.get(i);
            if (l.getLayerObject() == null || (thisDomain = Util.getDomain((JSONObject)l.getLayerObject())).length <= 0) continue;
            boolean defaultDisable = this.disableContextualLayers && "contextual".equalsIgnoreCase(((ListEntryDTO)this.listEntries.get(i)).getType());
            boolean match = false;
            for (String d1 : firstDomain) {
                for (String d2 : thisDomain) {
                    if (!d1.equalsIgnoreCase(d2)) continue;
                    match = true;
                }
            }
            this.getItemAtIndex(i).setDisabled(defaultDisable || !match);
            if (match || !this.getItemAtIndex(i).isSelected()) continue;
            this.toggleItemSelection(this.getItemAtIndex(i));
        }
    }

    String[] getFirstDomain() {
        Object o;
        ListEntryDTO l;
        String[] domain = new String[]{};
        Iterator i$ = this.getSelectedItems().iterator();
        while (i$.hasNext() && (!"environmental".equalsIgnoreCase((l = (ListEntryDTO)this.listEntries.get(((Listitem)(o = i$.next())).getIndex())).getType()) || l.getLayerObject() == null || (domain = Util.getDomain((JSONObject)l.getLayerObject())).length <= 0)) {
        }
        return domain;
    }

    String getFieldId(JSONObject layerObject) {
        String fieldId = null;
        try {
            JSONArray ja = (JSONArray)layerObject.get((Object)"fields");
            for (int i = 0; i < ja.size(); ++i) {
                JSONObject jo = (JSONObject)ja.get(i);
                if (!"true".equalsIgnoreCase(jo.get((Object)"analysis").toString())) continue;
                fieldId = jo.get((Object)"id").toString();
                break;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("error getting field id from layer JSON object: " + layerObject), (Throwable)e);
        }
        return fieldId;
    }

    public void onSelect(Event event) {
        this.setMultiple(true);
        this.updateDistances();
    }

    public String[] getSelectedLayers() {
        this.setMultiple(true);
        Set selectedItems = this.getSelectedItems();
        String[] selected = new String[selectedItems.size()];
        int i = 0;
        LOGGER.debug((Object)"getSelectedLayers: ");
        for (Object o : selectedItems) {
            selected[i] = ((ListEntryDTO)this.listEntries.get(((Listitem)o).getIndex())).getName();
            ++i;
            LOGGER.debug((Object)(((ListEntryDTO)this.listEntries.get(((Listitem)o).getIndex())).getDisplayName() + ", " + ((ListEntryDTO)this.listEntries.get(((Listitem)o).getIndex())).getName()));
        }
        LOGGER.debug((Object)"");
        return selected;
    }

    public void selectLayers(String[] layers) {
        this.setMultiple(true);
        String[] firstDomain = this.getFirstDomain();
        block0: for (int i = 0; i < this.listEntries.size(); ++i) {
            for (int j = 0; j < layers.length; ++j) {
                if (!((ListEntryDTO)this.listEntries.get(i)).getDisplayName().equalsIgnoreCase(layers[j]) && !((ListEntryDTO)this.listEntries.get(i)).getName().equalsIgnoreCase(layers[j])) continue;
                if (this.getItemAtIndex(i).isSelected() || this.singleDomain && !Util.isSameDomain((String[])firstDomain, (String[])Util.getDomain((JSONObject)((ListEntryDTO)this.listEntries.get(i)).getLayerObject()))) continue block0;
                this.toggleItemSelection(this.getItemAtIndex(i));
                continue block0;
            }
        }
        this.updateDistances();
    }

    public void selectLayersAndDisable(String[] layers) {
        this.setMultiple(true);
        if (layers == null) {
            return;
        }
        block0: for (int i = 0; i < this.listEntries.size(); ++i) {
            String f = CommonData.getLayerFacetName((String)((ListEntryDTO)this.listEntries.get(i)).getName());
            for (int j = 0; j < layers.length; ++j) {
                if (f == null || !f.equalsIgnoreCase(layers[j])) continue;
                this.toggleItemSelection(this.getItemAtIndex(i));
                this.getItemAtIndex(i).setDisabled(true);
                this.getItemAtIndex(i).setCheckable(false);
                continue block0;
            }
        }
        this.updateDistances();
    }

    public void clearSelection() {
        this.updateDistances();
        super.clearSelection();
    }

    public boolean getIncludeAnalysisLayers() {
        return this.includeAnalysisLayers;
    }

    static /* synthetic */ boolean access$000(EnvironmentalList x0) {
        return x0.disableContextualLayers;
    }

    static /* synthetic */ MapComposer access$100(EnvironmentalList x0) {
        return x0.mapComposer;
    }

    static /* synthetic */ float[] access$200(EnvironmentalList x0) {
        return x0.threasholds;
    }
}

