/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.layer;

import au.org.ala.spatial.util.CommonData;
import au.org.emii.portal.composer.MapComposer;
import au.org.emii.portal.menu.MapLayer;
import java.net.URLEncoder;
import java.util.Iterator;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Sessions;
import org.zkoss.zk.ui.event.InputEvent;
import org.zkoss.zul.Combobox;
import org.zkoss.zul.Comboitem;

public class EnvLayersCombobox
extends Combobox {
    private static final Logger LOGGER = Logger.getLogger(EnvLayersCombobox.class);
    private boolean includeAnalysisLayers = false;
    private String includeLayers;

    public EnvLayersCombobox() {
        this.refresh("");
    }

    public void onChanging(InputEvent evt) {
        if (!evt.isChangingBySelectBack()) {
            this.refresh(evt.getValue());
        }
    }

    public void refresh(String val) {
        if (val.length() < 3) {
            return;
        }
        String baseUrl = CommonData.getLayersServer() + "/layers/";
        try {
            Comboitem myci;
            String name;
            String type;
            String displayName;
            JSONArray results;
            Iterator it = this.getItems().iterator();
            String lsurl = baseUrl;
            if (val.length() == 0) {
                results = CommonData.getLayerListJSONArray();
            } else {
                lsurl = lsurl + "search/?q=" + URLEncoder.encode(val, "UTF-8");
                LOGGER.debug((Object)("nsurl: " + lsurl));
                HttpClient client = new HttpClient();
                GetMethod get = new GetMethod(lsurl);
                get.addRequestHeader("Accept", "application/json, text/javascript, */*");
                client.executeMethod((HttpMethod)get);
                String slist = get.getResponseBodyAsString();
                JSONParser jp = new JSONParser();
                results = (JSONArray)jp.parse(slist);
            }
            LOGGER.debug((Object)("got " + results.size() + " layers"));
            Sessions.getCurrent().setAttribute("layerlist", (Object)results);
            if (!results.isEmpty()) {
                for (int i = 0; i < results.size(); ++i) {
                    JSONObject jo = (JSONObject)results.get(i);
                    if (!jo.get((Object)"enabled").toString().equalsIgnoreCase("true") || !jo.containsKey((Object)"displayname") || !jo.containsKey((Object)"type") || !"environmental".equalsIgnoreCase(jo.get((Object)"type").toString()) && this.includeLayers != null && !"AllLayers".equalsIgnoreCase(this.includeLayers) && !"MixLayers".equalsIgnoreCase(this.includeLayers)) continue;
                    displayName = jo.get((Object)"displayname").toString();
                    type = jo.get((Object)"type").toString();
                    name = jo.get((Object)"name").toString();
                    JSONObject layer = CommonData.getLayer((String)name);
                    boolean skip = false;
                    if (layer != null && layer.containsKey((Object)"fields")) {
                        JSONArray ja = (JSONArray)layer.get((Object)"fields");
                        for (int j = 0; j < ja.size() && !skip; ++j) {
                            if (!((JSONObject)ja.get(j)).containsKey((Object)"addtomap") || ((JSONObject)ja.get(j)).get((Object)"addtomap").toString().equalsIgnoreCase("true")) continue;
                            skip = true;
                        }
                    }
                    if (skip) continue;
                    if (it != null && it.hasNext()) {
                        myci = (Comboitem)it.next();
                        myci.setLabel(displayName);
                    } else {
                        it = null;
                        myci = new Comboitem(displayName);
                        myci.setParent((Component)this);
                    }
                    String c2 = "";
                    if (jo.containsKey((Object)"classification2") && !"null".equals(jo.get((Object)"classification2"))) {
                        c2 = jo.get((Object)"classification2") + ": ";
                    }
                    String c1 = "";
                    if (jo.containsKey((Object)"classification1") && !"null".equals(jo.get((Object)"classification1"))) {
                        c1 = jo.get((Object)"classification1") + ": ";
                    }
                    myci.setDescription(c1 + c2 + type);
                    myci.setValue((Object)jo);
                }
            }
            if (this.includeAnalysisLayers) {
                for (MapLayer ml : this.getMapComposer().getAnalysisLayers()) {
                    String classification2;
                    String classification1;
                    displayName = ml.getDisplayName();
                    if (ml.getSubType() == 15) {
                        type = "environmental";
                        classification1 = "Analysis";
                        classification2 = "Prediction";
                        name = ml.getName();
                    } else if (ml.getSubType() == 16) {
                        type = "environmental";
                        classification1 = "Analysis";
                        classification2 = "GDM";
                        name = ml.getName();
                    } else if (ml.getSubType() == 24) {
                        type = "environmental";
                        classification1 = "Analysis";
                        classification2 = "Occurrence Density";
                        name = ml.getName();
                    } else {
                        if (ml.getSubType() != 25) continue;
                        type = "environmental";
                        classification1 = "Analysis";
                        classification2 = "Species Richness";
                        name = ml.getName();
                    }
                    if (it != null && it.hasNext()) {
                        myci = (Comboitem)it.next();
                        myci.setLabel(displayName);
                    } else {
                        it = null;
                        myci = new Comboitem(displayName);
                        myci.setParent((Component)this);
                    }
                    myci.setDescription(classification1 + ": " + classification2 + " " + type);
                    myci.setDisabled(false);
                    JSONObject jo = new JSONObject();
                    jo.put((Object)"name", (Object)name);
                    myci.setValue((Object)jo);
                }
            }
            while (it != null && it.hasNext()) {
                it.next();
                it.remove();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error searching for layers:", (Throwable)e);
        }
    }

    public boolean getIncludeAnalysisLayers() {
        return this.includeAnalysisLayers;
    }

    public void setIncludeAnalysisLayers(boolean includeAnalysisLayers) {
        this.includeAnalysisLayers = includeAnalysisLayers;
    }

    public String getIncludeLayers() {
        return this.includeLayers;
    }

    public void setIncludeLayers(String includeLayers) {
        this.includeLayers = includeLayers;
        LOGGER.debug((Object)("this.includeLayers=" + this.includeLayers));
    }

    public MapComposer getMapComposer() {
        return (MapComposer)Executions.getCurrent().getDesktop().getPage("MapZul").getFellow("mapPortalPage");
    }
}

