/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.layer;

import au.org.ala.spatial.util.CommonData;
import java.net.URLEncoder;
import java.util.Iterator;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Sessions;
import org.zkoss.zk.ui.event.InputEvent;
import org.zkoss.zul.Combobox;
import org.zkoss.zul.Comboitem;

public class ContextualLayersAutoComplete
extends Combobox {
    private static final Logger LOGGER = Logger.getLogger(ContextualLayersAutoComplete.class);

    public ContextualLayersAutoComplete() {
        this.refresh("");
    }

    public void onChanging(InputEvent evt) {
        if (!evt.isChangingBySelectBack()) {
            this.refresh(evt.getValue());
        }
    }

    private void refresh(String val) {
        if (val.length() < 3) {
            return;
        }
        String baseUrl = CommonData.getLayersServer() + "/layers/";
        try {
            JSONArray results;
            Iterator it = this.getItems().iterator();
            String lsurl = baseUrl;
            if (val.length() == 0) {
                results = CommonData.getLayerListJSONArray();
            } else {
                lsurl = lsurl + "search/?q=" + URLEncoder.encode(val, "UTF-8");
                LOGGER.debug((Object)("nsurl: " + lsurl));
                HttpClient client = new HttpClient();
                GetMethod get = new GetMethod(lsurl);
                get.addRequestHeader("Accept", "application/json, text/javascript, */*");
                client.executeMethod((HttpMethod)get);
                String slist = get.getResponseBodyAsString();
                JSONParser jp = new JSONParser();
                results = (JSONArray)jp.parse(slist);
            }
            LOGGER.debug((Object)("got " + results.size() + " layers"));
            Sessions.getCurrent().setAttribute("layerlist", (Object)results);
            if (!results.isEmpty()) {
                for (int i = 0; i < results.size(); ++i) {
                    Comboitem myci;
                    JSONObject jo = (JSONObject)results.get(i);
                    if (!jo.get((Object)"enabled").toString().equalsIgnoreCase("true") || "environmental".equalsIgnoreCase(jo.get((Object)"type").toString())) continue;
                    String displayName = jo.get((Object)"displayname").toString();
                    String type = jo.get((Object)"type").toString();
                    if (it != null && it.hasNext()) {
                        myci = (Comboitem)it.next();
                        myci.setLabel(displayName);
                    } else {
                        it = null;
                        myci = new Comboitem(displayName);
                        myci.setParent((Component)this);
                    }
                    String c2 = "";
                    if (jo.containsKey((Object)"classification2") && !"null".equals(jo.get((Object)"classification2"))) {
                        c2 = jo.get((Object)"classification2") + ": ";
                    }
                    String c1 = "";
                    if (jo.containsKey((Object)"classification1") && !"null".equals(jo.get((Object)"classification1"))) {
                        c1 = jo.get((Object)"classification1") + ": ";
                    }
                    myci.setDescription(c1 + c2 + type);
                    myci.setDisabled(false);
                    myci.setValue((Object)jo);
                }
            }
            while (it != null && it.hasNext()) {
                it.next();
                it.remove();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error searching for layers:", (Throwable)e);
        }
    }
}

