/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.input;

import au.org.ala.spatial.util.SpeciesListUtil;
import au.org.ala.spatial.util.Util;
import au.org.emii.portal.composer.UtilityComposer;
import org.apache.log4j.Logger;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.ForwardEvent;
import org.zkoss.zul.Checkbox;
import org.zkoss.zul.Label;
import org.zkoss.zul.Textbox;

public class UploadToSpeciesListController
extends UtilityComposer {
    private static final Logger LOGGER = Logger.getLogger(UploadToSpeciesListController.class);
    private Textbox tbName;
    private Textbox tbDesc;
    private Checkbox chkPrivate;
    private Label tbInstructions;
    private String species;
    private String dataResourceUid;
    private EventListener callback;

    public void setSpecies(String species) {
        this.species = species;
    }

    public void setCallback(EventListener callback) {
        this.callback = callback;
    }

    public void onClick$btnOk(Event event) {
        if (this.tbName.getValue().length() > 0) {
            String name = this.tbName.getValue();
            String description = this.tbDesc.getValue();
            this.dataResourceUid = SpeciesListUtil.createNewList((String)name, (String)this.species, (String)description, null, (String)Util.getUserEmail(), (boolean)this.chkPrivate.isChecked());
            LOGGER.debug((Object)("The data resource uid: " + this.dataResourceUid));
            if (this.callback != null) {
                try {
                    this.callback.onEvent((Event)new ForwardEvent("", null, null, (Object)this.dataResourceUid));
                }
                catch (Exception e) {
                    LOGGER.error((Object)"failed to trigger callback from species list upload", (Throwable)e);
                }
            }
            this.detach();
        } else {
            this.tbInstructions.setValue("WARNING: Must supply a list name");
        }
    }

    public void onClick$btnCancel(Event event) {
        this.detach();
    }

    public String getDataResourceUid() {
        return this.dataResourceUid;
    }
}

