/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.input;

import au.org.ala.spatial.dto.UserDataDTO;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.Query;
import au.org.ala.spatial.util.UserDataQuery;
import au.org.ala.spatial.util.Util;
import au.org.emii.portal.composer.MapComposer;
import au.org.emii.portal.composer.UtilityComposer;
import au.org.emii.portal.menu.MapLayer;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.zkoss.util.media.AMedia;
import org.zkoss.util.media.Media;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.ForwardEvent;
import org.zkoss.zk.ui.event.UploadEvent;
import org.zkoss.zul.Button;
import org.zkoss.zul.Caption;
import org.zkoss.zul.Constraint;
import org.zkoss.zul.Html;
import org.zkoss.zul.Label;
import org.zkoss.zul.Messagebox;
import org.zkoss.zul.Textbox;

/*
 * Exception performing whole class analysis ignored.
 */
public class UploadSpeciesController
extends UtilityComposer {
    private static final Logger LOGGER = Logger.getLogger(UploadSpeciesController.class);
    private boolean addToMap;
    private Button btnOk;
    private Textbox tbDesc;
    private Textbox tbName;
    private Button fileUpload;
    private Label tbInstructions;
    private Html lsidinfo;
    private String uploadLSID;
    private String uploadType = "normal";
    private boolean defineArea;
    private EventListener callback;
    private EventListener eventListener;

    public static void loadUserPoints(UserDataDTO ud, Reader data, boolean addToMap, String name, String description, MapComposer mc, EventListener eventListener) throws Exception {
        MapLayer ml;
        LOGGER.debug((Object)"\n\n\nin loadUserPoints");
        StringBuilder sbProcessUrl = new StringBuilder();
        sbProcessUrl.append(CommonData.getLayersServer()).append("/userdata/add");
        sbProcessUrl.append("?user_id=").append("anonymous");
        sbProcessUrl.append("&name=").append(URLEncoder.encode(name, "UTF-8"));
        sbProcessUrl.append("&description=").append(URLEncoder.encode(description, "UTF-8"));
        HttpClient client = new HttpClient();
        PostMethod post = new PostMethod(sbProcessUrl.toString());
        post.addRequestHeader("Accept", "application/json");
        post.addParameter("csv", IOUtils.toString((Reader)data));
        LOGGER.debug((Object)("calling add user data ws: " + sbProcessUrl.toString()));
        client.executeMethod((HttpMethod)post);
        JSONObject jo = (JSONObject)new JSONParser().parse(post.getResponseBodyAsString());
        UserDataQuery q = new UserDataQuery(String.valueOf(jo.get((Object)"ud_header_id")));
        if (addToMap && (ml = mc.mapSpecies((Query)q, ud.getName(), "user", ud.getFeatureCount(), 23, null, -1, 3, 0.6f, Util.nextColour(), false)) != null) {
            ml.getMapLayerMetadata().setMoreInfo(q.getMetadataHtml());
        }
        if (eventListener != null) {
            eventListener.onEvent(new Event("", null, (Object)(jo.get((Object)"ud_header_id") + "\t" + ud.getName())));
        }
        data.close();
    }

    public void afterCompose() {
        super.afterCompose();
        this.setTbInstructions("3. Select file (text file, one LSID or name per line)");
        Map m = Executions.getCurrent().getArg();
        if (m != null) {
            for (Map.Entry o : m.entrySet()) {
                if (o.getKey() instanceof String && "setTbInstructions".equals(o.getKey())) {
                    this.setTbInstructions((String)o.getValue());
                }
                if (!(o.getKey() instanceof String) || !"addToMap".equals(o.getKey())) continue;
                this.addToMap = true;
            }
        }
        this.tbName.setConstraint((Constraint)new /* Unavailable Anonymous Inner Class!! */);
        this.fileUpload.addEventListener("onUpload", (EventListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setCallback(EventListener callback) {
        this.callback = callback;
    }

    public void onClick$btnOk(Event event) {
        this.detach();
    }

    public void onClick$btnCancel(Event event) {
        if (this.callback != null) {
            try {
                this.callback.onEvent((Event)new ForwardEvent("", null, null, (Object)new String[]{"", "cancel"}));
            }
            catch (Exception e) {
                LOGGER.error((Object)"failed to cancel species points upload", (Throwable)e);
            }
        }
        this.detach();
    }

    public void processMedia(Media media) {
        try {
            Messagebox.show((String)"Processing...", (String)"Error", (int)1, (String)"z-messagebox-icon z-messagebox-error");
            LOGGER.debug((Object)"Loading files");
            if (media != null) {
                if (media instanceof AMedia) {
                    LOGGER.debug((Object)"Valid file successfully uploaded");
                } else {
                    Messagebox.show((String)("Not a valid upload: " + media), (String)"Error", (int)1, (String)"z-messagebox-icon z-messagebox-error");
                    LOGGER.debug((Object)"not a valid file");
                }
            } else {
                Messagebox.show((String)"No attachment", (String)"Error", (int)1, (String)"z-messagebox-icon z-messagebox-error");
                LOGGER.debug((Object)"No attachment");
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unable to process media: ", (Throwable)e);
        }
    }

    public void onUpload$btnFileUpload(Event event) {
        this.doFileUpload("", event);
    }

    public void doFileUpload(String name, Event event) {
        this.doFileUpload(new UserDataDTO(name), event);
    }

    public void doFileUpload(UserDataDTO ud, Event event) {
        UploadEvent ue = null;
        if (event instanceof UploadEvent) {
            ue = (UploadEvent)event;
        } else if (event instanceof ForwardEvent) {
            ue = (UploadEvent)((ForwardEvent)event).getOrigin();
        }
        if (ue == null) {
            LOGGER.debug((Object)"unable to upload file");
            return;
        }
        LOGGER.debug((Object)"fileUploaded()");
        try {
            Media m = ue.getMedia();
            UserDataDTO u = ud;
            if (u == null) {
                u = new UserDataDTO(m.getName());
            }
            if (u.getName().trim().isEmpty()) {
                u.setName(m.getName());
            }
            u.setFilename(m.getName());
            if (u.getName() == null || u.getName().length() == 0) {
                u.setName(m.getName());
            }
            if (u.getDescription() == null || u.getDescription().length() == 0) {
                u.setDescription(m.getName());
            }
            u.setUploadedTimeInMs(System.currentTimeMillis());
            LOGGER.debug((Object)("Got file '" + u.getName() + "' with type '" + m.getContentType() + "'"));
            boolean loaded = false;
            try {
                UploadSpeciesController.loadUserPoints((UserDataDTO)u, (Reader)m.getReaderData(), (boolean)this.addToMap, (String)this.tbName.getText(), (String)this.tbDesc.getText(), (MapComposer)this.getMapComposer(), (EventListener)this.eventListener);
                loaded = true;
                LOGGER.debug((Object)("read type " + m.getContentType() + " with getReaderData"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!loaded) {
                try {
                    UploadSpeciesController.loadUserPoints((UserDataDTO)u, (Reader)new StringReader(new String(m.getByteData())), (boolean)this.addToMap, (String)this.tbName.getText(), (String)this.tbDesc.getText(), (MapComposer)this.getMapComposer(), (EventListener)this.eventListener);
                    loaded = true;
                    LOGGER.debug((Object)("read type " + m.getContentType() + " with getByteData"));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!loaded) {
                try {
                    UploadSpeciesController.loadUserPoints((UserDataDTO)u, (Reader)new InputStreamReader(m.getStreamData()), (boolean)this.addToMap, (String)this.tbName.getText(), (String)this.tbDesc.getText(), (MapComposer)this.getMapComposer(), (EventListener)this.eventListener);
                    loaded = true;
                    LOGGER.debug((Object)("read type " + m.getContentType() + " with getStreamData"));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!loaded) {
                try {
                    UploadSpeciesController.loadUserPoints((UserDataDTO)u, (Reader)new StringReader(m.getStringData()), (boolean)this.addToMap, (String)this.tbName.getText(), (String)this.tbDesc.getText(), (MapComposer)this.getMapComposer(), (EventListener)this.eventListener);
                    LOGGER.debug((Object)("read type " + m.getContentType() + " with getStringData"));
                }
                catch (Exception e) {
                    this.getMapComposer().showMessage("Unable to load your file. Please try again.");
                    LOGGER.error((Object)"unable to load user points: ", (Throwable)e);
                }
            }
            if (this.callback != null) {
                try {
                    this.callback.onEvent((Event)new ForwardEvent("", null, null, (Object)new String[]{this.uploadLSID, this.uploadType}));
                }
                catch (Exception e) {
                    LOGGER.error((Object)"failed to cancel species points upload", (Throwable)e);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)"unable to load user points", (Throwable)ex);
        }
    }

    void setEventListener(EventListener eventListener) {
        this.eventListener = eventListener;
    }

    public void setTbInstructions(String instructions) {
        this.tbInstructions.setValue(instructions);
        if (instructions.contains("longitude")) {
            this.lsidinfo.setVisible(false);
            ((Caption)this.getFellow("cTitle")).setLabel("Import points");
        } else {
            this.lsidinfo.setVisible(true);
            ((Caption)this.getFellow("cTitle")).setLabel("Import assemblage");
        }
    }

    public void setUploadType(String uploadType) {
        this.uploadType = uploadType;
    }

    public void setDefineArea(boolean defineArea) {
        this.defineArea = defineArea;
    }

    public void setAddToMap(boolean addToMap) {
        this.addToMap = addToMap;
    }

    static /* synthetic */ Textbox access$000(UploadSpeciesController x0) {
        return x0.tbName;
    }

    static /* synthetic */ Textbox access$100(UploadSpeciesController x0) {
        return x0.tbDesc;
    }

    static /* synthetic */ boolean access$202(UploadSpeciesController x0, boolean x1) {
        x0.addToMap = x1;
        return x0.addToMap;
    }

    static /* synthetic */ boolean access$302(UploadSpeciesController x0, boolean x1) {
        x0.defineArea = x1;
        return x0.defineArea;
    }
}

