/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.input;

import au.com.bytecode.opencsv.CSVReader;
import au.org.ala.spatial.util.CommonData;
import au.org.emii.portal.composer.UtilityComposer;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import org.apache.log4j.Logger;
import org.zkoss.util.media.Media;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.ForwardEvent;
import org.zkoss.zk.ui.event.UploadEvent;

public class UploadLayerListController
extends UtilityComposer {
    private static final Logger LOGGER = Logger.getLogger(UploadLayerListController.class);
    private EventListener callback;

    public void onClick$btnCancel(Event event) {
        this.detach();
    }

    public void onUpload$fileUpload(Event event) {
        this.doFileUpload(event);
        this.detach();
    }

    public void doFileUpload(Event event) {
        UploadEvent ue = null;
        if (event instanceof UploadEvent) {
            ue = (UploadEvent)event;
        } else if (event instanceof ForwardEvent) {
            ue = (UploadEvent)((ForwardEvent)event).getOrigin();
        }
        if (ue == null) {
            LOGGER.debug((Object)"unable to upload file");
            return;
        }
        LOGGER.debug((Object)"fileUploaded()");
        try {
            Media m = ue.getMedia();
            boolean loaded = false;
            try {
                this.loadLayerList(m.getReaderData());
                loaded = true;
                LOGGER.debug((Object)(m.getContentType() + " with getReaderData"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!loaded) {
                try {
                    this.loadLayerList((Reader)new StringReader(new String(m.getByteData())));
                    loaded = true;
                    LOGGER.debug((Object)(m.getContentType() + " with getByteData"));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!loaded) {
                try {
                    this.loadLayerList((Reader)new InputStreamReader(m.getStreamData()));
                    loaded = true;
                    LOGGER.debug((Object)(m.getContentType() + " with getStreamData"));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!loaded) {
                try {
                    this.loadLayerList((Reader)new StringReader(m.getStringData()));
                    LOGGER.debug((Object)(m.getContentType() + " with getStringData"));
                }
                catch (Exception e) {
                    this.getMapComposer().showMessage(CommonData.lang((String)"error_uploading_file"));
                    LOGGER.error((Object)"unable to load user layer list: ", (Throwable)e);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)"error reading uploaded file", (Throwable)ex);
        }
    }

    private void loadLayerList(Reader r) throws IOException {
        CSVReader reader = new CSVReader(r);
        StringBuilder sb = new StringBuilder();
        for (String s : reader.readNext()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(s);
        }
        reader.close();
        if (this.callback != null) {
            try {
                this.callback.onEvent((Event)new ForwardEvent("", (Component)this, null, (Object)sb.toString()));
            }
            catch (Exception e) {
                LOGGER.error((Object)"failed when calling ToolComposer callback", (Throwable)e);
            }
        }
    }

    public void setCallback(EventListener callback) {
        this.callback = callback;
    }
}

