/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.input;

import au.org.ala.spatial.composer.progress.ProgressController;
import au.org.ala.spatial.logger.RemoteLogger;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.Util;
import au.org.emii.portal.composer.UtilityComposer;
import au.org.emii.portal.lang.LanguagePack;
import au.org.emii.portal.menu.MapLayer;
import au.org.emii.portal.menu.MapLayerMetadata;
import au.org.emii.portal.wms.WMSStyle;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zul.Div;
import org.zkoss.zul.Filedownload;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.ListitemRenderer;
import org.zkoss.zul.SimpleListModel;
import org.zkoss.zul.Textbox;
import org.zkoss.zul.Window;

public class ImportAnalysisController
extends UtilityComposer {
    private static final Logger LOGGER = Logger.getLogger(ImportAnalysisController.class);
    private RemoteLogger remoteLogger;
    private Textbox refNum;
    private String pid;
    private boolean isAloc = false;
    private boolean isMaxent = false;
    private boolean isSxS = false;
    private boolean isGdm = false;
    private boolean sxsSitesBySpecies = false;
    private boolean sxsOccurrenceDensity = false;
    private boolean sxsSpeciesDensity = false;
    private String[] gdmEnvlist;
    private Div divPriorAnalysis;
    private Listbox lbLog;
    private LanguagePack languagePack = null;

    public void afterCompose() {
        super.afterCompose();
        try {
            JSONObject jo = this.remoteLogger.getLogCSV();
            if (jo != null && jo.containsKey((Object)"abe") && !((JSONArray)jo.get((Object)"abe")).isEmpty()) {
                ArrayList<String[]> logEntries = new ArrayList<String[]>();
                for (Object o : (JSONArray)jo.get((Object)"abe")) {
                    JSONObject j = (JSONObject)o;
                    String[] r = new String[5];
                    r[0] = j.containsKey((Object)"id") ? j.get((Object)"id").toString() : "";
                    r[1] = j.containsKey((Object)"category2") ? j.get((Object)"category2").toString() : "";
                    r[2] = j.containsKey((Object)"time") ? new SimpleDateFormat("dd/MM/yyyy hh:mm:ss").format(new Date(Long.parseLong(j.get((Object)"time").toString()))) : "";
                    r[3] = "";
                    String string = r[4] = j.containsKey((Object)"service") && ((JSONObject)j.get((Object)"service")).containsKey((Object)"processid") ? ((JSONObject)j.get((Object)"service")).get((Object)"processid").toString() : "";
                    if (r[4].length() <= 0 || "-1".equals(r[4]) || !"Classification".equalsIgnoreCase(r[1]) && !"GDM".equalsIgnoreCase(r[1]) && !"Prediction".equalsIgnoreCase(r[1]) && !"Species To Grid".equalsIgnoreCase(r[1])) continue;
                    try {
                        r[3] = "true";
                        this.refNum.setValue(r[4]);
                        this.pid = r[4];
                        if (this.getJobStatus().contains("job does not exist")) break;
                        if (!this.hasValidMetadata(r)) continue;
                        logEntries.add(r);
                    }
                    catch (Exception e) {
                        r[4] = "unavailable";
                        r[3] = "false";
                    }
                }
                if (!logEntries.isEmpty()) {
                    this.divPriorAnalysis.setVisible(true);
                    this.lbLog.setModel((ListModel)new SimpleListModel(logEntries));
                    this.setRenderer();
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"getting log did not work", (Throwable)e);
        }
        this.refNum.setValue("");
    }

    void setRenderer() {
        this.lbLog.setItemRenderer((ListitemRenderer)new /* Unavailable Anonymous Inner Class!! */);
    }

    boolean hasValidMetadata(String[] s) {
        String metadata = null;
        if ("Classification".equalsIgnoreCase(s[1])) {
            metadata = CommonData.getSettings().getProperty("sat_url") + "/output/aloc/" + this.refNum.getValue() + "/classification.html";
        } else if ("Prediction".equalsIgnoreCase(s[1])) {
            metadata = CommonData.getSettings().getProperty("sat_url") + "/output/maxent/" + this.refNum.getValue() + "/species.html";
        } else if ("GDM".equalsIgnoreCase(s[1])) {
            metadata = CommonData.getSettings().getProperty("sat_url") + "/output/gdm/" + this.refNum.getValue() + "/gdm.html";
        } else if ("Species to Grid".equalsIgnoreCase(s[1])) {
            String link1 = CommonData.getSettings().getProperty("sat_url") + "/output/sitesbyspecies/" + this.refNum.getValue() + "/sxs_metadata.html";
            String link2 = CommonData.getSettings().getProperty("sat_url") + "/output/sitesbyspecies/" + this.refNum.getValue() + "/odensity_metadata.html";
            String link3 = CommonData.getSettings().getProperty("sat_url") + "/output/sitesbyspecies/" + this.refNum.getValue() + "/srichness_metadata.html";
            if (Util.readUrl((String)link1).length() > 0) {
                return true;
            }
            if (Util.readUrl((String)link2).length() > 0) {
                return true;
            }
            if (Util.readUrl((String)link3).length() > 0) {
                return true;
            }
        }
        return metadata != null && Util.readUrl((String)metadata).length() > 0;
    }

    public void onSelect$lbLog(Event event) {
        Listitem li = this.lbLog.getSelectedItem();
        String[] s = (String[])li.getValue();
        this.refNum.setValue(s[4]);
    }

    public void onClick$btnOk(Event event) {
        this.pid = this.refNum.getValue();
        this.pid = this.pid.trim();
        if (this.getParametersAloc()) {
            this.isAloc = true;
            this.openProgressBarAloc();
            this.remoteLogger.logMapAnalysis("Import Classification", "Tool - Restore", "", "", "", this.pid, "classification", "IMPORTED");
        } else if (this.getParametersMaxent()) {
            this.isMaxent = true;
            this.openProgressBarMaxent();
            this.remoteLogger.logMapAnalysis("Import Prediction", "Tool - Restore", "", "", "", this.pid, "prediction", "IMPORTED");
        } else if (this.getParametersSxS()) {
            this.isSxS = true;
            this.openProgressBarSxS();
            this.remoteLogger.logMapAnalysis("Import Species to Grid", "Tool - Restore", "", "", "", this.pid, "species to grid", "IMPORTED");
        } else if (this.getParametersGdm()) {
            this.isGdm = true;
            this.openProgressBarGdm();
            this.remoteLogger.logMapAnalysis("Import GDM", "Tool - Restore", "", "", "", this.pid, "gdm", "IMPORTED");
        } else {
            this.getMapComposer().showMessage(CommonData.lang((String)"error_importing_analysis"));
        }
    }

    public void onClick$btnCancel(Event event) {
        this.detach();
    }

    boolean getParametersAloc() {
        String txt = this.get();
        try {
            int pos = 0;
            int p1 = txt.indexOf("pid:", pos);
            if (p1 < 0) {
                return false;
            }
            int p2 = txt.indexOf("gc:", pos);
            if (p2 < 0) {
                return false;
            }
            int p3 = txt.indexOf("area:", pos);
            int p4 = txt.indexOf("envlist:", pos);
            int p5 = txt.indexOf("pid:", p1 + 4);
            if (p5 < 0) {
                p5 = txt.length();
            }
            String pd = txt.substring(p1 + 4, p2).trim();
            String gc = txt.substring(p2 + 3, p3).trim();
            String area = txt.substring(p3 + 5, p4).trim();
            String envlist = txt.substring(p4 + 8, p5).trim();
            if (gc.endsWith(";")) {
                gc = gc.substring(0, gc.length() - 1);
            }
            if (area.endsWith(";")) {
                area = area.substring(0, area.length() - 1);
            }
            if (envlist.endsWith(";")) {
                envlist = envlist.substring(0, envlist.length() - 1);
            }
            LOGGER.debug((Object)("got [" + pd + "][" + gc + "][" + area + "][" + envlist + "]"));
            return true;
        }
        catch (Exception e) {
            LOGGER.error((Object)"error building aloc parameters", (Throwable)e);
            return false;
        }
    }

    String get() {
        try {
            HttpClient client = new HttpClient();
            GetMethod get = new GetMethod(CommonData.getSatServer() + "/ws/jobs/" + "inputs" + "?pid=" + this.pid);
            get.addRequestHeader("Accept", "text/plain");
            client.executeMethod((HttpMethod)get);
            return get.getResponseBodyAsString();
        }
        catch (Exception e) {
            LOGGER.error((Object)("error getting job info pid=" + this.pid), (Throwable)e);
            return "";
        }
    }

    void openProgressBarAloc() {
        ProgressController window = (ProgressController)Executions.createComponents((String)"WEB-INF/zul/progress/AnalysisProgress.zul", (Component)this.getMapComposer(), null);
        window.setParentWindow((Window)this);
        window.start(this.pid, "Classification");
        try {
            window.setParent((Component)this.getMapComposer());
            window.doModal();
        }
        catch (Exception e) {
            LOGGER.error((Object)("error opening classification progress bar for pid: " + this.pid), (Throwable)e);
        }
    }

    public void loadMap(Event event) {
        if (this.isAloc) {
            this.loadMapAloc(event);
        } else if (this.isMaxent) {
            this.loadMapMaxent(event);
        } else if (this.isSxS) {
            this.loadMapSxS();
        }
    }

    public void loadMapAloc(Event event) {
        String layerLabel = "Classification - " + this.pid;
        String mapurl = CommonData.getGeoServer() + "/wms?service=WMS&version=1.1.0&request=GetMap&layers=ALA:aloc_" + this.pid + "&FORMAT=image%2Fpng";
        String legendurl = CommonData.getGeoServer() + "/wms?REQUEST=GetLegendGraphic&VERSION=1.0.0&FORMAT=image/png&WIDTH=10&HEIGHT=1" + "&LAYER=ALA:aloc_" + this.pid;
        LOGGER.debug((Object)legendurl);
        this.getMapComposer().addWMSLayer("aloc_" + this.pid, layerLabel, mapurl, 0.5f, null, legendurl, 14, null, null);
        MapLayer mapLayer = this.getMapComposer().getMapLayer("aloc_" + this.pid);
        mapLayer.setPid(this.pid);
        if (mapLayer != null) {
            WMSStyle style = new WMSStyle();
            style.setName("Default");
            style.setDescription("Default style");
            style.setTitle("Default");
            style.setLegendUri(legendurl);
            LOGGER.debug((Object)("legend:" + legendurl));
            mapLayer.addStyle(style);
            mapLayer.setSelectedStyleIndex(1);
            MapLayerMetadata md = mapLayer.getMapLayerMetadata();
            String infoUrl = CommonData.getSatServer() + "/output/layers/" + this.pid + "/metadata.html" + "\nClassification output\npid:" + this.pid;
            md.setMoreInfo(infoUrl);
            md.setId(Long.valueOf(this.pid).longValue());
            this.getMapComposer().updateLayerControls();
            try {
                String fileUrl = CommonData.getSatServer() + "/ws/download/" + this.pid;
                Filedownload.save((InputStream)new URL(fileUrl).openStream(), (String)"application/zip", (String)(layerLabel.replaceAll(" ", "_") + ".zip"));
            }
            catch (Exception ex) {
                LOGGER.error((Object)("Error generating download for classification model pid=" + this.pid), (Throwable)ex);
            }
        }
        this.detach();
    }

    double[] getExtents() {
        double[] d = new double[6];
        try {
            HttpClient client = new HttpClient();
            GetMethod get = new GetMethod(CommonData.getSatServer() + "/output/aloc/" + this.pid + "/aloc.pngextents.txt");
            get.addRequestHeader("Accept", "text/plain");
            client.executeMethod((HttpMethod)get);
            String slist = get.getResponseBodyAsString();
            LOGGER.debug((Object)("getExtents:" + slist));
            String[] s = slist.split("\n");
            for (int i = 0; i < 6 && i < s.length; ++i) {
                d[i] = Double.parseDouble(s[i]);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("error getting aloc extents, pid=" + this.pid), (Throwable)e);
        }
        return d;
    }

    String getJob() {
        try {
            StringBuilder sbProcessUrl = new StringBuilder();
            sbProcessUrl.append(CommonData.getSatServer()).append("/ws/jobs/").append("inputs").append("?pid=").append(this.pid);
            LOGGER.debug((Object)sbProcessUrl.toString());
            HttpClient client = new HttpClient();
            GetMethod get = new GetMethod(sbProcessUrl.toString());
            get.addRequestHeader("Accept", "text/plain");
            client.executeMethod((HttpMethod)get);
            return get.getResponseBodyAsString();
        }
        catch (Exception e) {
            LOGGER.error((Object)("error getting job type for job pid=" + this.pid), (Throwable)e);
            return "";
        }
    }

    String getJobStatus() {
        try {
            StringBuilder sbProcessUrl = new StringBuilder();
            sbProcessUrl.append(CommonData.getSatServer()).append("/ws/job").append("?pid=").append(this.pid);
            LOGGER.debug((Object)sbProcessUrl.toString());
            HttpClient client = new HttpClient();
            GetMethod get = new GetMethod(sbProcessUrl.toString());
            get.addRequestHeader("Accept", "application/json");
            client.executeMethod((HttpMethod)get);
            return get.getResponseBodyAsString();
        }
        catch (Exception e) {
            LOGGER.error((Object)("error getting job type for job pid=" + this.pid), (Throwable)e);
            return "";
        }
    }

    void openProgressBarMaxent() {
        ProgressController window = (ProgressController)Executions.createComponents((String)"WEB-INF/zul/progress/AnalysisProgress.zul", (Component)this.getMapComposer(), null);
        window.setParentWindow((Window)this);
        window.start(this.pid, "Prediction");
        try {
            window.setParent((Component)this.getMapComposer());
            window.doModal();
        }
        catch (Exception e) {
            LOGGER.error((Object)("error opening prediction progress bar pid=" + this.pid), (Throwable)e);
        }
    }

    boolean getParametersMaxent() {
        String txt = this.get();
        try {
            int pos = 0;
            int p1 = txt.indexOf("pid:", pos);
            if (p1 < 0) {
                return false;
            }
            int p2 = txt.indexOf("taxonid:", pos);
            return p2 >= 0;
        }
        catch (Exception e) {
            LOGGER.error((Object)("error getting maxent parameters pid=" + this.pid + ", inputs=" + txt), (Throwable)e);
            return false;
        }
    }

    boolean getParametersSxS() {
        String txt = this.get();
        try {
            int pos = 0;
            int p1 = txt.indexOf("pid:", pos);
            if (p1 < 0) {
                return false;
            }
            int p2 = txt.indexOf("gridsize:", pos);
            if (p2 < 0) {
                return false;
            }
            if (txt.indexOf("sitesbyspecies") > 0) {
                this.sxsSitesBySpecies = true;
            }
            if (txt.indexOf("occurrencedensity") > 0) {
                this.sxsOccurrenceDensity = true;
            }
            if (txt.indexOf("speciesdensity") > 0) {
                this.sxsSpeciesDensity = true;
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error((Object)("error getting sites by species inputs, pid=" + this.pid + ", inputs=" + txt), (Throwable)e);
            return false;
        }
    }

    void openProgressBarSxS() {
        ProgressController window = (ProgressController)Executions.createComponents((String)"WEB-INF/zul/progress/AnalysisProgress.zul", (Component)this.getMapComposer(), null);
        window.setParentWindow((Window)this);
        window.start(this.pid, "Points to Grid");
        try {
            window.setParent((Component)this.getMapComposer());
            window.doModal();
        }
        catch (Exception e) {
            LOGGER.error((Object)("error opening sites by species progress bar pid=" + this.pid), (Throwable)e);
        }
    }

    public void loadMapMaxent(Event event) {
        String mapurl = CommonData.getGeoServer() + "/wms?service=WMS&version=1.1.0&request=GetMap&layers=ALA:species_" + this.pid + "&styles=alastyles&FORMAT=image%2Fpng";
        String legendurl = CommonData.getGeoServer() + "/wms?REQUEST=GetLegendGraphic&VERSION=1.0.0&FORMAT=image/png&WIDTH=10&HEIGHT=1" + "&LAYER=ALA:species_" + this.pid + "&STYLE=alastyles";
        LOGGER.debug((Object)legendurl);
        String layername = "Maxent - " + this.pid;
        this.getMapComposer().addWMSLayer("species_" + this.pid, layername, mapurl, 0.5f, null, legendurl, 15, null, null);
        MapLayer ml = this.getMapComposer().getMapLayer("species_" + this.pid);
        ml.setPid(this.pid);
        String infoUrl = CommonData.getSatServer() + "/output/maxent/" + this.pid + "/species.html";
        MapLayerMetadata md = ml.getMapLayerMetadata();
        md.setMoreInfo(infoUrl + "\nMaxent Output\npid:" + this.pid);
        md.setId(Long.valueOf(this.pid).longValue());
        try {
            String fileUrl = CommonData.getSatServer() + "/ws/download/" + this.pid;
            Filedownload.save((InputStream)new URL(fileUrl).openStream(), (String)"application/zip", (String)(layername.replaceAll(" ", "_") + ".zip"));
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Error generating download for prediction model pid=" + this.pid), (Throwable)ex);
        }
        this.detach();
    }

    private void loadMapSxS() {
        try {
            MapLayerMetadata md;
            String infoUrl;
            MapLayer ml;
            String layername;
            String legendurl;
            String mapurl;
            if (this.sxsOccurrenceDensity) {
                mapurl = CommonData.getGeoServer() + "/wms?service=WMS&version=1.1.0&request=GetMap&layers=ALA:odensity_" + this.pid + "&styles=odensity_" + this.pid + "&FORMAT=image%2Fpng";
                legendurl = CommonData.getGeoServer() + "/wms?REQUEST=GetLegendGraphic&VERSION=1.0.0&FORMAT=image/png&WIDTH=10&HEIGHT=1" + "&LAYER=ALA:odensity_" + this.pid + "&STYLE=odensity_" + this.pid;
                LOGGER.debug((Object)legendurl);
                layername = this.getMapComposer().getNextAreaLayerName("Occurrence Density");
                this.getMapComposer().addWMSLayer(this.pid + "_odensity", layername, mapurl, 0.5f, null, legendurl, 24, null, null);
                ml = this.getMapComposer().getMapLayer(this.pid + "_odensity");
                ml.setPid(this.pid + "_odensity");
                infoUrl = CommonData.getSatServer() + "/output/sitesbyspecies/" + this.pid + "/odensity_metadata.html";
                md = ml.getMapLayerMetadata();
                md.setMoreInfo(infoUrl + "\nOccurrence Density\npid:" + this.pid);
                md.setId(Long.valueOf(this.pid).longValue());
            }
            if (this.sxsSpeciesDensity) {
                mapurl = CommonData.getGeoServer() + "/wms?service=WMS&version=1.1.0&request=GetMap&layers=ALA:srichness_" + this.pid + "&styles=srichness_" + this.pid + "&FORMAT=image%2Fpng";
                legendurl = CommonData.getGeoServer() + "/wms?REQUEST=GetLegendGraphic&VERSION=1.0.0&FORMAT=image/png&WIDTH=10&HEIGHT=1" + "&LAYER=ALA:srichness_" + this.pid + "&STYLE=srichness_" + this.pid;
                LOGGER.debug((Object)legendurl);
                layername = this.getMapComposer().getNextAreaLayerName("Species Richness");
                this.getMapComposer().addWMSLayer(this.pid + "_srichness", layername, mapurl, 0.5f, null, legendurl, 25, null, null);
                ml = this.getMapComposer().getMapLayer(this.pid + "_srichness");
                ml.setPid(this.pid + "_srichness");
                infoUrl = CommonData.getSatServer() + "/output/sitesbyspecies/" + this.pid + "/srichness_metadata.html";
                md = ml.getMapLayerMetadata();
                md.setMoreInfo(infoUrl + "\nSpecies Richness\npid:" + this.pid);
                md.setId(Long.valueOf(this.pid).longValue());
            }
            String fileUrl = CommonData.getSatServer() + "/ws/download/" + this.pid;
            Filedownload.save((InputStream)new URL(fileUrl).openStream(), (String)"application/zip", (String)"sites_by_species.zip");
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Error generating download for sites by species pid=" + this.pid), (Throwable)ex);
        }
        this.detach();
    }

    boolean getParametersGdm() {
        try {
            HttpClient client = new HttpClient();
            GetMethod get = new GetMethod(CommonData.getSatServer().replace("/alaspatial", "") + "/output/gdm/" + this.pid + "/ala.properties");
            get.addRequestHeader("Accept", "text/plain");
            int result = client.executeMethod((HttpMethod)get);
            if (result == 200) {
                String slist = get.getResponseBodyAsString();
                for (String row : slist.split("\n")) {
                    if (!row.startsWith("envlist")) continue;
                    this.gdmEnvlist = row.replace("envlist=", "").split("\\\\:");
                }
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error getting gdm parameters pid=" + this.pid), (Throwable)e);
        }
        return false;
    }

    void openProgressBarGdm() {
        String[] envlist;
        for (String env : envlist = this.gdmEnvlist) {
            String mapurl = CommonData.getGeoServer() + "/wms?service=WMS&version=1.1.0&request=GetMap&layers=ALA:gdm_" + env + "Tran_" + this.pid + "&styles=alastyles&FORMAT=image%2Fpng";
            String legendurl = CommonData.getGeoServer() + "/wms?REQUEST=GetLegendGraphic&VERSION=1.0.0&FORMAT=image/png&WIDTH=10&HEIGHT=1" + "&LAYER=ALA:gdm_" + env + "Tran_" + this.pid + "&STYLE=alastyles";
            LOGGER.debug((Object)legendurl);
            String layername = "Tranformed " + CommonData.getLayerDisplayName((String)env);
            this.getMapComposer().addWMSLayer(this.pid + "_" + env, layername, mapurl, 0.5f, null, legendurl, 16, null, null);
            MapLayer ml = this.getMapComposer().getMapLayer(this.pid + "_" + env);
            ml.setPid(this.pid + "_" + env);
            String infoUrl = CommonData.getSatServer() + "/output/gdm/" + this.pid + "/gdm.html";
            MapLayerMetadata md = ml.getMapLayerMetadata();
            md.setMoreInfo(infoUrl + "\nGDM Output\npid:" + this.pid);
            md.setId(Long.valueOf(this.pid).longValue());
        }
        String fileUrl = CommonData.getSatServer() + "/ws/download/" + this.pid;
        try {
            Filedownload.save((InputStream)new URL(fileUrl).openStream(), (String)"application/zip", (String)("gdm_" + this.pid + ".zip"));
        }
        catch (Exception e) {
            LOGGER.error((Object)("error mapping gdm pid=" + this.pid), (Throwable)e);
        }
        this.detach();
    }

    static /* synthetic */ LanguagePack access$000(ImportAnalysisController x0) {
        return x0.languagePack;
    }

    static /* synthetic */ Textbox access$100(ImportAnalysisController x0) {
        return x0.refNum;
    }

    static /* synthetic */ Logger access$200() {
        return LOGGER;
    }
}

