/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.gazetteer;

import au.org.ala.spatial.util.CommonData;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public final class GazetteerPointSearch {
    private static final Logger LOGGER = Logger.getLogger(GazetteerPointSearch.class);

    private GazetteerPointSearch() {
    }

    public static Map<String, String> pointSearch(String lon, String lat, String layer, String geoserver) {
        try {
            String uri = CommonData.getLayersServer() + "/intersect/" + layer + "/" + lat + "/" + lon;
            HttpClient client = new HttpClient();
            GetMethod get = new GetMethod(uri);
            get.addRequestHeader("Accept", "application/json, text/javascript, */*");
            int result = client.executeMethod((HttpMethod)get);
            String slist = get.getResponseBodyAsString();
            LOGGER.debug((Object)("URI: " + uri));
            LOGGER.debug((Object)("result: " + result));
            LOGGER.debug((Object)("slist: " + slist));
            JSONParser jp = new JSONParser();
            JSONArray ja = (JSONArray)jp.parse(slist);
            if (ja != null && !ja.isEmpty()) {
                JSONObject jo = (JSONObject)ja.get(0);
                HashMap<String, String> map = new HashMap<String, String>();
                for (Object k : jo.keySet()) {
                    map.put((String)k, jo.get((Object)((String)k)) == null ? "" : jo.get((Object)((String)k)).toString());
                }
                return map;
            }
        }
        catch (Exception e1) {
            LOGGER.error((Object)"error with gaz point search", (Throwable)e1);
        }
        return null;
    }
}

