/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.gazetteer;

import au.org.ala.spatial.util.CommonData;
import java.util.Iterator;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.InputEvent;
import org.zkoss.zul.Combobox;
import org.zkoss.zul.Comboitem;

public class GazetteerAutoComplete
extends Combobox {
    private static final Logger LOGGER = Logger.getLogger(GazetteerAutoComplete.class);

    public GazetteerAutoComplete() {
        this.refresh("");
    }

    public void onChanging(InputEvent evt) {
        if (!evt.isChangingBySelectBack()) {
            this.refresh(evt.getValue());
        }
    }

    private void refresh(String val) {
        String searchString = val.trim().replaceAll("\\s+", "+");
        searchString = searchString.isEmpty() ? "a" : searchString;
        try {
            HttpClient client = new HttpClient();
            GetMethod get = new GetMethod(CommonData.getLayersServer() + "/search?limit=40&q=" + searchString);
            get.addRequestHeader("Accept", "application/json, text/javascript, */*");
            client.executeMethod((HttpMethod)get);
            String slist = get.getResponseBodyAsString();
            JSONParser jp = new JSONParser();
            JSONArray ja = (JSONArray)jp.parse(slist);
            if (ja == null) {
                return;
            }
            Iterator it = this.getItems().iterator();
            for (int i = 0; i < ja.size(); ++i) {
                Comboitem ci;
                JSONObject jo = (JSONObject)ja.get(i);
                String itemString = jo.get((Object)"name").toString();
                String description = (jo.containsKey((Object)"description") ? jo.get((Object)"description").toString() : "") + " (" + jo.get((Object)"fieldname") + ")";
                if (it != null && it.hasNext()) {
                    ci = (Comboitem)it.next();
                    ci.setLabel(itemString);
                    ci.setValue((Object)jo);
                    ci.setDescription(description);
                    continue;
                }
                it = null;
                ci = new Comboitem();
                ci.setLabel(itemString);
                ci.setValue((Object)jo);
                ci.setDescription(description);
                ci.setParent((Component)this);
            }
            while (it != null && it.hasNext()) {
                it.next();
                it.remove();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"error selecting gaz autocomplete item", (Throwable)e);
        }
    }
}

