/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.add.area;

import au.org.ala.spatial.dto.UserDataDTO;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.Zipper;
import au.org.emii.portal.composer.UtilityComposer;
import au.org.emii.portal.menu.MapLayer;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.operation.valid.IsValidOp;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.SLD;
import org.geotools.styling.Style;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Id;
import org.opengis.filter.identity.FeatureId;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.zkoss.util.media.Media;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zul.Button;
import org.zkoss.zul.Imagemap;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.Listhead;
import org.zkoss.zul.Listheader;
import org.zkoss.zul.Listitem;

public class AreaUploadShapefileWizardController
extends UtilityComposer {
    private static final Logger LOGGER = Logger.getLogger(AreaUploadShapefileWizardController.class);
    private Imagemap img;
    private Media media;
    private Listbox lAttributes;
    private Button btnRefresh;
    private Button btnNext;
    private SimpleFeatureSource source;
    private SimpleFeatureCollection features;
    private String file;
    private String layername;

    public void afterCompose() {
        super.afterCompose();
        Map args = Executions.getCurrent().getArg();
        this.layername = (String)args.get("layername");
        this.media = (Media)args.get("media");
        LOGGER.debug((Object)"Got media in wizard");
        LOGGER.debug((Object)("m.getName(): " + this.media.getName()));
        LOGGER.debug((Object)("getContentType: " + this.media.getContentType()));
        LOGGER.debug((Object)("getFormat: " + this.media.getFormat()));
        LOGGER.debug((Object)("Layer name: " + this.layername));
        this.processMedia();
    }

    private void processMedia() {
        Map input = Zipper.unzipFile((String)this.media.getName(), (InputStream)this.media.getStreamData(), (String)(CommonData.getSettings().getProperty("analysis_output_dir") + "layers/"));
        String type = "";
        if (input.containsKey("type")) {
            type = (String)input.get("type");
        }
        if (input.containsKey("file")) {
            this.file = (String)input.get("file");
        }
        if ("shp".equalsIgnoreCase(type)) {
            this.loadShape(this.file);
        } else {
            LOGGER.debug((Object)"Unknown file type. ");
            this.getMapComposer().showMessage(CommonData.lang((String)"error_unknown_file_type"));
        }
    }

    private void executeShapeImageRenderer(Filter filter) {
        try {
            LOGGER.debug((Object)"Generating image");
            SimpleFeatureCollection features1 = filter == null ? this.source.getFeatures() : this.source.getFeatures(filter);
            MapContent map = new MapContent();
            Style style = SLD.createSimpleStyle((FeatureType)this.source.getSchema());
            FeatureLayer layer = new FeatureLayer((FeatureCollection)features1, style);
            map.addLayer((Layer)layer);
            StreamingRenderer renderer = new StreamingRenderer();
            renderer.setMapContent(map);
            int imageWidth = 800;
            int imageHeight = 300;
            ReferencedEnvelope mapBounds = map.getMaxBounds();
            double heightToWidth = mapBounds.getSpan(1) / mapBounds.getSpan(0);
            Rectangle imageBounds = heightToWidth * (double)imageWidth > (double)imageHeight ? new Rectangle(0, 0, (int)Math.round((double)imageHeight / heightToWidth), imageHeight) : new Rectangle(0, 0, imageWidth, (int)Math.round((double)imageWidth * heightToWidth));
            BufferedImage image = new BufferedImage(imageBounds.width, imageBounds.height, 1);
            Graphics2D gr = image.createGraphics();
            gr.setPaint(Color.WHITE);
            gr.fill(imageBounds);
            renderer.paint(gr, imageBounds, mapBounds);
            this.img.setContent((RenderedImage)image);
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Unable to generate image for selected shapefile", (Throwable)e);
        }
    }

    private void loadShape(String filename) {
        CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
        try {
            FileDataStore store = FileDataStoreFinder.getDataStore((File)new File(filename));
            this.source = store.getFeatureSource();
            this.features = this.source.getFeatures();
            Listhead lhd = new Listhead();
            SimpleFeatureType schema = (SimpleFeatureType)this.features.getSchema();
            Listheader lh = new Listheader("id");
            lh.setParent((Component)lhd);
            for (AttributeType at : schema.getTypes()) {
                if (schema.getDescriptor(at.getName()) == null) continue;
                lh = new Listheader(at.getName().toString());
                lh.setParent((Component)lhd);
            }
            lhd.setParent((Component)this.lAttributes);
            SimpleFeatureIterator fi = this.features.features();
            while (fi.hasNext()) {
                SimpleFeature f = (SimpleFeature)fi.next();
                Listitem li = new Listitem();
                Listcell lc = new Listcell(f.getIdentifier().getID());
                lc.setParent((Component)li);
                for (AttributeType at : schema.getTypes()) {
                    if (schema.getDescriptor(at.getName()) == null) continue;
                    Object obj = f.getAttribute(at.getName());
                    String value = obj == null ? f.getID() : String.valueOf(obj);
                    lc = new Listcell(value);
                    lc.setParent((Component)li);
                }
                li.setValue((Object)f.getIdentifier());
                li.setParent((Component)this.lAttributes);
            }
            LOGGER.debug((Object)("features.size(): " + this.features.size()));
            if (this.features.size() > 1) {
                this.executeShapeImageRenderer(null);
            } else {
                LOGGER.debug((Object)"only a single feature, bypassing wizard...");
                fi = this.features.features();
                HashSet<FeatureId> ids = new HashSet<FeatureId>();
                ids.add(((SimpleFeature)fi.next()).getIdentifier());
                this.loadOnMap(ids);
                this.detach();
            }
            try {
                fi.close();
            }
            catch (Exception e) {}
        }
        catch (IOException e) {
            LOGGER.debug((Object)"IO Exception ", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Generic exception", (Throwable)e);
        }
    }

    public void onClick$btnSelectAll(Event event) {
        this.lAttributes.selectAll();
    }

    public void onClick$btnDeselectAll(Event event) {
        this.lAttributes.clearSelection();
    }

    public void onClick$btnRefresh(Event event) {
        Iterator it = this.lAttributes.getSelectedItems().iterator();
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
        HashSet<FeatureId> fids = new HashSet<FeatureId>();
        while (it.hasNext()) {
            Listitem li = (Listitem)it.next();
            fids.add(ff.featureId(li.getValue().toString()));
        }
        this.executeShapeImageRenderer((Filter)ff.id(fids));
    }

    public void onClick$btnNext(Event event) {
        try {
            CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
            Iterator it = this.lAttributes.getSelectedItems().iterator();
            HashSet<FeatureId> ids = new HashSet<FeatureId>();
            while (it.hasNext()) {
                Listitem li = (Listitem)it.next();
                ids.add((FeatureId)li.getValue());
            }
            this.loadOnMap(ids);
            this.detach();
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Error iterating thru' features", (Throwable)ex);
        }
    }

    private void loadOnMap(Set<FeatureId> ids) {
        try {
            String wkt;
            FilterFactory ff = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
            Id filter = ff.id(ids);
            SimpleFeatureType schema = (SimpleFeatureType)this.features.getSchema();
            CoordinateReferenceSystem dataCRS = schema.getCoordinateReferenceSystem();
            DefaultGeographicCRS wgsCRS = DefaultGeographicCRS.WGS84;
            boolean lenient = true;
            if (dataCRS == null) {
                dataCRS = DefaultGeographicCRS.WGS84;
            }
            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)dataCRS, (CoordinateReferenceSystem)wgsCRS, (boolean)lenient);
            SimpleFeatureCollection sff = this.source.getFeatures((Filter)filter);
            SimpleFeatureIterator fif = sff.features();
            StringBuilder sb = new StringBuilder();
            StringBuilder sbGeometryCollection = new StringBuilder();
            boolean isGeometryCollection = false;
            ArrayList geoms = new ArrayList();
            while (fif.hasNext()) {
                SimpleFeature f = (SimpleFeature)fif.next();
                LOGGER.debug((Object)("Selected Feature: " + f.getID() + " -> " + f.getAttribute("ECOREGION")));
                Geometry geom = (Geometry)f.getDefaultGeometry();
                geom = JTS.transform((Geometry)geom, (MathTransform)transform);
                String wktString = geom.toText();
                wktString = wktString.replaceAll(", ", ",");
                boolean valid = true;
                boolean multipolygon = false;
                boolean polygon = false;
                boolean geometrycollection = false;
                if (wktString.startsWith("MULTIPOLYGON ")) {
                    wktString = wktString.substring("MULTIPOLYGON ".length(), wktString.length() - 1);
                    multipolygon = true;
                } else if (wktString.startsWith("POLYGON ")) {
                    wktString = wktString.substring("POLYGON ".length());
                    polygon = true;
                } else if (wktString.startsWith("GEOMETRYCOLLECTION (")) {
                    wktString = wktString.substring("GEOMETRYCOLLECTION (".length(), wktString.length() - 1);
                    geometrycollection = true;
                    isGeometryCollection = true;
                } else {
                    valid = false;
                }
                if (!valid) continue;
                if (sb.length() > 0) {
                    sb.append(",");
                    sbGeometryCollection.append(",");
                }
                sb.append(wktString);
                if (multipolygon) {
                    sbGeometryCollection.append("MULTIPOLYGON").append("(").append(wktString.replace("(((", "(("));
                    if (wktString.endsWith(")))")) continue;
                    sbGeometryCollection.append(")");
                    continue;
                }
                if (polygon) {
                    sbGeometryCollection.append("POLYGON").append(wktString);
                    continue;
                }
                if (!geometrycollection) continue;
                sbGeometryCollection.append(wktString);
            }
            if (!isGeometryCollection) {
                if (!sb.toString().contains(")))")) {
                    sb.append(")");
                }
                wkt = "MULTIPOLYGON(" + sb.toString().replace("(((", "((");
            } else {
                sbGeometryCollection.append(")");
                wkt = "GEOMETRYCOLLECTION(" + sbGeometryCollection.toString();
                this.getMapComposer().showMessage("Shape is invalid: GEOMETRYCOLLECTION not supported.");
            }
            GeometryFactory gf = new GeometryFactory();
            gf.createGeometryCollection(GeometryFactory.toGeometryArray(geoms));
            String msg = "";
            boolean invalid = false;
            try {
                WKTReader wktReader = new WKTReader();
                Geometry g = wktReader.read(wkt);
                IsValidOp op = new IsValidOp(g);
                if (!op.isValid()) {
                    g = g.buffer(0.0);
                    op = new IsValidOp(g);
                }
                if (!op.isValid()) {
                    invalid = true;
                    LOGGER.warn((Object)(CommonData.lang((String)"error_wkt_invalid") + " " + op.getValidationError().getMessage()));
                    msg = op.getValidationError().getMessage();
                } else if (g.isRectangle()) {
                    Envelope envelope = g.getEnvelopeInternal();
                    String wkt2 = "POLYGON((" + envelope.getMinX() + " " + envelope.getMinY() + "," + envelope.getMaxX() + " " + envelope.getMinY() + "," + envelope.getMaxX() + " " + envelope.getMaxY() + "," + envelope.getMinX() + " " + envelope.getMaxY() + "," + envelope.getMinX() + " " + envelope.getMinY() + "))";
                    if (!wkt.equals(wkt2)) {
                        LOGGER.debug((Object)("NEW WKT for Rectangle: " + wkt));
                        msg = CommonData.lang((String)"error_wkt_anticlockwise");
                        invalid = true;
                    }
                }
                if (!invalid) {
                    invalid = !op.isValid();
                }
            }
            catch (ParseException parseException) {
                LOGGER.error((Object)"error testing validity of uploaded shape file wkt", (Throwable)parseException);
            }
            if (invalid) {
                this.getMapComposer().showMessage(CommonData.lang((String)"error_wkt_invalid") + " " + msg);
            } else {
                MapLayer mapLayer = this.getMapComposer().addWKTLayer(wkt, this.layername, this.layername);
                UserDataDTO ud = new UserDataDTO(this.layername);
                ud.setFilename(this.media.getName());
                ud.setUploadedTimeInMs(System.currentTimeMillis());
                ud.setType("shapefile");
                String metadata = "";
                metadata = metadata + "User uploaded Shapefile \n";
                metadata = metadata + "Name: " + ud.getName() + " <br />\n";
                metadata = metadata + "Filename: " + ud.getFilename() + " <br />\n";
                metadata = metadata + "Date: " + ud.getDisplayTime() + " <br />\n";
                metadata = metadata + "Selected polygons (fid): <br />\n";
                metadata = metadata + "<ul>";
                metadata = metadata + "</ul>";
                mapLayer.getMapLayerMetadata().setMoreInfo(metadata);
                this.getMapComposer().replaceWKTwithWMS(mapLayer);
            }
        }
        catch (IOException e) {
            LOGGER.debug((Object)"IO Error retrieving geometry", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Generic Error retrieving geometry", (Throwable)e);
        }
    }

    public void onClick$btnCancel(Event event) {
        this.detach();
    }
}

