/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.add.area;

import au.org.ala.spatial.composer.add.area.AreaToolComposer;
import au.org.ala.spatial.dto.UserDataDTO;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.ShapefileUtils;
import au.org.ala.spatial.util.Zipper;
import au.org.emii.portal.composer.MapComposer;
import au.org.emii.portal.menu.MapLayer;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import com.vividsolutions.jts.operation.valid.IsValidOp;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.geotools.kml.v22.KMLConfiguration;
import org.geotools.xml.Configuration;
import org.geotools.xml.Parser;
import org.opengis.feature.simple.SimpleFeature;
import org.xml.sax.SAXException;
import org.zkoss.util.media.Media;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.SuspendNotAllowedException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.ForwardEvent;
import org.zkoss.zk.ui.event.UploadEvent;
import org.zkoss.zul.Button;
import org.zkoss.zul.Textbox;
import org.zkoss.zul.Window;

/*
 * Exception performing whole class analysis ignored.
 */
public class AreaUploadShapefile
extends AreaToolComposer {
    private static final Logger LOGGER = Logger.getLogger(AreaUploadShapefile.class);
    private Button fileUpload;
    private Textbox txtLayerName;

    private static String getKMLPolygonAsWKT(String kmldata) {
        try {
            Parser parser = new Parser((Configuration)new KMLConfiguration());
            SimpleFeature f = (SimpleFeature)parser.parse((Reader)new StringReader(kmldata));
            Collection placemarks = (Collection)f.getAttribute("Feature");
            Geometry g = null;
            SimpleFeature sf = null;
            if (!placemarks.isEmpty() && !placemarks.isEmpty()) {
                sf = (SimpleFeature)placemarks.iterator().next();
                g = (Geometry)sf.getAttribute("Geometry");
            }
            if (g == null && sf != null) {
                placemarks = (Collection)sf.getAttribute("Feature");
                if (placemarks != null && !placemarks.isEmpty()) {
                    g = (Geometry)((SimpleFeature)placemarks.iterator().next()).getAttribute("Geometry");
                } else {
                    placemarks = (Collection)sf.getAttribute("Folder");
                    if (placemarks != null && !placemarks.isEmpty()) {
                        g = (Geometry)((SimpleFeature)placemarks.iterator().next()).getAttribute("Geometry");
                    }
                }
            }
            if (g != null) {
                WKTWriter wr = new WKTWriter();
                String wkt = wr.write(g);
                return wkt.replace(" (", "(").replace(", ", ",").replace(") ", ")");
            }
            return "";
        }
        catch (SAXException e) {
            LOGGER.error((Object)"KML spec parse error", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            LOGGER.error((Object)"error converting KML to WKT", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error((Object)"error reading KML", (Throwable)e);
        }
        return null;
    }

    public void afterCompose() {
        super.afterCompose();
        this.txtLayerName.setValue(this.getMapComposer().getNextAreaLayerName(CommonData.lang((String)"default_area_layer_name")));
        this.fileUpload.addEventListener("onUpload", (EventListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void onClick$btnOk(Event event) {
        this.onUpload$btnFileUpload(event);
        this.detach();
    }

    public void onClick$btnCancel(Event event) {
        this.detach();
    }

    public void onUpload$btnFileUpload(Event event) {
        block25: {
            UploadEvent ue = null;
            if ("onUpload".equals(event.getName())) {
                ue = (UploadEvent)event;
            } else if ("onForward".equals(event.getName())) {
                ue = (UploadEvent)((ForwardEvent)event).getOrigin();
            }
            if (ue == null) {
                LOGGER.debug((Object)"unable to upload file");
                return;
            }
            LOGGER.debug((Object)"fileUploaded()");
            try {
                Media m = ue.getMedia();
                LOGGER.debug((Object)("m.getName(): " + m.getName()));
                LOGGER.debug((Object)("getContentType: " + m.getContentType()));
                LOGGER.debug((Object)("getFormat: " + m.getFormat()));
                UserDataDTO ud = new UserDataDTO(this.txtLayerName.getValue());
                ud.setFilename(m.getName());
                byte[] kmldata = this.getKml(m);
                if (kmldata.length > 0) {
                    this.loadUserLayerKML(m.getName(), kmldata, ud);
                    break block25;
                }
                if (m.getName().toLowerCase().endsWith("zip")) {
                    HashMap<String, String> args = new HashMap<String, String>();
                    args.put("layername", this.txtLayerName.getValue());
                    args.put("media", (String)m);
                    String windowname = "areashapewizard";
                    if (this.getFellowIfAny(windowname) != null) {
                        this.getFellowIfAny(windowname).detach();
                    }
                    Window window = (Window)Executions.createComponents((String)"WEB-INF/zul/add/area/AreaUploadShapefileWizard.zul", (Component)this.getParent(), args);
                    try {
                        window.setParent(this.getParent());
                        window.doModal();
                    }
                    catch (SuspendNotAllowedException e) {}
                    break block25;
                }
                if (m.getName().toLowerCase().endsWith("zip_removeme")) {
                    Map input = Zipper.unzipFile((String)m.getName(), (InputStream)m.getStreamData(), (String)"/data/ala/runtime/output/layers/");
                    String type = "";
                    String file = "";
                    if (input.containsKey("type")) {
                        type = (String)input.get("type");
                    }
                    if (input.containsKey("file")) {
                        file = (String)input.get("file");
                    }
                    if ("shp".equalsIgnoreCase(type)) {
                        LOGGER.debug((Object)"Uploaded file is a shapefile. Loading...");
                        Map shape = ShapefileUtils.loadShapefile((File)new File(file));
                        if (shape == null) break block25;
                        String wkt = (String)shape.get("wkt");
                        LOGGER.debug((Object)"Got shapefile wkt...validating");
                        String msg = "";
                        boolean invalid = false;
                        try {
                            WKTReader wktReader = new WKTReader();
                            Geometry g = wktReader.read(wkt);
                            IsValidOp op = new IsValidOp(g);
                            if (!op.isValid()) {
                                g = g.buffer(0.0);
                                op = new IsValidOp(g);
                            }
                            if (!op.isValid()) {
                                invalid = true;
                                LOGGER.warn((Object)(CommonData.lang((String)"error_wkt_invalid") + " " + op.getValidationError().getMessage()));
                                msg = op.getValidationError().getMessage();
                            } else if (g.isRectangle()) {
                                Envelope envelope = g.getEnvelopeInternal();
                                String wkt2 = "POLYGON((" + envelope.getMinX() + " " + envelope.getMinY() + "," + envelope.getMaxX() + " " + envelope.getMinY() + "," + envelope.getMaxX() + " " + envelope.getMaxY() + "," + envelope.getMinX() + " " + envelope.getMaxY() + "," + envelope.getMinX() + " " + envelope.getMinY() + "))";
                                if (!wkt.equals(wkt2)) {
                                    LOGGER.debug((Object)("NEW WKT for Rectangle: " + wkt));
                                    msg = CommonData.lang((String)"error_wkt_anticlockwise");
                                    invalid = true;
                                }
                            }
                            if (!invalid) {
                                invalid = !op.isValid();
                            }
                        }
                        catch (ParseException parseException) {
                            LOGGER.error((Object)"error testing validity of uploaded shape file wkt", (Throwable)parseException);
                        }
                        if (invalid) {
                            this.ok = false;
                            this.getMapComposer().showMessage(CommonData.lang((String)"error_wkt_invalid") + " " + msg);
                        } else {
                            this.layerName = this.getMapComposer().getNextAreaLayerName(this.txtLayerName.getValue());
                            MapLayer mapLayer = this.getMapComposer().addWKTLayer(wkt, this.layerName, this.txtLayerName.getValue());
                            ud.setUploadedTimeInMs(System.currentTimeMillis());
                            ud.setType("shapefile");
                            String metadata = "";
                            metadata = metadata + "User uploaded Shapefile \n";
                            metadata = metadata + "Name: " + ud.getName() + " <br />\n";
                            metadata = metadata + "Filename: " + ud.getFilename() + " <br />\n";
                            metadata = metadata + "Date: " + ud.getDisplayTime() + " <br />\n";
                            mapLayer.getMapLayerMetadata().setMoreInfo(metadata);
                            this.ok = true;
                        }
                        break block25;
                    }
                    LOGGER.debug((Object)"Unknown file type. ");
                    this.getMapComposer().showMessage(CommonData.lang((String)"error_unknown_file_type"));
                    break block25;
                }
                LOGGER.debug((Object)"Unknown file type. ");
                this.getMapComposer().showMessage(CommonData.lang((String)"error_unknown_file_type"));
            }
            catch (Exception ex) {
                this.getMapComposer().showMessage(CommonData.lang((String)"error_upload_failed"));
                LOGGER.error((Object)"unable to load user area file: ", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getKml(Media m) {
        try {
            String kmlData = "";
            if (m.inMemory()) {
                kmlData = new String(m.getByteData());
            } else if (m.isBinary()) {
                InputStream data = m.getStreamData();
                if (data != null) {
                    StringWriter writer = new StringWriter();
                    char[] buffer = new char[1024];
                    Reader reader = null;
                    try {
                        int n;
                        reader = new BufferedReader(new InputStreamReader(data));
                        while ((n = reader.read(buffer)) != -1) {
                            ((Writer)writer).write(buffer, 0, n);
                        }
                    }
                    finally {
                        reader.close();
                        data.close();
                    }
                    kmlData = ((Object)writer).toString();
                }
            } else if ("txt".equals(m.getFormat())) {
                int n;
                StringWriter writer = new StringWriter();
                char[] buffer = new char[1024];
                Reader reader = m.getReaderData();
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                }
                kmlData = ((Object)writer).toString();
            }
            if (kmlData.contains("xml") && kmlData.contains("Document")) {
                return kmlData.getBytes();
            }
            return new byte[0];
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Exception checking if kml file", (Throwable)e);
            return new byte[0];
        }
    }

    public void loadUserLayerKML(String name, byte[] kmldata, UserDataDTO ud) {
        try {
            String id = String.valueOf(System.currentTimeMillis());
            String kmlpath = "/data/ala/runtime/output/layers/" + id + "/";
            File kmlfilepath = new File(kmlpath);
            kmlfilepath.mkdirs();
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(kmlfilepath.getAbsolutePath() + "/" + name)));
            String kmlstr = new String(kmldata);
            out.write(kmlstr);
            out.close();
            MapComposer mc = this.getMapComposer();
            this.layerName = mc.getMapLayer(this.txtLayerName.getValue()) == null ? this.txtLayerName.getValue() : mc.getNextAreaLayerName(this.txtLayerName.getValue());
            String wkt = AreaUploadShapefile.getKMLPolygonAsWKT((String)kmlstr);
            if (wkt != null && wkt.length() == 0) {
                this.getMapComposer().showMessage("Failed to find the area in this KML file. \r\n\r\nKML file must have a single placemark within no more than 1 folder.");
                return;
            }
            if (wkt == null) {
                this.getMapComposer().showMessage("Failed to parse this KML file. \r\n\r\nTry importing a Shapefile or WKT instead.");
                return;
            }
            boolean invalid = false;
            String msg = "";
            try {
                WKTReader wktReader = new WKTReader();
                Geometry g = wktReader.read(wkt);
                IsValidOp op = new IsValidOp(g);
                if (!op.isValid()) {
                    g = g.buffer(0.0);
                    op = new IsValidOp(g);
                }
                if (!op.isValid()) {
                    invalid = true;
                    LOGGER.warn((Object)(CommonData.lang((String)"error_wkt_invalid") + " " + op.getValidationError().getMessage()));
                    msg = op.getValidationError().getMessage();
                } else if (g.isRectangle()) {
                    Envelope envelope = g.getEnvelopeInternal();
                    String wkt2 = "POLYGON((" + envelope.getMinX() + " " + envelope.getMinY() + "," + envelope.getMaxX() + " " + envelope.getMinY() + "," + envelope.getMaxX() + " " + envelope.getMaxY() + "," + envelope.getMinX() + " " + envelope.getMaxY() + "," + envelope.getMinX() + " " + envelope.getMinY() + "))";
                    if (!wkt.equals(wkt2)) {
                        LOGGER.debug((Object)("NEW WKT for Rectangle: " + wkt));
                        msg = CommonData.lang((String)"error_wkt_anticlockwise");
                        invalid = true;
                    }
                }
                if (!invalid) {
                    invalid = !op.isValid();
                }
            }
            catch (ParseException parseException) {
                LOGGER.error((Object)CommonData.lang((String)"error_wkt_invalid"), (Throwable)parseException);
            }
            if (invalid) {
                this.ok = false;
                this.getMapComposer().showMessage(CommonData.lang((String)"error_wkt_invalid") + " " + msg);
            } else {
                MapLayer mapLayer = mc.addWKTLayer(wkt, this.layerName, this.txtLayerName.getValue());
                ud.setUploadedTimeInMs(Long.parseLong(id));
                ud.setType("kml");
                String metadata = "";
                metadata = metadata + "User uploaded KML area \n";
                metadata = metadata + "Name: " + ud.getName() + " <br />\n";
                metadata = metadata + "Filename: " + ud.getFilename() + " <br />\n";
                metadata = metadata + "Date: " + ud.getDisplayTime() + " <br />\n";
                mapLayer.getMapLayerMetadata().setMoreInfo(metadata);
                if (mapLayer == null) {
                    LOGGER.debug((Object)("The layer " + name + " couldnt be created"));
                    mc.showMessage(mc.getLanguagePack().getLang("ext_layer_creation_failure"));
                } else {
                    this.ok = true;
                    mc.addUserDefinedLayerToMenu(mapLayer, true);
                }
            }
        }
        catch (IOException e) {
            this.getMapComposer().showMessage(CommonData.lang((String)"error_upload_failed"));
            LOGGER.debug((Object)"unable to load user kml: ", (Throwable)e);
        }
    }
}

