/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.add.area;

import au.org.ala.spatial.composer.add.AddFacetController;
import au.org.ala.spatial.composer.tool.ToolComposer;
import au.org.ala.spatial.logger.RemoteLogger;
import au.org.ala.spatial.util.BiocacheQuery;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.Query;
import au.org.ala.spatial.util.QueryUtil;
import au.org.ala.spatial.util.Util;
import au.org.emii.portal.composer.UtilityComposer;
import au.org.emii.portal.menu.MapLayer;
import au.org.emii.portal.menu.SelectedArea;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;

public class AreaToolComposer
extends UtilityComposer {
    private static final Logger LOGGER = Logger.getLogger(AreaToolComposer.class);
    protected boolean ok = false;
    protected String layerName;
    private boolean isAnalysisChild = false;
    private boolean isFacetChild = false;
    private RemoteLogger remoteLogger;
    private ToolComposer analysisParent = null;
    private AddFacetController facetParent = null;
    private Map winProps = null;

    public void afterCompose() {
        super.afterCompose();
        Component parent = this.getParent();
        this.winProps = Executions.getCurrent().getArg();
        if ("addtoolwindow".equals(parent.getId())) {
            this.analysisParent = (ToolComposer)this.getParent();
            this.isAnalysisChild = true;
        } else if ("addfacetwindow".equals(parent.getId())) {
            this.facetParent = (AddFacetController)this.getParent();
            this.isFacetChild = true;
        } else {
            this.isAnalysisChild = false;
            this.isFacetChild = false;
        }
    }

    public void detach() {
        super.detach();
        String parentname = (String)this.winProps.get("parentname");
        String areatype = (String)this.getMapComposer().getAttribute("addareawindow");
        if (areatype == null) {
            areatype = "";
        } else {
            if (areatype.startsWith("ci")) {
                areatype = areatype.substring(2);
            }
            areatype = areatype.startsWith("Upload") ? "Import - Area " + areatype.substring(6) : (areatype.startsWith("WKT") ? "Import - Area WKT" : "Area - " + areatype);
        }
        MapLayer ml = this.getMapComposer().getMapLayer(this.layerName);
        if (this.ok && ml != null) {
            String displayName = ml.getDisplayName();
            String fromLayer = (String)this.getMapComposer().getAttribute("mappolygonlayer");
            String activeLayerName = (String)this.getMapComposer().getAttribute("activeLayerName");
            if (fromLayer == null) {
                fromLayer = "";
            } else {
                this.getMapComposer().removeAttribute("mappolygonlayer");
            }
            if (activeLayerName == null) {
                activeLayerName = "";
            } else {
                this.getMapComposer().removeAttribute("activeLayerName");
            }
            this.remoteLogger.logMapArea(this.layerName + (!this.layerName.equalsIgnoreCase(displayName) ? " (" + displayName + ")" : ""), areatype, ml.testWKT(), activeLayerName, fromLayer);
            this.getMapComposer().warnForLargeWKT(ml);
            this.getMapComposer().replaceWKTwithWMS(ml);
        }
        if (this.isAnalysisChild) {
            this.analysisParent.resetWindow(this.ok ? this.layerName : null);
            try {
                this.remoteLogger.logMapArea(this.layerName, areatype, this.getMapComposer().getMapLayer(this.layerName).testWKT());
            }
            catch (Exception e) {
                LOGGER.error((Object)"error with remote logging", (Throwable)e);
            }
        } else if (this.isFacetChild) {
            this.facetParent.resetWindow(this.ok ? this.layerName : null);
            try {
                this.remoteLogger.logMapArea(this.layerName, areatype, this.getMapComposer().getMapLayer(this.layerName).testWKT());
            }
            catch (Exception e) {
                LOGGER.error((Object)"error with remote logging", (Throwable)e);
            }
        } else if (parentname != null && "AddSpeciesInArea".equals(parentname) && this.ok) {
            MapLayer mapLayer = this.getMapComposer().getMapLayer(this.layerName);
            Query q = null;
            if (this.winProps.get("query") != null) {
                q = (Query)this.winProps.get("query");
                List facets = mapLayer.getFacets();
                String wkt = facets == null ? mapLayer.getWKT() : null;
                SelectedArea sa = new SelectedArea(this.getMapComposer().getMapLayer(this.layerName), wkt);
                q = QueryUtil.queryFromSelectedArea((Query)q, (SelectedArea)sa, (boolean)true, null);
            }
            if (this.winProps.get("query") == null) {
                this.mapSpeciesInArea();
            } else if (this.winProps.get("filter") != null && ((Boolean)this.winProps.get("filter")).booleanValue()) {
                ml = this.getMapComposer().mapSpecies(q, (String)this.winProps.get("name"), (String)this.winProps.get("s"), ((Integer)this.winProps.get("featureCount")).intValue(), ((Integer)this.winProps.get("type")).intValue(), null, -1, 3, 0.6f, Util.nextColour(), false);
                ml.getMapLayerMetadata().setMoreInfo((String)this.winProps.get("metadata"));
            } else if (this.winProps.get("filterGrid") != null && ((Boolean)this.winProps.get("filterGrid")).booleanValue()) {
                ml = this.getMapComposer().mapSpecies(q, (String)this.winProps.get("name"), (String)this.winProps.get("s"), ((Integer)this.winProps.get("featureCount")).intValue(), ((Integer)this.winProps.get("type")).intValue(), null, -1, 3, 0.6f, Util.nextColour(), false);
                ml.getMapLayerMetadata().setMoreInfo((String)this.winProps.get("metadata"));
            } else if (this.winProps.get("byLsid") != null && ((Boolean)this.winProps.get("byLsid")).booleanValue()) {
                ml = this.getMapComposer().mapSpecies(q, (String)this.winProps.get("name"), (String)this.winProps.get("s"), ((Integer)this.winProps.get("featureCount")).intValue(), ((Integer)this.winProps.get("type")).intValue(), null, -1, 3, 0.6f, Util.nextColour(), false);
                ml.getMapLayerMetadata().setMoreInfo((String)this.winProps.get("metadata"));
            } else {
                this.getMapComposer().mapSpecies(q, (String)this.winProps.get("taxon"), (String)this.winProps.get("rank"), 0, 21, null, -1, 3, 0.6f, Util.nextColour(), false);
            }
            if (this.getMapComposer().getMapLayer(this.layerName) != null) {
                String displayName = this.getMapComposer().getMapLayer(this.layerName).getDisplayName();
                this.remoteLogger.logMapArea(this.layerName + (!this.layerName.equalsIgnoreCase(displayName) ? " (" + displayName + ")" : ""), areatype, null);
            }
        }
    }

    void mapSpeciesInArea() {
        List layers = this.getMapComposer().getPolygonLayers();
        if (layers == null || layers.isEmpty()) {
            return;
        }
        try {
            BiocacheQuery sq;
            if (((MapLayer)layers.get(0)).getFacets() != null) {
                sq = new BiocacheQuery(null, null, null, ((MapLayer)layers.get(0)).getFacets(), true, null);
            } else {
                String wkt = ((MapLayer)layers.get(0)).getWKT();
                sq = new BiocacheQuery(null, wkt, null, null, true, null);
            }
            int resultsCountOccurrences = sq.getOccurrenceCount();
            if (resultsCountOccurrences > 0 && resultsCountOccurrences <= Integer.parseInt(CommonData.getSettings().getProperty("max_record_count_map"))) {
                String activeAreaLayerName = ((MapLayer)layers.get(0)).getDisplayName();
                this.getMapComposer().mapSpecies((Query)sq, CommonData.lang((String)"occurrences_in_area_prefix") + " " + activeAreaLayerName, "species", resultsCountOccurrences, 21, null, -1, 3, 0.6f, Util.nextColour(), false);
            } else {
                this.getMapComposer().showMessage(CommonData.lang((String)"error_too_many_occurrences_for_mapping").replace("<counted_occurrences>", resultsCountOccurrences + "").replace("<max_occurrences>", CommonData.getSettings().getProperty("max_record_count_map")));
            }
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)"error mapping species in an area", (Throwable)e);
        }
    }
}

