/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.add.area;

import au.org.ala.spatial.composer.add.area.AreaToolComposer;
import au.org.ala.spatial.composer.gazetteer.GazetteerAutoComplete;
import au.org.ala.spatial.util.CommonData;
import org.apache.log4j.Logger;
import org.json.simple.JSONObject;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zul.Button;
import org.zkoss.zul.Checkbox;
import org.zkoss.zul.Comboitem;
import org.zkoss.zul.Doublebox;
import org.zkoss.zul.Hbox;

public class AreaRegionSelection
extends AreaToolComposer {
    private static final Logger LOGGER = Logger.getLogger(AreaRegionSelection.class);
    private Button btnOk;
    private Hbox hbRadius;
    private Doublebox dRadius;
    private Checkbox displayAsWms;
    private GazetteerAutoComplete gazetteerAuto;

    public void onClick$btnOk(Event event) {
        Comboitem ci = this.gazetteerAuto.getSelectedItem();
        if (!this.validate()) {
            return;
        }
        if (ci == null) {
            return;
        }
        JSONObject jo = (JSONObject)ci.getValue();
        this.getMapComposer().addObjectByPid(jo.get((Object)"pid").toString(), ci.getLabel(), this.dRadius.getValue().doubleValue());
        this.ok = true;
        this.detach();
    }

    public void onClick$btnCancel(Event event) {
        this.detach();
    }

    public void onChange$gazetteerAuto() {
        Comboitem ci = this.gazetteerAuto.getSelectedItem();
        if (ci == null) {
            String txt = this.gazetteerAuto.getText();
            for (Object o : this.gazetteerAuto.getItems()) {
                Comboitem c = (Comboitem)o;
                if (!c.getLabel().equalsIgnoreCase(txt)) continue;
                this.gazetteerAuto.setSelectedItem(c);
                ci = c;
                break;
            }
        }
        if (ci == null) {
            this.btnOk.setDisabled(true);
        } else {
            this.btnOk.setDisabled(false);
            boolean point = false;
            if (ci.getDescription() != null && ci.getDescription().contains("Gazetteer")) {
                String[] s = ci.getDescription().split(",");
                try {
                    double lat = Double.parseDouble(s[2].trim());
                    point = !Double.isNaN(lat);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (point) {
                this.hbRadius.setVisible(true);
            } else {
                this.hbRadius.setVisible(false);
            }
        }
    }

    private boolean validate() {
        StringBuilder sb = new StringBuilder();
        double radius = this.dRadius.getValue();
        if (radius <= 0.0) {
            sb.append("\n").append(CommonData.lang((String)"error_invalid_radius"));
        }
        if (sb.length() > 0) {
            this.getMapComposer().showMessage(sb.toString());
        }
        return sb.length() == 0;
    }
}

