/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.add.area;

import au.org.ala.spatial.composer.add.area.AreaToolComposer;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.LayersUtil;
import au.org.ala.spatial.util.Util;
import au.org.emii.portal.composer.MapComposer;
import au.org.emii.portal.menu.MapLayer;
import au.org.emii.portal.value.BoundingBox;
import org.apache.log4j.Logger;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zul.Button;
import org.zkoss.zul.Doublebox;
import org.zkoss.zul.Textbox;

public class AreaRadiusManual
extends AreaToolComposer {
    private static final Logger LOGGER = Logger.getLogger(AreaRadiusManual.class);
    private Doublebox dLongitude;
    private Doublebox dLatitude;
    private Doublebox dRadius;
    private Textbox txtLayerName;
    private Button btnOk;
    private Button btnClear;
    private Textbox displayGeom;

    public void afterCompose() {
        super.afterCompose();
        this.txtLayerName.setValue(this.getMapComposer().getNextAreaLayerName(CommonData.lang((String)"default_area_layer_name")));
        BoundingBox bb = this.getMapComposer().getLeftmenuSearchComposer().getViewportBoundingBox();
        this.dLongitude.setValue((double)Math.round(((double)bb.getMinLongitude() + (double)(bb.getMaxLongitude() - bb.getMinLongitude()) / 2.0) * 100.0) / 100.0);
        this.dLatitude.setValue((double)Math.round(((double)bb.getMinLatitude() + (double)(bb.getMaxLatitude() - bb.getMinLatitude()) / 2.0) * 100.0) / 100.0);
    }

    public void onClick$btnOk(Event event) {
        if (!this.validate()) {
            return;
        }
        this.createCircle();
        this.ok = true;
        this.detach();
    }

    public void onClick$btnCancel(Event event) {
        this.detach();
    }

    public void createCircle() {
        String wkt = Util.createCircleJs((double)this.dLongitude.getValue(), (double)this.dLatitude.getValue(), (double)(this.dRadius.getValue() * 1000.0));
        if (!"none".equalsIgnoreCase(wkt)) {
            try {
                MapComposer mc = this.getMapComposer();
                this.layerName = mc.getMapLayer(this.txtLayerName.getValue()) == null ? this.txtLayerName.getValue() : mc.getNextAreaLayerName(this.txtLayerName.getValue());
                MapLayer mapLayer = mc.addWKTLayer(wkt, this.layerName, this.txtLayerName.getValue());
                mapLayer.getMapLayerMetadata().setMoreInfo(LayersUtil.getMetadata((String)(this.dRadius.getText() + "km radius around longitude " + this.dLongitude.getText() + ", latitude " + this.dLatitude.getText())));
                this.displayGeom.setText(wkt);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Error adding WKT layer", (Throwable)e);
            }
        }
    }

    private boolean validate() {
        double radius;
        double latitude;
        StringBuilder sb = new StringBuilder();
        double longitude = this.dLongitude.getValue();
        if (longitude < -180.0 || longitude > 360.0) {
            sb.append("\n").append(CommonData.lang((String)"error_invalid_longitude"));
        }
        if ((latitude = this.dLatitude.getValue().doubleValue()) < -90.0 || latitude > 90.0) {
            sb.append("\n").append(CommonData.lang((String)"error_invalid_latitude"));
        }
        if ((radius = this.dRadius.getValue().doubleValue()) <= 0.0) {
            sb.append("\n").append(CommonData.lang((String)"error_invalid_radius"));
        }
        if (sb.length() > 0) {
            this.getMapComposer().showMessage(sb.toString());
        }
        return sb.length() == 0;
    }
}

