/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.add.area;

import au.org.ala.spatial.composer.add.area.AreaToolComposer;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.LayersUtil;
import au.org.emii.portal.composer.MapComposer;
import au.org.emii.portal.menu.MapLayer;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.operation.valid.IsValidOp;
import org.apache.log4j.Logger;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zul.Button;
import org.zkoss.zul.Label;
import org.zkoss.zul.Textbox;

public class AreaPolygon
extends AreaToolComposer {
    private static final Logger LOGGER = Logger.getLogger(AreaPolygon.class);
    private Button btnNext;
    private Label invalidWKT;
    private Textbox txtLayerName;
    private Button btnClear;
    private Textbox displayGeom;

    public void afterCompose() {
        super.afterCompose();
        this.txtLayerName.setValue(this.getMapComposer().getNextAreaLayerName(CommonData.lang((String)"default_area_layer_name")));
    }

    public void onClick$btnNext(Event event) {
        this.getMapComposer().getMapLayer(this.layerName).setDisplayName(this.txtLayerName.getValue());
        this.getMapComposer().redrawLayersList();
        this.ok = true;
        this.detach();
    }

    public void onClick$btnClear(Event event) {
        MapComposer mc = this.getMapComposer();
        if (this.layerName != null && mc.getMapLayer(this.layerName) != null) {
            mc.removeLayer(this.layerName);
        }
        String script = mc.getOpenLayersJavascript().addPolygonDrawingTool();
        mc.getOpenLayersJavascript().execute(mc.getOpenLayersJavascript().getIFrameReferences() + script);
        this.displayGeom.setValue("");
        this.btnNext.setDisabled(true);
        this.btnClear.setDisabled(true);
        this.invalidWKT.setValue("");
    }

    public void onClick$btnCancel(Event event) {
        MapComposer mc = this.getMapComposer();
        if (this.layerName != null && mc.getMapLayer(this.layerName) != null) {
            mc.removeLayer(this.layerName);
        }
        this.detach();
    }

    public void onSelectionGeom(Event event) {
        String selectionGeom = (String)event.getData();
        try {
            String wkt = "";
            if (selectionGeom.contains("NaN NaN")) {
                this.displayGeom.setValue("");
            } else {
                wkt = selectionGeom;
                this.displayGeom.setValue(wkt);
            }
            MapComposer mc = this.getMapComposer();
            if (wkt.length() > 0) {
                this.layerName = mc.getMapLayer(this.txtLayerName.getValue()) == null ? this.txtLayerName.getValue() : mc.getNextAreaLayerName(this.txtLayerName.getValue());
                MapLayer mapLayer = mc.addWKTLayer(wkt, this.layerName, this.txtLayerName.getValue());
                mapLayer.getMapLayerMetadata().setMoreInfo(LayersUtil.getMetadataForWKT((String)CommonData.lang((String)"metadata_polygon"), (String)wkt));
                if (!this.validWKT(wkt)) {
                    this.btnNext.setDisabled(true);
                    this.btnClear.setDisabled(false);
                } else {
                    this.btnClear.setDisabled(false);
                    this.btnNext.setDisabled(false);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"error mapping user polygon", (Throwable)e);
            this.btnNext.setDisabled(true);
            this.btnClear.setDisabled(false);
        }
    }

    public boolean validWKT(String wkt) {
        if (wkt.replaceAll(" ", "").isEmpty()) {
            this.invalidWKT.setValue("WKT is Invalid");
            return false;
        }
        this.invalidWKT.setValue("");
        try {
            WKTReader wktReader = new WKTReader();
            Geometry g = wktReader.read(wkt);
            IsValidOp op = new IsValidOp(g);
            if (!op.isValid()) {
                g = g.buffer(0.0);
                op = new IsValidOp(g);
            }
            if (!op.isValid()) {
                this.invalidWKT.setValue(CommonData.lang((String)"error_wkt_invalid") + " " + op.getValidationError().getMessage());
                LOGGER.warn((Object)("WKT is invalid." + op.getValidationError().getMessage()));
            } else if (g.isRectangle()) {
                Envelope envelope = g.getEnvelopeInternal();
                String wkt2 = "POLYGON((" + envelope.getMinX() + " " + envelope.getMinY() + "," + envelope.getMaxX() + " " + envelope.getMinY() + "," + envelope.getMaxX() + " " + envelope.getMaxY() + "," + envelope.getMinX() + " " + envelope.getMaxY() + "," + envelope.getMinX() + " " + envelope.getMinY() + "))";
                if (!wkt.equals(wkt2)) {
                    LOGGER.debug((Object)("NEW WKT for Rectangle: " + wkt));
                    this.invalidWKT.setValue(CommonData.lang((String)"error_wkt_rectangle_wrong_order"));
                    this.displayGeom.setValue(wkt2);
                    return false;
                }
            }
            return op.isValid();
        }
        catch (ParseException parseException) {
            this.invalidWKT.setValue(CommonData.lang((String)"error_wkt_invalid") + " " + parseException.getMessage());
            return false;
        }
    }
}

