/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.add.area;

import au.org.ala.spatial.composer.add.area.AreaToolComposer;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.LayersUtil;
import au.org.ala.spatial.util.Util;
import au.org.emii.portal.composer.MapComposer;
import au.org.emii.portal.menu.MapLayer;
import org.apache.log4j.Logger;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zul.Button;
import org.zkoss.zul.Textbox;

public class AreaPointAndRadius
extends AreaToolComposer {
    private static final Logger LOGGER = Logger.getLogger(AreaPointAndRadius.class);
    private Textbox txtLayerName;
    private Button btnNext;
    private Button btnClear;
    private Textbox displayGeom;

    public void afterCompose() {
        super.afterCompose();
        this.txtLayerName.setValue(this.getMapComposer().getNextAreaLayerName(CommonData.lang((String)"default_area_layer_name")));
    }

    public void onClick$btnNext(Event event) {
        this.getMapComposer().getMapLayer(this.layerName).setDisplayName(this.txtLayerName.getValue());
        this.getMapComposer().redrawLayersList();
        this.ok = true;
        this.detach();
    }

    public void onClick$btnClear(Event event) {
        MapComposer mc = this.getMapComposer();
        if (this.layerName != null && mc.getMapLayer(this.layerName) != null) {
            mc.removeLayer(this.layerName);
        }
        String script = mc.getOpenLayersJavascript().addRadiusDrawingTool();
        mc.getOpenLayersJavascript().execute(mc.getOpenLayersJavascript().getIFrameReferences() + script);
        this.displayGeom.setText("");
        this.btnNext.setDisabled(true);
        this.btnClear.setDisabled(true);
    }

    public void onClick$btnCancel(Event event) {
        MapComposer mc = this.getMapComposer();
        if (this.layerName != null && mc.getMapLayer(this.layerName) != null) {
            mc.removeLayer(this.layerName);
        }
        this.detach();
    }

    public void onSelectionGeom(Event event) {
        String selectionGeom = (String)event.getData();
        try {
            String wkt = "";
            if (selectionGeom.contains("NaN NaN")) {
                this.displayGeom.setValue("");
            } else if (selectionGeom.startsWith("LAYER(")) {
                String v = selectionGeom.replace("LAYER(", "");
                v = v.substring(0, v.length() - 1);
                wkt = Util.wktFromJSON((String)this.getMapComposer().getMapLayer(v).getGeoJSON());
                this.displayGeom.setValue(wkt);
            } else {
                wkt = selectionGeom;
                this.displayGeom.setValue(wkt);
            }
            MapComposer mc = this.getMapComposer();
            if (wkt.length() > 0) {
                this.layerName = mc.getMapLayer(this.txtLayerName.getValue()) == null ? this.txtLayerName.getValue() : mc.getNextAreaLayerName(this.txtLayerName.getValue());
                MapLayer mapLayer = mc.addWKTLayer(wkt, this.layerName, this.txtLayerName.getValue());
                mapLayer.getMapLayerMetadata().setMoreInfo(LayersUtil.getMetadataForWKT((String)CommonData.lang((String)"metadata_point_and_radius"), (String)wkt));
            }
            this.btnNext.setDisabled(false);
            this.btnClear.setDisabled(false);
        }
        catch (Exception e) {
            LOGGER.error((Object)"error mapping point and radius", (Throwable)e);
        }
    }
}

