/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.add.area;

import au.org.ala.legend.Facet;
import au.org.ala.spatial.composer.add.area.AreaToolComposer;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.Util;
import au.org.emii.portal.composer.MapComposer;
import au.org.emii.portal.menu.MapLayer;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.util.GeometryCombiner;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.log4j.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zul.Button;
import org.zkoss.zul.Checkbox;
import org.zkoss.zul.Textbox;
import org.zkoss.zul.Vbox;

public class AreaMerge
extends AreaToolComposer {
    private static final Logger LOGGER = Logger.getLogger(AreaMerge.class);
    private Textbox txtLayerName;
    private Button btnOk;
    private Vbox vboxAreas;

    public void afterCompose() {
        super.afterCompose();
        this.btnOk.setDisabled(false);
        this.txtLayerName.setValue(this.getMapComposer().getNextAreaLayerName(CommonData.lang((String)"default_area_layer_name")));
        List layers = this.getMapComposer().getPolygonLayers();
        for (int i = 0; i < layers.size(); ++i) {
            MapLayer ml = (MapLayer)layers.get(i);
            boolean isGrid = false;
            if (ml.getFacets() != null && ml.testWKT() != null && ml.getWKT().startsWith("ENVELOPE")) {
                String wkt = ml.getWKT();
                String fid = wkt.substring(9, wkt.indexOf(44));
                if (fid.startsWith("cl")) {
                    JSONArray ja = CommonData.getLayerListJSONArray();
                    for (int j = 0; j < ja.size() && !isGrid; ++j) {
                        JSONObject jo = (JSONObject)ja.get(j);
                        if (!jo.get((Object)"id").toString().equalsIgnoreCase(fid) || !jo.containsKey((Object)"fields")) continue;
                        JSONArray fields = (JSONArray)jo.get((Object)"fields");
                        for (int k = 0; k < fields.size() && !isGrid; ++k) {
                            JSONObject field = (JSONObject)fields.get(k);
                            if (!"a".equalsIgnoreCase(field.get((Object)"type").toString()) && !"b".equalsIgnoreCase(field.get((Object)"type").toString())) continue;
                            isGrid = true;
                        }
                    }
                } else {
                    isGrid = true;
                }
            }
            if (ml.getFacets() != null && isGrid) continue;
            Checkbox cb = new Checkbox();
            cb.setLabel(((MapLayer)layers.get(i)).getDisplayName());
            cb.setValue(layers.get(i));
            cb.setParent((Component)this.vboxAreas);
        }
    }

    public void onClick$btnOk(Event event) {
        if (!this.validate()) {
            this.getMapComposer().showMessage(CommonData.lang((String)"error_not_enough_areas_for_merging"));
            return;
        }
        this.mergeAreas();
        this.ok = true;
        this.detach();
    }

    public void onClick$btnCancel(Event event) {
        this.detach();
    }

    private boolean validate() {
        int count = 0;
        for (int i = 0; i < this.vboxAreas.getChildren().size(); ++i) {
            if (!((Checkbox)this.vboxAreas.getChildren().get(i)).isChecked()) continue;
            ++count;
        }
        return count >= 2;
    }

    void mergeAreas() {
        ArrayList facets = new ArrayList();
        ArrayList<Geometry> wkt = new ArrayList<Geometry>();
        WKTReader wktReader = new WKTReader();
        String layerDisplayNames = "";
        for (int i = 0; i < this.vboxAreas.getChildren().size(); ++i) {
            Geometry g;
            Checkbox cb = (Checkbox)this.vboxAreas.getChildren().get(i);
            if (!cb.isChecked()) continue;
            MapLayer ml = (MapLayer)cb.getValue();
            if (layerDisplayNames.length() > 0) {
                layerDisplayNames = layerDisplayNames + ", ";
            }
            layerDisplayNames = layerDisplayNames + ml.getDisplayName();
            if (ml != null) {
                if (ml.getFacets() != null) {
                    facets.addAll(ml.getFacets());
                }
                try {
                    String w = ml.getWKT();
                    if (w.startsWith("ENVELOPE")) {
                        String pid = w.substring(w.indexOf(44) + 1, w.length() - 1);
                        w = Util.readUrl((String)(CommonData.getLayersServer() + "/shape/wkt/" + pid));
                    }
                    if ((g = wktReader.read(w)) == null) continue;
                    wkt.add(g);
                }
                catch (ParseException e) {
                    LOGGER.error((Object)("cannot parse WKT for map layer: " + ml.getDisplayName() + " for WKT: " + ml.getWKT()));
                }
                continue;
            }
            String swkt = null;
            if (CommonData.getSettings().getProperty("default.name").equalsIgnoreCase(cb.getLabel())) {
                swkt = CommonData.getSettings().getProperty("default.wkt");
            } else if ("Current Extent".equalsIgnoreCase(cb.getLabel())) {
                swkt = this.getMapComposer().getViewArea();
            } else {
                LOGGER.error((Object)("cannot determine what this checked area is: " + cb.getLabel()));
            }
            if (swkt == null) continue;
            try {
                g = wktReader.read(swkt);
                if (g == null) continue;
                wkt.add(g);
                continue;
            }
            catch (ParseException e) {
                LOGGER.error((Object)("cannot parse WKT for map layer: " + ml.getDisplayName() + " for WKT: " + swkt));
            }
        }
        Geometry geometry = null;
        if (!wkt.isEmpty()) {
            geometry = (Geometry)wkt.get(0);
            for (int i = 1; i < wkt.size(); ++i) {
                geometry = GeometryCombiner.combine((Geometry)geometry, (Geometry)((Geometry)wkt.get(i)));
            }
        }
        String finalWkt = geometry == null ? null : geometry.toString();
        MapComposer mc = this.getMapComposer();
        this.layerName = mc.getMapLayer(this.txtLayerName.getValue()) == null ? this.txtLayerName.getValue() : mc.getNextAreaLayerName(this.txtLayerName.getValue());
        MapLayer mapLayer = mc.addWKTLayer(finalWkt, this.layerName, this.txtLayerName.getValue());
        if (wkt.size() == facets.size()) {
            String fq = ((Facet)facets.get(0)).toString();
            for (int i = 1; i < facets.size(); ++i) {
                fq = fq + " OR " + ((Facet)facets.get(i)).toString();
            }
            ArrayList<Facet> array = new ArrayList<Facet>();
            array.add(Facet.parseFacet((String)fq));
            mapLayer.setFacets(array);
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        String metadata = "";
        metadata = metadata + "Merged WKT layers\nLayers: " + layerDisplayNames + "\n";
        metadata = metadata + "Name: " + this.layerName + " <br />\n";
        metadata = metadata + "Date: " + formatter.format(calendar.getTime()) + " <br />\n";
        mapLayer.getMapLayerMetadata().setMoreInfo(metadata);
        this.getMapComposer().getMapLayer(this.layerName).setDisplayName(this.txtLayerName.getValue());
        this.getMapComposer().redrawLayersList();
        this.ok = true;
        this.detach();
    }
}

