/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.add.area;

import au.org.ala.spatial.composer.add.area.AreaToolComposer;
import au.org.ala.spatial.composer.gazetteer.GazetteerPointSearch;
import au.org.ala.spatial.util.CommonData;
import au.org.emii.portal.composer.MapComposer;
import au.org.emii.portal.menu.MapLayer;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Button;
import org.zkoss.zul.Radio;
import org.zkoss.zul.Radiogroup;
import org.zkoss.zul.Textbox;

public class AreaMapPolygon
extends AreaToolComposer {
    private static final Logger LOGGER = Logger.getLogger(AreaMapPolygon.class);
    private Textbox txtLayerName;
    private Button btnOk;
    private Button btnClear;
    private Radiogroup rgPolygonLayers;
    private Textbox displayGeom;

    public void afterCompose() {
        super.afterCompose();
        this.txtLayerName.setValue(this.getMapComposer().getNextAreaLayerName(CommonData.lang((String)"default_area_layer_name")));
        this.btnOk.setDisabled(true);
        this.btnClear.setDisabled(true);
        Clients.evalJavaScript((String)"mapFrame.toggleClickHandler(false);");
    }

    public void onClick$btnOk(Event event) {
        MapLayer ml = this.getMapComposer().getMapLayer(this.layerName);
        ml.setDisplayName(this.txtLayerName.getValue());
        this.getMapComposer().redrawLayersList();
        this.ok = true;
        Clients.evalJavaScript((String)"mapFrame.toggleClickHandler(true);");
        String activeLayerName = "none";
        if (ml.getUri() != null) {
            activeLayerName = ml.getUri().replaceAll("^.*ALA:", "").replaceAll("&.*", "");
        }
        this.getMapComposer().setAttribute("activeLayerName", (Object)activeLayerName);
        try {
            if (this.rgPolygonLayers.getSelectedItem() == null) {
                if (this.rgPolygonLayers.getItemCount() > 0) {
                    this.getMapComposer().setAttribute("mappolygonlayer", this.rgPolygonLayers.getItemAtIndex(0).getValue());
                }
            } else {
                this.getMapComposer().setAttribute("mappolygonlayer", this.rgPolygonLayers.getSelectedItem().getValue());
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"failed to set map area polygon selected by the radio button selection", (Throwable)e);
        }
        this.detach();
    }

    public void onClick$btnClear(Event event) {
        MapComposer mc = this.getMapComposer();
        if (this.layerName != null && mc.getMapLayer(this.layerName) != null) {
            mc.removeLayer(this.layerName);
        }
        String script = mc.getOpenLayersJavascript().addFeatureSelectionTool();
        mc.getOpenLayersJavascript().execute(mc.getOpenLayersJavascript().getIFrameReferences() + script);
        this.displayGeom.setValue("");
        this.btnOk.setDisabled(true);
        this.btnClear.setDisabled(true);
    }

    public void onClick$btnCancel(Event event) {
        MapComposer mc = this.getMapComposer();
        if (this.layerName != null && mc.getMapLayer(this.layerName) != null) {
            mc.removeLayer(this.layerName);
        }
        Clients.evalJavaScript((String)"mapFrame.toggleClickHandler(true);");
        this.detach();
    }

    public void onCheck$rgPolygonLayers(Event event) {
        Radio selectedItem = this.rgPolygonLayers.getSelectedItem();
        String layerName = (String)selectedItem.getValue();
        MapComposer mc = this.getMapComposer();
        MapLayer ml = mc.getMapLayer(layerName);
        mc.removeLayer(layerName);
        mc.activateLayer(ml, true);
    }

    public void onSearchPoint(Event event) {
        String searchPoint = (String)event.getData();
        String lon = searchPoint.split(",")[0];
        String lat = searchPoint.split(",")[1];
        LOGGER.debug((Object)"*************************************");
        LOGGER.debug((Object)"CommonData.getLayerList");
        LOGGER.debug((Object)"*************************************");
        JSONArray layerlist = CommonData.getLayerListJSONArray();
        MapComposer mc = this.getMapComposer();
        List activeLayers = this.getPortalSession().getActiveLayers();
        Boolean searchComplete = false;
        for (int i = 0; i < activeLayers.size(); ++i) {
            MapLayer ml = (MapLayer)activeLayers.get(i);
            String activeLayerName = "none";
            if (ml.getUri() != null) {
                activeLayerName = ml.getUri().replaceAll("^.*ALA:", "").replaceAll("&.*", "");
            }
            LOGGER.debug((Object)("ACTIVE LAYER: " + activeLayerName));
            if (!ml.isDisplayed()) continue;
            for (int j = 0; j < layerlist.size() && !searchComplete.booleanValue(); ++j) {
                JSONObject jo = (JSONObject)layerlist.get(j);
                if (jo.get((Object)"type") == null || jo.get((Object)"type").toString().length() <= 0 || !"contextual".equalsIgnoreCase(jo.get((Object)"type").toString()) || !jo.get((Object)"name").toString().equalsIgnoreCase(activeLayerName)) continue;
                LOGGER.debug((Object)ml.getName());
                Map feature = GazetteerPointSearch.pointSearch((String)lon, (String)lat, (String)activeLayerName, (String)CommonData.getGeoServer());
                if (feature == null || !feature.containsKey("pid")) continue;
                this.layerName = mc.getMapLayer(this.txtLayerName.getValue()) == null ? this.txtLayerName.getValue() : mc.getNextAreaLayerName(this.txtLayerName.getValue());
                this.getMapComposer().addObjectByPid((String)feature.get("pid"), this.layerName, 1.0);
                this.btnOk.setDisabled(false);
                this.btnClear.setDisabled(false);
                mc.updateLayerControls();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readUrl(String feature) {
        StringBuilder content = new StringBuilder();
        HttpURLConnection conn = null;
        try {
            String line;
            URL url = new URL(feature);
            conn = (HttpURLConnection)url.openConnection();
            conn.connect();
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = rd.readLine()) != null) {
                content.append(line);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("failed to read URL: " + feature), (Throwable)e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.disconnect();
                }
                catch (Exception e) {
                    LOGGER.error((Object)("failed to close url: " + feature), (Throwable)e);
                }
            }
        }
        return content.toString();
    }
}

